/*
 * Decompiled with CFR 0.152.
 */
package org.apache.uima.aae.error;

import org.apache.uima.aae.error.ErrorResult;
import org.apache.uima.aae.error.ErrorResultComponentPath;
import org.apache.uima.aae.error.ErrorResultComponentPathImpl;
import org.apache.uima.aae.error.ErrorResultTDs;
import org.apache.uima.aae.error.ErrorResultTDsImpl;

public class ErrorResultBaseImpl
implements ErrorResult {
    private static final long serialVersionUID = -964940732231472225L;
    private ErrorResultComponentPath resultPath = new ErrorResultComponentPathImpl();
    private ErrorResultTDs resultTDs = new ErrorResultTDsImpl();
    private boolean wasTerminated = false;
    private boolean wasDisabled = false;
    private Throwable rootCause;

    @Override
    public void addComponentKeyPath(String aComponentKeyPath) {
        this.addComponentKeyPath(aComponentKeyPath, false, false);
    }

    @Override
    public void addComponentKeyPath(String aComponentKeyPath, boolean terminated, boolean disabled) {
        this.resultPath.add(aComponentKeyPath, 0);
        this.wasTerminated = terminated;
        this.wasDisabled = disabled;
        if (this.wasTerminated || this.wasDisabled) {
            ErrorResultTDsImpl.TDImpl td = new ErrorResultTDsImpl.TDImpl(aComponentKeyPath, this.wasTerminated, this.wasDisabled);
            this.resultTDs.add(td);
        }
    }

    @Override
    public ErrorResultComponentPath getComponentKeyPath() {
        return this.resultPath;
    }

    @Override
    public Throwable getRootCause() {
        return this.rootCause;
    }

    @Override
    public ErrorResultTDs getTDs() {
        return this.resultTDs;
    }

    @Override
    public void setDisabled() {
        this.wasDisabled = true;
    }

    @Override
    public void setRootCause(Throwable aThrowable) {
        Throwable t = aThrowable;
        Throwable prev = null;
        while ((t = t.getCause()) != null) {
            prev = t;
        }
        this.rootCause = prev == null ? aThrowable : prev;
    }

    @Override
    public void setTerminated() {
        this.wasTerminated = true;
    }

    @Override
    public boolean wasDisabled() {
        return this.wasDisabled;
    }

    @Override
    public boolean wasTerminated() {
        return this.wasTerminated;
    }
}

