/*
 * Decompiled with CFR 0.152.
 */
package org.apache.uima.aae;

import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.concurrent.RejectedExecutionException;
import java.util.concurrent.Semaphore;
import java.util.concurrent.ThreadPoolExecutor;
import org.apache.uima.UIMAFramework;
import org.apache.uima.util.Level;

public class UimaBlockingExecutor {
    private static final Class CLASS_NAME = UimaBlockingExecutor.class;
    private final ThreadPoolExecutor executor;
    private final Semaphore semaphore;
    private volatile boolean stopping = false;
    private String destination = null;

    public UimaBlockingExecutor(ThreadPoolExecutor executor, int permits) {
        this(executor, permits, null);
    }

    public UimaBlockingExecutor(ThreadPoolExecutor executor, int permits, String destination) {
        this.executor = executor;
        this.destination = destination;
        this.semaphore = new Semaphore(permits);
    }

    public boolean isReady() {
        return !this.executor.isShutdown() && !this.executor.isTerminating() && !this.executor.isShutdown();
    }

    public void stop() {
        this.stopping = true;
        this.semaphore.release();
        this.executor.purge();
        this.executor.shutdownNow();
    }

    public void submitTask(final Runnable task) throws InterruptedException, RejectedExecutionException {
        if (this.stopping) {
            return;
        }
        SimpleDateFormat timeFormatter = new SimpleDateFormat("H:mm:ss:SSS");
        if (UIMAFramework.getLogger((Class)CLASS_NAME).isLoggable(Level.FINEST)) {
            String extraInfo = "";
            if (this.destination != null) {
                extraInfo = " Executor Handling Messages from Destination:" + this.destination;
            }
            UIMAFramework.getLogger((Class)CLASS_NAME).logrb(Level.FINEST, CLASS_NAME.getName(), "submitTask", "uimaee_messages", "UIMAEE_dump_threadpool_semaphore_info__FINEST", new Object[]{timeFormatter.format(new Date()), Thread.currentThread().getId(), extraInfo, this.semaphore.availablePermits()});
        }
        this.semaphore.acquire();
        if (this.stopping) {
            return;
        }
        try {
            this.executor.execute(new Runnable(){

                @Override
                public void run() {
                    try {
                        task.run();
                    }
                    finally {
                        UimaBlockingExecutor.this.semaphore.release();
                    }
                }
            });
        }
        catch (RejectedExecutionException e) {
            this.semaphore.release();
            throw e;
        }
        catch (Exception e) {
            this.semaphore.release();
            e.printStackTrace();
        }
    }
}

