/*
 * Decompiled with CFR 0.152.
 */
package org.apache.uima.ruta.seed;

import java.util.Collection;
import java.util.LinkedList;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.uima.cas.CAS;
import org.apache.uima.cas.CASException;
import org.apache.uima.cas.FeatureStructure;
import org.apache.uima.cas.Type;
import org.apache.uima.cas.text.AnnotationFS;
import org.apache.uima.fit.util.CasUtil;
import org.apache.uima.jcas.JCas;
import org.apache.uima.ruta.seed.TextSeeder;
import org.apache.uima.ruta.type.MARKUP;

public class DefaultSeeder
extends TextSeeder {
    public static final String seedType = "org.apache.uima.ruta.type.TokenSeed";
    private final Pattern markupPattern = Pattern.compile("</?\\w[\\w-]*((\\s+[\\w-]+(\\s*=\\s*(?:\".*?\"|'.*?'|[^'\">\\s]+))?)+\\s*|\\s*)/?>");
    private final Pattern xmlCommentPattern = Pattern.compile("<!--[\\s\\S\n]*?-->");

    @Override
    public Type seed(String text, CAS cas) {
        Type result = super.seed(text, cas);
        JCas jCas = null;
        try {
            jCas = cas.getJCas();
        }
        catch (CASException e) {
            throw new RuntimeException(e);
        }
        if (text != null) {
            LinkedList<AnnotationFS> toRemove = new LinkedList<AnnotationFS>();
            this.addMarkupAnnotations(text, result, this.xmlCommentPattern, jCas, toRemove);
            this.addMarkupAnnotations(text, result, this.markupPattern, jCas, toRemove);
            for (AnnotationFS each : toRemove) {
                cas.removeFsFromIndexes((FeatureStructure)each);
            }
        }
        return result;
    }

    private void addMarkupAnnotations(String text, Type result, Pattern pattern, JCas jCas, Collection<AnnotationFS> toRemove) {
        Matcher matcher = pattern.matcher(text);
        while (matcher.find()) {
            int begin = matcher.start();
            int end = matcher.end();
            MARKUP markup = new MARKUP(jCas, begin, end);
            markup.addToIndexes();
            List selectCovered = CasUtil.selectCovered((Type)result, (AnnotationFS)markup);
            toRemove.addAll(selectCovered);
        }
    }
}

