/*
 * Decompiled with CFR 0.152.
 */
package org.apache.turbine.services.localization;

import java.util.Locale;
import org.apache.fulcrum.localization.DefaultLocalizationService;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.apache.logging.log4j.util.Supplier;
import org.apache.turbine.services.localization.RundataLocalizationInterface;
import org.apache.turbine.util.RunData;

public class RundataLocalizationService
extends DefaultLocalizationService
implements RundataLocalizationInterface {
    private static final Logger log = LogManager.getLogger(RundataLocalizationService.class);

    @Override
    public Locale getLocale(RunData data) {
        Object user = data.getUser();
        log.debug("retrieving lang from req header :{}", (Object)(user == null || user.getTemp("locale") == null ? 1 : 0));
        if (user == null) {
            return this.getLocale(data.getRequest().getHeader("Accept-Language"));
        }
        try {
            Locale locale = (Locale)data.getUser().getTemp("locale");
            if (locale == null) {
                return this.getLocale(data.getRequest().getHeader("Accept-Language"));
            }
            log.debug("retrieved lang from temp(locale):{}", new Supplier[]{() -> locale.getLanguage()});
            return locale;
        }
        catch (Exception use) {
            return this.getLocale(data.getRequest().getHeader("Accept-Language"));
        }
    }
}

