/*
 * Decompiled with CFR 0.152.
 */
package nl.basjes.parse.useragent.clienthints.parsers;

import java.util.Map;
import javax.annotation.Nonnull;
import nl.basjes.parse.useragent.AbstractUserAgentAnalyzerDirect;
import nl.basjes.parse.useragent.clienthints.ClientHints;
import nl.basjes.parse.useragent.clienthints.parsers.CHParser;

public class ParseSecChUaFullVersion
implements CHParser {
    public static final String HEADER_FIELD = "Sec-CH-UA-Full-Version";
    public static final String HEADER_SPEC_URL = "https://wicg.github.io/ua-client-hints/#sec-ch-ua-full-version";
    public static final String HEADER_SPEC = "The Sec-CH-UA-Full-Version request header field gives a server information about the user agent\u2019s full version. Sec-CH-UA-Full-Version is deprecated and will be removed in the future. Developers should use Sec-CH-UA-Full-Version-List instead.";
    public static final String FIELD_NAME = "secChUaFullVersion";

    @Override
    @Nonnull
    public ClientHints parse(@Nonnull Map<String, String> clientHintsHeaders, @Nonnull ClientHints clientHints, @Nonnull String headerName) {
        String input = clientHintsHeaders.get(headerName);
        String value = this.parseSfString(input);
        if (value != null && !value.isEmpty()) {
            clientHints.setFullVersion(value);
        }
        return clientHints;
    }

    @Override
    @Nonnull
    public String inputField() {
        return HEADER_FIELD;
    }

    public static AbstractUserAgentAnalyzerDirect.HeaderSpecification getHeaderSpecification() {
        return new AbstractUserAgentAnalyzerDirect.HeaderSpecification(HEADER_FIELD, HEADER_SPEC_URL, HEADER_SPEC, FIELD_NAME);
    }
}

