/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fulcrum.intake.model;

import org.apache.fulcrum.intake.IntakeException;
import org.apache.fulcrum.intake.model.Field;
import org.apache.fulcrum.intake.model.Group;
import org.apache.fulcrum.intake.model.XmlField;
import org.apache.fulcrum.intake.validator.DoubleValidator;

public class DoubleField
extends Field<Double> {
    private static final long serialVersionUID = -1685467778904884936L;

    public DoubleField(XmlField field, Group group) throws IntakeException {
        super(field, group);
    }

    @Override
    public void setDefaultValue(String prop) {
        this.defaultValue = null;
        if (prop == null) {
            return;
        }
        this.defaultValue = new Double(prop);
    }

    @Override
    public void setEmptyValue(String prop) {
        this.emptyValue = null;
        if (prop == null) {
            return;
        }
        this.emptyValue = new Double(prop);
    }

    @Override
    protected Object getSafeEmptyValue() {
        if (this.isMultiValued()) {
            return new double[0];
        }
        return null == this.getEmptyValue() ? new Double(0.0) : this.getEmptyValue();
    }

    @Override
    protected String getDefaultValidator() {
        return DoubleValidator.class.getName();
    }

    @Override
    protected void doSetValue() {
        if (this.isMultiValued()) {
            Double[] inputs = this.parser.getDoubleObjects(this.getKey());
            double[] values = new double[inputs.length];
            for (int i = 0; i < inputs.length; ++i) {
                values[i] = inputs[i] == null ? ((Double)this.getEmptyValue()).doubleValue() : inputs[i].doubleValue();
            }
            this.setTestValue(values);
        } else {
            this.setTestValue(this.parser.getDoubleObject(this.getKey(), (Double)this.getEmptyValue()));
        }
    }
}

