/*
 * Decompiled with CFR 0.152.
 */
package org.apache.turbine.modules.actions;

import org.apache.commons.configuration.Configuration;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.turbine.Turbine;
import org.apache.turbine.modules.Action;
import org.apache.turbine.om.security.User;
import org.apache.turbine.pipeline.PipelineData;
import org.apache.turbine.services.security.TurbineSecurity;
import org.apache.turbine.util.RunData;
import org.apache.turbine.util.security.DataBackendException;
import org.apache.turbine.util.security.TurbineSecurityException;

@Deprecated
public class LoginUser
extends Action {
    public static final String CGI_USERNAME = "username";
    public static final String CGI_PASSWORD = "password";
    private static Log log = LogFactory.getLog(LoginUser.class);

    @Override
    public void doPerform(RunData data) throws TurbineSecurityException {
        String username = data.getParameters().getString(CGI_USERNAME, "");
        String password = data.getParameters().getString(CGI_PASSWORD, "");
        if (StringUtils.isEmpty((String)username)) {
            return;
        }
        try {
            User user = TurbineSecurity.getAuthenticatedUser(username, password);
            data.setUser(user);
            user.setHasLoggedIn(Boolean.TRUE);
            user.updateLastLogin();
            data.save();
        }
        catch (Exception e) {
            Configuration conf = Turbine.getConfiguration();
            if (e instanceof DataBackendException) {
                log.error((Object)e);
            }
            data.setMessage(conf.getString("login.error", ""));
            data.setUser(TurbineSecurity.getAnonymousUser());
            String loginTemplate = conf.getString("template.login");
            if (StringUtils.isNotEmpty((String)loginTemplate)) {
                data.setScreenTemplate(loginTemplate);
            }
            data.setScreen(conf.getString("screen.login"));
        }
    }

    @Override
    public void doPerform(PipelineData pipelineData) throws TurbineSecurityException {
        RunData data = this.getRunData(pipelineData);
        this.doPerform(data);
    }
}

