/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fulcrum.parser;

import java.io.UnsupportedEncodingException;
import java.net.URLDecoder;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.List;
import java.util.StringTokenizer;
import javax.servlet.http.HttpServletRequest;
import org.apache.avalon.framework.service.ServiceException;
import org.apache.commons.fileupload.FileItem;
import org.apache.commons.lang.ArrayUtils;
import org.apache.fulcrum.parser.BaseValueParser;
import org.apache.fulcrum.parser.ParameterParser;

public class DefaultParameterParser
extends BaseValueParser
implements ParameterParser {
    private HttpServletRequest request = null;
    private byte[] uploadData = null;

    public DefaultParameterParser() {
    }

    public DefaultParameterParser(String characterEncoding) {
        super(characterEncoding);
    }

    public void dispose() {
        this.request = null;
        this.uploadData = null;
        super.dispose();
    }

    public HttpServletRequest getRequest() {
        return this.request;
    }

    public void setRequest(HttpServletRequest request) {
        String paramName;
        block16: {
            this.clear();
            this.uploadData = null;
            String enc = request.getCharacterEncoding();
            this.setCharacterEncoding(enc != null ? enc : this.parserService.getParameterEncoding());
            String contentType = request.getHeader("Content-type");
            if (this.parserService.getAutomaticUpload() && contentType != null && contentType.startsWith("multipart/form-data")) {
                if (this.getLogger().isDebugEnabled()) {
                    this.getLogger().debug("Running the Fulcrum Upload Service");
                }
                try {
                    List fileItems = this.parserService.parseUpload(request);
                    if (fileItems == null) break block16;
                    Iterator it = fileItems.iterator();
                    while (it.hasNext()) {
                        FileItem fi = (FileItem)it.next();
                        if (fi.isFormField()) {
                            this.getLogger().debug("Found an simple form field: " + fi.getFieldName() + ", adding value " + fi.getString());
                            String value = null;
                            try {
                                value = fi.getString(this.getCharacterEncoding());
                            }
                            catch (UnsupportedEncodingException e) {
                                this.getLogger().error(this.getCharacterEncoding() + " encoding is not supported." + "Used the default when reading form data.");
                                value = fi.getString();
                            }
                            this.add(fi.getFieldName(), value);
                            continue;
                        }
                        this.getLogger().debug("Found an uploaded file: " + fi.getFieldName());
                        this.getLogger().debug("It has " + fi.getSize() + " Bytes and is " + (fi.isInMemory() ? "" : "not ") + "in Memory");
                        this.getLogger().debug("Adding FileItem as " + fi.getFieldName() + " to the params");
                        this.add(fi.getFieldName(), fi);
                    }
                }
                catch (ServiceException e) {
                    this.getLogger().error("File upload failed", (Throwable)e);
                }
            }
        }
        Enumeration names = request.getParameterNames();
        while (names.hasMoreElements()) {
            paramName = (String)names.nextElement();
            this.add(paramName, request.getParameterValues(paramName));
        }
        try {
            boolean isNameTok = true;
            paramName = null;
            String paramValue = null;
            StringTokenizer st = new StringTokenizer(request.getPathInfo(), "/");
            while (st.hasMoreTokens()) {
                if (isNameTok) {
                    paramName = URLDecoder.decode(st.nextToken(), this.getCharacterEncoding());
                    isNameTok = false;
                    continue;
                }
                paramValue = URLDecoder.decode(st.nextToken(), this.getCharacterEncoding());
                if (paramName != null && paramName.length() > 0) {
                    this.add(paramName, paramValue);
                }
                isNameTok = true;
            }
        }
        catch (Exception e) {
            // empty catch block
        }
        this.request = request;
        if (this.getLogger().isDebugEnabled()) {
            this.getLogger().debug("Parameters found in the Request:");
            Iterator it = this.keySet().iterator();
            while (it.hasNext()) {
                String key = (String)it.next();
                this.getLogger().debug("Key: " + key + " -> " + this.getString(key));
            }
        }
    }

    public void setUploadData(byte[] uploadData) {
        this.uploadData = uploadData;
    }

    public byte[] getUploadData() {
        return this.uploadData;
    }

    public void append(String name, FileItem value) {
        this.add(name, value);
    }

    public void add(String name, FileItem value) {
        Object[] items = this.getFileItems(name);
        items = (FileItem[])ArrayUtils.add((Object[])items, (Object)value);
        this.parameters.put(this.convert(name), items);
    }

    public FileItem getFileItem(String name) {
        try {
            FileItem value = null;
            Object object = this.parameters.get(this.convert(name));
            if (object != null) {
                value = ((FileItem[])object)[0];
            }
            return value;
        }
        catch (ClassCastException e) {
            return null;
        }
    }

    public FileItem[] getFileItems(String name) {
        try {
            return (FileItem[])this.parameters.get(this.convert(name));
        }
        catch (ClassCastException e) {
            return null;
        }
    }
}

