/*
 * Decompiled with CFR 0.152.
 */
package org.apache.excalibur.instrument.manager.impl;

import org.apache.excalibur.instrument.manager.CounterInstrumentListener;
import org.apache.excalibur.instrument.manager.InstrumentDescriptor;
import org.apache.excalibur.instrument.manager.InstrumentSampleDescriptor;
import org.apache.excalibur.instrument.manager.InstrumentableDescriptor;
import org.apache.excalibur.instrument.manager.NoSuchInstrumentSampleException;
import org.apache.excalibur.instrument.manager.ValueInstrumentListener;
import org.apache.excalibur.instrument.manager.impl.InstrumentProxy;
import org.apache.excalibur.instrument.manager.impl.InstrumentSample;

public class InstrumentDescriptorImpl
implements InstrumentDescriptor {
    private InstrumentProxy m_instrumentProxy;

    InstrumentDescriptorImpl(InstrumentProxy instrumentProxy) {
        this.m_instrumentProxy = instrumentProxy;
    }

    public boolean isConfigured() {
        return this.m_instrumentProxy.isConfigured();
    }

    public boolean isRegistered() {
        return this.m_instrumentProxy.isRegistered();
    }

    public String getName() {
        return this.m_instrumentProxy.getName();
    }

    public String getDescription() {
        return this.m_instrumentProxy.getDescription();
    }

    public int getType() {
        return this.m_instrumentProxy.getType();
    }

    public InstrumentableDescriptor getInstrumentableDescriptor() {
        return this.m_instrumentProxy.getInstrumentableProxy().getDescriptor();
    }

    public void addCounterInstrumentListener(CounterInstrumentListener listener) {
        this.m_instrumentProxy.addCounterInstrumentListener(listener);
    }

    public void removeCounterInstrumentListener(CounterInstrumentListener listener) {
        this.m_instrumentProxy.removeCounterInstrumentListener(listener);
    }

    public void addValueInstrumentListener(ValueInstrumentListener listener) {
        this.m_instrumentProxy.addValueInstrumentListener(listener);
    }

    public void removeValueInstrumentListener(ValueInstrumentListener listener) {
        this.m_instrumentProxy.removeValueInstrumentListener(listener);
    }

    public InstrumentSampleDescriptor getInstrumentSampleDescriptor(String instrumentSampleName) throws NoSuchInstrumentSampleException {
        InstrumentSample instrumentSample = this.m_instrumentProxy.getInstrumentSample(instrumentSampleName);
        if (instrumentSample == null) {
            throw new NoSuchInstrumentSampleException("No instrument sample can be found using name: " + instrumentSampleName);
        }
        return instrumentSample.getDescriptor();
    }

    public InstrumentSampleDescriptor createInstrumentSample(String sampleDescription, long sampleInterval, int sampleSize, long sampleLease, int sampleType) {
        InstrumentSample sample = this.m_instrumentProxy.createInstrumentSample(sampleDescription, sampleInterval, sampleSize, sampleLease, sampleType);
        return sample.getDescriptor();
    }

    public InstrumentSampleDescriptor[] getInstrumentSampleDescriptors() {
        return this.m_instrumentProxy.getInstrumentSampleDescriptors();
    }

    public int getStateVersion() {
        return this.m_instrumentProxy.getStateVersion();
    }
}

