/*
 * Decompiled with CFR 0.152.
 */
package org.apache.turbine.services.intake.model;

import java.math.BigDecimal;
import org.apache.torque.om.NumberKey;
import org.apache.turbine.services.intake.IntakeException;
import org.apache.turbine.services.intake.model.Field;
import org.apache.turbine.services.intake.model.Group;
import org.apache.turbine.services.intake.validator.NumberKeyValidator;
import org.apache.turbine.services.intake.xmlmodel.XmlField;

public class NumberKeyField
extends Field {
    public NumberKeyField(XmlField field, Group group) throws IntakeException {
        super(field, group);
    }

    public void setDefaultValue(String prop) {
        if (prop == null) {
            return;
        }
        this.defaultValue = new NumberKey(prop);
    }

    public void setEmptyValue(String prop) {
        this.emptyValue = null;
        if (prop == null) {
            return;
        }
        this.emptyValue = new NumberKey(prop);
    }

    protected String getDefaultValidator() {
        return NumberKeyValidator.class.getName();
    }

    protected void doSetValue() {
        if (this.isMultiValued) {
            BigDecimal[] inputs = this.parser.getBigDecimals(this.getKey());
            NumberKey[] values = new NumberKey[inputs.length];
            for (int i = 0; i < inputs.length; ++i) {
                values[i] = inputs[i] == null ? (NumberKey)this.getEmptyValue() : new NumberKey(inputs[i]);
            }
            this.setTestValue(values);
        } else {
            BigDecimal value = this.parser.getBigDecimal(this.getKey());
            if (value == null) {
                this.setTestValue(this.getEmptyValue());
            } else {
                this.setTestValue(new NumberKey(value));
            }
        }
    }
}

