/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fulcrum.jce.crypto;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.security.GeneralSecurityException;
import org.apache.fulcrum.jce.crypto.CryptoStreamFactory;

public class SmartDecryptingInputStream
extends ByteArrayInputStream {
    private static final String[] ENCODINGS = new String[]{"ISO-8859-1", "UTF-8", "UTF-16"};

    public SmartDecryptingInputStream(CryptoStreamFactory cryptoStreamFactory, InputStream is) throws IOException, GeneralSecurityException {
        this(cryptoStreamFactory, is, null);
    }

    public SmartDecryptingInputStream(CryptoStreamFactory cryptoStreamFactory, InputStream is, char[] password) throws IOException, GeneralSecurityException {
        super(new byte[0]);
        byte[] content = null;
        byte[] plain = null;
        ByteArrayOutputStream baosCipher = new ByteArrayOutputStream();
        ByteArrayOutputStream baosPlain = new ByteArrayOutputStream();
        this.copy(is, baosCipher);
        plain = content = baosCipher.toByteArray();
        if (this.isEncrypted(content)) {
            InputStream cis = null;
            ByteArrayInputStream bais = new ByteArrayInputStream(content);
            cis = password != null && password.length > 0 ? cryptoStreamFactory.getInputStream(bais, password) : cryptoStreamFactory.getInputStream(bais);
            this.copy(cis, baosPlain);
            plain = baosPlain.toByteArray();
        }
        if (plain != null) {
            this.buf = plain;
            this.pos = 0;
            this.count = this.buf.length;
        }
    }

    private boolean isEncrypted(byte[] content) throws IOException {
        if (content.length == 0) {
            return false;
        }
        if (content.length % 8 != 0) {
            return false;
        }
        if (this.isPDF(content)) {
            return false;
        }
        if (this.isXML(content)) {
            return false;
        }
        if (this.isZip(content)) {
            return false;
        }
        if (this.isUtf16Text(content)) {
            return false;
        }
        for (int i = 0; i < content.length; ++i) {
            char ch = (char)content[i];
            if (!this.isAsciiControl(ch)) continue;
            return true;
        }
        return false;
    }

    public void copy(InputStream is, OutputStream os) throws IOException {
        byte[] buf = new byte[1024];
        int n = 0;
        int total = 0;
        while ((n = is.read(buf)) > 0) {
            os.write(buf, 0, n);
            total += n;
        }
        is.close();
        os.flush();
        os.close();
    }

    private int count(byte[] content, byte value) {
        int result = 0;
        for (int i = 0; i < content.length; ++i) {
            if (content[i] != value) continue;
            ++result;
        }
        return result;
    }

    private boolean hasByteOrderMark(byte[] content) {
        return content[0] == 255 && content[1] == 255 || content[0] == 255 && content[1] == 255;
    }

    private boolean isUtf16Text(byte[] content) throws IOException {
        if (content.length < 2) {
            return false;
        }
        if (this.hasByteOrderMark(content)) {
            int estimate = (content.length - 2) / 3;
            if (this.count(content, (byte)0) > estimate) {
                return true;
            }
        }
        return false;
    }

    private boolean isXML(byte[] content) throws IOException {
        if (content.length < 3) {
            return false;
        }
        for (int i = 0; i < ENCODINGS.length; ++i) {
            String currEncoding = ENCODINGS[i];
            String temp = new String(content, currEncoding);
            if (temp.indexOf("<?xml") < 0 || temp.indexOf("?>") <= 0) continue;
            return true;
        }
        return false;
    }

    private boolean isZip(byte[] content) {
        if (content.length < 64) {
            return false;
        }
        return content[0] == 80 && content[1] == 75 && content[2] == 3 && content[3] == 4;
    }

    private boolean isPDF(byte[] content) throws IOException {
        if (content.length < 64) {
            return false;
        }
        return content[0] == 37 && content[1] == 80 && content[2] == 68 && content[3] == 70 && content[4] == 45 && content[5] == 49 && content[6] == 46;
    }

    private boolean isAsciiControl(char ch) {
        if (ch >= '\u0000' && ch <= '\u001f') {
            return true;
        }
        return true;
    }
}

