/*
 * Decompiled with CFR 0.152.
 */
package org.apache.myfaces.config.impl.element;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.logging.Logger;
import org.apache.myfaces.config.element.AbsoluteOrdering;
import org.apache.myfaces.config.element.Application;
import org.apache.myfaces.config.element.Behavior;
import org.apache.myfaces.config.element.Component;
import org.apache.myfaces.config.element.ComponentTagDeclaration;
import org.apache.myfaces.config.element.Converter;
import org.apache.myfaces.config.element.FacesConfig;
import org.apache.myfaces.config.element.FacesConfigExtension;
import org.apache.myfaces.config.element.FacesFlowDefinition;
import org.apache.myfaces.config.element.Factory;
import org.apache.myfaces.config.element.NamedEvent;
import org.apache.myfaces.config.element.NavigationRule;
import org.apache.myfaces.config.element.Ordering;
import org.apache.myfaces.config.element.RenderKit;
import org.apache.myfaces.config.element.facelets.FaceletTagLibrary;

public class FacesConfigImpl
extends FacesConfig
implements Serializable {
    private static final long serialVersionUID = 1L;
    private static final Logger LOG = Logger.getLogger(FacesConfigImpl.class.getName());
    private List<Application> applications;
    private List<Factory> factories;
    private List<Component> components;
    private List<ComponentTagDeclaration> componentTagDeclarations;
    private List<Converter> converters;
    private List<NavigationRule> navigationRules;
    private List<RenderKit> renderKits;
    private List<String> lifecyclePhaseListener;
    private Map<String, String> validators;
    private List<Behavior> behaviors;
    private List<NamedEvent> namedEvents;
    private List<FacesConfigExtension> facesConfigExtensions;
    private List<FacesFlowDefinition> facesFlowDefinitions;
    private List<String> protectedViewsUrlPatternList;
    private List<String> resourceResolvers;
    private List<FaceletTagLibrary> faceletTagLibraryList;
    private transient List<Application> unmodifiableApplications;
    private transient List<Factory> unmodifiableFactories;
    private transient List<Component> unmodifiableComponents;
    private transient List<ComponentTagDeclaration> unmodifiableComponentTagDeclarations;
    private transient List<Converter> unmodifiableConverters;
    private transient List<NavigationRule> unmodifiableNavigationRules;
    private transient List<RenderKit> unmodifiableRenderKits;
    private transient List<String> unmodifiableLifecyclePhaseListener;
    private transient Map<String, String> unmodifiableValidators;
    private transient List<Behavior> unmodifiableBehaviors;
    private transient List<NamedEvent> unmodifiableNamedEvents;
    private transient List<FacesConfigExtension> unmodifiableFacesConfigExtensions;
    private transient List<FacesFlowDefinition> unmodifiableFacesFlowDefinitions;
    private transient List<String> unmodifiableProtectedViewsUrlPatternList;
    private transient List<String> unmodifiableResourceResolvers;
    private transient List<FaceletTagLibrary> unmodifiableFaceletTagLibraryList;
    private String metadataComplete;
    private String version;
    private String name;
    private AbsoluteOrdering absoluteOrdering;
    private Ordering ordering;

    public void addApplication(Application application) {
        if (this.applications == null) {
            this.applications = new ArrayList<Application>();
        }
        this.applications.add(application);
    }

    public void addFactory(Factory factory) {
        if (this.factories == null) {
            this.factories = new ArrayList<Factory>();
        }
        this.factories.add(factory);
    }

    public void addComponent(Component component) {
        if (this.components == null) {
            this.components = new ArrayList<Component>();
        }
        this.components.add(component);
    }

    public void addComponentTagDeclaration(ComponentTagDeclaration tagDeclaration) {
        if (this.componentTagDeclarations == null) {
            this.componentTagDeclarations = new ArrayList<ComponentTagDeclaration>();
        }
        this.componentTagDeclarations.add(tagDeclaration);
    }

    public void addConverter(Converter converter) {
        if (this.converters == null) {
            this.converters = new ArrayList<Converter>();
        }
        this.converters.add(converter);
    }

    public void addNavigationRule(NavigationRule rule) {
        if (this.navigationRules == null) {
            this.navigationRules = new ArrayList<NavigationRule>();
        }
        this.navigationRules.add(rule);
    }

    public void addRenderKit(RenderKit renderKit) {
        if (this.renderKits == null) {
            this.renderKits = new ArrayList<RenderKit>();
        }
        this.renderKits.add(renderKit);
    }

    public void addLifecyclePhaseListener(String value) {
        if (this.lifecyclePhaseListener == null) {
            this.lifecyclePhaseListener = new ArrayList<String>();
        }
        this.lifecyclePhaseListener.add(value);
    }

    public void addValidator(String id, String validatorClass) {
        String oldValidator;
        if (this.validators == null) {
            this.validators = new HashMap<String, String>();
        }
        if ((oldValidator = this.validators.get(id)) != null && !oldValidator.startsWith("jakarta.faces.validator.")) {
            LOG.warning("There is already a validator defined for id: " + id + ". old: " + oldValidator + " new: " + validatorClass);
        }
        this.validators.put(id, validatorClass);
    }

    public void addBehavior(Behavior behavior) {
        if (this.behaviors == null) {
            this.behaviors = new ArrayList<Behavior>();
        }
        this.behaviors.add(behavior);
    }

    public void addNamedEvent(NamedEvent namedEvent) {
        if (this.namedEvents == null) {
            this.namedEvents = new ArrayList<NamedEvent>();
        }
        this.namedEvents.add(namedEvent);
    }

    public void addFacesConfigExtension(FacesConfigExtension elem) {
        if (this.facesConfigExtensions == null) {
            this.facesConfigExtensions = new ArrayList<FacesConfigExtension>();
        }
        this.facesConfigExtensions.add(elem);
    }

    public void addFacesFlowDefinition(FacesFlowDefinition elem) {
        if (this.facesFlowDefinitions == null) {
            this.facesFlowDefinitions = new ArrayList<FacesFlowDefinition>();
        }
        this.facesFlowDefinitions.add(elem);
    }

    public void addProtectedViewUrlPattern(String urlPattern) {
        if (this.protectedViewsUrlPatternList == null) {
            this.protectedViewsUrlPatternList = new ArrayList<String>();
        }
        this.protectedViewsUrlPatternList.add(urlPattern);
    }

    public void addResourceResolver(String resourceResolverClass) {
        if (this.resourceResolvers == null) {
            this.resourceResolvers = new ArrayList<String>();
        }
        this.resourceResolvers.add(resourceResolverClass);
    }

    public void addFaceletTagLibrary(FaceletTagLibrary library) {
        if (this.faceletTagLibraryList == null) {
            this.faceletTagLibraryList = new ArrayList<FaceletTagLibrary>();
        }
        this.faceletTagLibraryList.add(library);
    }

    @Override
    public List<Application> getApplications() {
        if (this.applications == null) {
            return Collections.emptyList();
        }
        if (this.unmodifiableApplications == null) {
            this.unmodifiableApplications = Collections.unmodifiableList(this.applications);
        }
        return this.unmodifiableApplications;
    }

    @Override
    public List<Factory> getFactories() {
        if (this.factories == null) {
            return Collections.emptyList();
        }
        if (this.unmodifiableFactories == null) {
            this.unmodifiableFactories = Collections.unmodifiableList(this.factories);
        }
        return this.unmodifiableFactories;
    }

    @Override
    public List<Component> getComponents() {
        if (this.components == null) {
            return Collections.emptyList();
        }
        if (this.unmodifiableComponents == null) {
            this.unmodifiableComponents = Collections.unmodifiableList(this.components);
        }
        return this.unmodifiableComponents;
    }

    @Override
    public List<ComponentTagDeclaration> getComponentTagDeclarations() {
        if (this.componentTagDeclarations == null) {
            return Collections.emptyList();
        }
        if (this.unmodifiableComponentTagDeclarations == null) {
            this.unmodifiableComponentTagDeclarations = Collections.unmodifiableList(this.componentTagDeclarations);
        }
        return this.unmodifiableComponentTagDeclarations;
    }

    @Override
    public List<Converter> getConverters() {
        if (this.converters == null) {
            return Collections.emptyList();
        }
        if (this.unmodifiableConverters == null) {
            this.unmodifiableConverters = Collections.unmodifiableList(this.converters);
        }
        return this.unmodifiableConverters;
    }

    @Override
    public List<NavigationRule> getNavigationRules() {
        if (this.navigationRules == null) {
            return Collections.emptyList();
        }
        if (this.unmodifiableNavigationRules == null) {
            this.unmodifiableNavigationRules = Collections.unmodifiableList(this.navigationRules);
        }
        return this.unmodifiableNavigationRules;
    }

    @Override
    public List<RenderKit> getRenderKits() {
        if (this.renderKits == null) {
            return Collections.emptyList();
        }
        if (this.unmodifiableRenderKits == null) {
            this.unmodifiableRenderKits = Collections.unmodifiableList(this.renderKits);
        }
        return this.unmodifiableRenderKits;
    }

    @Override
    public List<String> getLifecyclePhaseListener() {
        if (this.lifecyclePhaseListener == null) {
            return Collections.emptyList();
        }
        if (this.unmodifiableLifecyclePhaseListener == null) {
            this.unmodifiableLifecyclePhaseListener = Collections.unmodifiableList(this.lifecyclePhaseListener);
        }
        return this.unmodifiableLifecyclePhaseListener;
    }

    @Override
    public Map<String, String> getValidators() {
        if (this.validators == null) {
            return Collections.emptyMap();
        }
        if (this.unmodifiableValidators == null) {
            this.unmodifiableValidators = Collections.unmodifiableMap(this.validators);
        }
        return this.unmodifiableValidators;
    }

    @Override
    public List<Behavior> getBehaviors() {
        if (this.behaviors == null) {
            return Collections.emptyList();
        }
        if (this.unmodifiableBehaviors == null) {
            this.unmodifiableBehaviors = Collections.unmodifiableList(this.behaviors);
        }
        return this.unmodifiableBehaviors;
    }

    @Override
    public List<NamedEvent> getNamedEvents() {
        if (this.namedEvents == null) {
            return Collections.emptyList();
        }
        if (this.unmodifiableNamedEvents == null) {
            this.unmodifiableNamedEvents = Collections.unmodifiableList(this.namedEvents);
        }
        return this.unmodifiableNamedEvents;
    }

    @Override
    public RenderKit getRenderKit(String renderKitId) {
        for (RenderKit rk : this.getRenderKits()) {
            if (renderKitId != null && renderKitId.equals(rk.getId())) {
                return rk;
            }
            if (renderKitId != null || rk.getId() != null) continue;
            return rk;
        }
        return null;
    }

    @Override
    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    @Override
    public AbsoluteOrdering getAbsoluteOrdering() {
        return this.absoluteOrdering;
    }

    public void setAbsoluteOrdering(AbsoluteOrdering absoluteOrdering) {
        this.absoluteOrdering = absoluteOrdering;
    }

    @Override
    public Ordering getOrdering() {
        return this.ordering;
    }

    public void setOrdering(Ordering ordering) {
        this.ordering = ordering;
    }

    @Override
    public String getMetadataComplete() {
        return this.metadataComplete;
    }

    public void setMetadataComplete(String metadataComplete) {
        this.metadataComplete = metadataComplete;
    }

    @Override
    public String getVersion() {
        return this.version;
    }

    public void setVersion(String version) {
        this.version = version;
    }

    @Override
    public List<FacesConfigExtension> getFacesConfigExtensions() {
        if (this.facesConfigExtensions == null) {
            return Collections.emptyList();
        }
        if (this.unmodifiableFacesConfigExtensions == null) {
            this.unmodifiableFacesConfigExtensions = Collections.unmodifiableList(this.facesConfigExtensions);
        }
        return this.unmodifiableFacesConfigExtensions;
    }

    @Override
    public List<FacesFlowDefinition> getFacesFlowDefinitions() {
        if (this.facesFlowDefinitions == null) {
            return Collections.emptyList();
        }
        if (this.unmodifiableFacesFlowDefinitions == null) {
            this.unmodifiableFacesFlowDefinitions = Collections.unmodifiableList(this.facesFlowDefinitions);
        }
        return this.unmodifiableFacesFlowDefinitions;
    }

    @Override
    public List<String> getProtectedViewsUrlPatternList() {
        if (this.protectedViewsUrlPatternList == null) {
            return Collections.emptyList();
        }
        if (this.unmodifiableProtectedViewsUrlPatternList == null) {
            this.unmodifiableProtectedViewsUrlPatternList = Collections.unmodifiableList(this.protectedViewsUrlPatternList);
        }
        return this.unmodifiableProtectedViewsUrlPatternList;
    }

    @Override
    public List<String> getResourceResolversList() {
        if (this.resourceResolvers == null) {
            return Collections.emptyList();
        }
        if (this.unmodifiableResourceResolvers == null) {
            this.unmodifiableResourceResolvers = Collections.unmodifiableList(this.resourceResolvers);
        }
        return this.unmodifiableResourceResolvers;
    }

    @Override
    public List<FaceletTagLibrary> getFaceletTagLibraryList() {
        if (this.faceletTagLibraryList == null) {
            return Collections.emptyList();
        }
        if (this.unmodifiableFaceletTagLibraryList == null) {
            this.unmodifiableFaceletTagLibraryList = Collections.unmodifiableList(this.faceletTagLibraryList);
        }
        return this.unmodifiableFaceletTagLibraryList;
    }
}

