/*
 * Decompiled with CFR 0.152.
 */
package org.opensaml.saml.saml1.core.impl;

import java.time.Instant;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.xml.namespace.QName;
import net.shibboleth.shared.annotation.constraint.Live;
import net.shibboleth.shared.annotation.constraint.NotLive;
import net.shibboleth.shared.annotation.constraint.Unmodifiable;
import net.shibboleth.shared.collection.CollectionSupport;
import org.opensaml.core.xml.XMLObject;
import org.opensaml.core.xml.util.IndexedXMLObjectChildrenList;
import org.opensaml.saml.common.AbstractSignableSAMLObject;
import org.opensaml.saml.common.SAMLVersion;
import org.opensaml.saml.saml1.core.Advice;
import org.opensaml.saml.saml1.core.Assertion;
import org.opensaml.saml.saml1.core.AttributeStatement;
import org.opensaml.saml.saml1.core.AuthenticationStatement;
import org.opensaml.saml.saml1.core.AuthorizationDecisionStatement;
import org.opensaml.saml.saml1.core.Conditions;
import org.opensaml.saml.saml1.core.Statement;
import org.opensaml.saml.saml1.core.SubjectStatement;
import org.opensaml.xmlsec.signature.Signature;

public class AssertionImpl
extends AbstractSignableSAMLObject
implements Assertion {
    @Nullable
    private String id;
    @Nullable
    private SAMLVersion version;
    @Nullable
    private String issuer;
    @Nullable
    private Instant issueInstant;
    @Nullable
    private Conditions conditions;
    @Nullable
    private Advice advice;
    @Nonnull
    private final IndexedXMLObjectChildrenList<Statement> statements = new IndexedXMLObjectChildrenList((XMLObject)this);

    protected AssertionImpl(@Nullable String namespaceURI, @Nonnull String elementLocalName, @Nullable String namespacePrefix) {
        super(namespaceURI, elementLocalName, namespacePrefix);
        this.version = SAMLVersion.VERSION_11;
    }

    @Nullable
    public Integer getMajorVersion() {
        return this.version != null ? Integer.valueOf(this.version.getMajorVersion()) : null;
    }

    @Nullable
    public Integer getMinorVersion() {
        return this.version != null ? Integer.valueOf(this.version.getMinorVersion()) : null;
    }

    @Nullable
    public SAMLVersion getVersion() {
        return this.version;
    }

    public void setVersion(@Nullable SAMLVersion newVersion) {
        this.version = (SAMLVersion)this.prepareForAssignment(this.version, newVersion);
    }

    @Nullable
    public String getID() {
        return this.id;
    }

    public void setID(@Nullable String newID) {
        String oldID = this.id;
        this.id = this.prepareForAssignment(this.id, newID);
        this.registerOwnID(oldID, this.id);
    }

    @Nullable
    public String getIssuer() {
        return this.issuer;
    }

    public void setIssuer(@Nullable String iss) {
        this.issuer = this.prepareForAssignment(this.issuer, iss);
    }

    @Nullable
    public Instant getIssueInstant() {
        return this.issueInstant;
    }

    public void setIssueInstant(@Nullable Instant instant) {
        this.issueInstant = (Instant)this.prepareForAssignment(this.issueInstant, instant);
    }

    @Nullable
    public Conditions getConditions() {
        return this.conditions;
    }

    public void setConditions(@Nullable Conditions c) {
        this.conditions = (Conditions)this.prepareForAssignment((XMLObject)this.conditions, (XMLObject)c);
    }

    @Nullable
    public Advice getAdvice() {
        return this.advice;
    }

    public void setAdvice(@Nullable Advice adv) {
        this.advice = (Advice)this.prepareForAssignment((XMLObject)this.advice, (XMLObject)adv);
    }

    @Nonnull
    @Live
    public List<Statement> getStatements() {
        return this.statements;
    }

    @Nonnull
    @Live
    public List<Statement> getStatements(@Nonnull QName typeOrName) {
        return this.statements.subList(typeOrName);
    }

    @Nonnull
    @Live
    public List<SubjectStatement> getSubjectStatements() {
        QName statementQName = new QName("urn:oasis:names:tc:SAML:1.0:assertion", "SubjectStatement");
        return this.statements.subList(statementQName);
    }

    @Nonnull
    @Live
    public List<AuthenticationStatement> getAuthenticationStatements() {
        QName statementQName = new QName("urn:oasis:names:tc:SAML:1.0:assertion", "AuthenticationStatement");
        return this.statements.subList(statementQName);
    }

    @Nonnull
    @Live
    public List<AttributeStatement> getAttributeStatements() {
        QName statementQName = new QName("urn:oasis:names:tc:SAML:1.0:assertion", "AttributeStatement");
        return this.statements.subList(statementQName);
    }

    @Nonnull
    @Live
    public List<AuthorizationDecisionStatement> getAuthorizationDecisionStatements() {
        QName statementQName = new QName("urn:oasis:names:tc:SAML:1.0:assertion", "AuthorizationDecisionStatement");
        return this.statements.subList(statementQName);
    }

    @Nullable
    public String getSignatureReferenceID() {
        return this.id;
    }

    @Nullable
    @NotLive
    @Unmodifiable
    public List<XMLObject> getOrderedChildren() {
        ArrayList<Object> children = new ArrayList<Object>();
        if (this.conditions != null) {
            children.add(this.conditions);
        }
        if (this.advice != null) {
            children.add(this.advice);
        }
        children.addAll((Collection<Object>)this.statements);
        Signature sig = this.getSignature();
        if (sig != null) {
            children.add(sig);
        }
        return CollectionSupport.copyToList(children);
    }
}

