/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sis.referencing.operation.transform;

import java.io.Serializable;
import java.util.Arrays;
import org.apache.sis.referencing.internal.Resources;
import org.apache.sis.referencing.operation.matrix.Matrix1;
import org.apache.sis.referencing.operation.provider.Interpolation1D;
import org.apache.sis.referencing.operation.transform.AbstractMathTransform;
import org.apache.sis.referencing.operation.transform.AbstractMathTransform1D;
import org.apache.sis.referencing.operation.transform.ConcatenatedTransformDirect1D;
import org.apache.sis.referencing.operation.transform.IdentityTransform1D;
import org.apache.sis.referencing.operation.transform.LinearTransform1D;
import org.apache.sis.referencing.operation.transform.MathTransforms;
import org.apache.sis.util.ComparisonMode;
import org.apache.sis.util.internal.Numerics;
import org.apache.sis.util.resources.Errors;
import org.opengis.parameter.ParameterDescriptorGroup;
import org.opengis.parameter.ParameterValueGroup;
import org.opengis.referencing.operation.MathTransform1D;
import org.opengis.referencing.operation.Matrix;
import org.opengis.referencing.operation.NoninvertibleTransformException;
import org.opengis.referencing.operation.TransformException;

final class LinearInterpolator1D
extends AbstractMathTransform1D
implements Serializable {
    private static final long serialVersionUID = -5025693608589996896L;
    private final double[] values;
    private final MathTransform1D inverse;

    private LinearInterpolator1D(double[] values) {
        this.values = values;
        double last = values[0];
        for (int i = 1; i < values.length; ++i) {
            if (last <= (last = values[i])) continue;
            this.inverse = null;
            return;
        }
        this.inverse = new Inverse(this);
    }

    private static MathTransform1D create(double[] values) {
        boolean isReverted;
        double tolerance;
        double value;
        int n = values.length - 1;
        double offset = values[0];
        double slope = (values[n] - offset) / (double)n;
        double as = Math.abs(slope);
        int i = 0;
        do {
            if (++i >= n) {
                return LinearTransform1D.create(slope, offset);
            }
            value = values[i];
            tolerance = Math.max(Math.abs(value), as) * 1.0E-13;
        } while (Numerics.epsilonEqual(value, Math.fma((double)i, slope, offset), tolerance));
        boolean bl = isReverted = slope < 0.0;
        if (isReverted) {
            for (i = 0; i <= n; ++i) {
                values[i] = -values[i];
            }
        }
        AbstractMathTransform tr = new LinearInterpolator1D(values);
        if (isReverted) {
            tr = new ConcatenatedTransformDirect1D((MathTransform1D)((Object)tr), LinearTransform1D.NEGATE);
        }
        return tr;
    }

    static MathTransform1D create(double[] preimage, double[] values) {
        int length;
        if (preimage == null) {
            if (values == null) {
                return IdentityTransform1D.INSTANCE;
            }
            length = values.length;
        } else {
            length = preimage.length;
            if (values != null && values.length != length) {
                throw new IllegalArgumentException(Errors.format((short)77));
            }
        }
        switch (length) {
            case 0: {
                throw new IllegalArgumentException(Errors.format((short)29, preimage != null ? "preimage" : "values"));
            }
            case 1: {
                return LinearTransform1D.constant(preimage != null ? preimage[0] : Double.NaN, values != null ? values[0] : Double.NaN);
            }
        }
        MathTransform1D tr = null;
        if (values != null) {
            tr = LinearInterpolator1D.create((double[])values.clone());
        }
        if (preimage != null) {
            MathTransform1D indexToValues = tr;
            try {
                tr = LinearInterpolator1D.create((double[])preimage.clone()).inverse();
            }
            catch (NoninvertibleTransformException e) {
                throw new IllegalArgumentException(Resources.format((short)55, "preimage"), e);
            }
            if (indexToValues != null) {
                tr = MathTransforms.concatenate(tr, indexToValues);
            }
        }
        return tr;
    }

    @Override
    public ParameterDescriptorGroup getParameterDescriptors() {
        return Interpolation1D.PARAMETERS;
    }

    @Override
    public ParameterValueGroup getParameterValues() {
        ParameterValueGroup p = this.getParameterDescriptors().createValue();
        p.parameter("values").setValue(this.values);
        return p;
    }

    @Override
    public boolean isIdentity() {
        for (int i = 0; i < this.values.length; ++i) {
            if (this.values[i] == (double)i) continue;
            return false;
        }
        return true;
    }

    @Override
    public Matrix transform(double[] srcPts, int srcOff, double[] dstPts, int dstOff, boolean derivate) throws TransformException {
        double d;
        double y;
        double x = srcPts[srcOff];
        if (x >= 0.0) {
            int i = (int)x;
            int n = this.values.length - 1;
            if (i < n) {
                double y0 = this.values[i];
                double y1 = this.values[i + 1];
                y = y0 * (1.0 - (x -= (double)i)) + y1 * x;
                d = y1 - y0;
            } else {
                double y1 = this.values[n];
                d = y1 - this.values[n - 1];
                y = (x - (double)n) * d + y1;
            }
        } else {
            double y0 = this.values[0];
            d = this.values[1] - y0;
            y = x * d + y0;
        }
        if (dstPts != null) {
            dstPts[dstOff] = y;
        }
        return derivate ? new Matrix1(d) : null;
    }

    @Override
    public double transform(double x) {
        if (x >= 0.0) {
            int i = (int)x;
            int n = this.values.length - 1;
            if (i < n) {
                return this.values[i] * (1.0 - (x -= (double)i)) + this.values[i + 1] * x;
            }
            double y1 = this.values[n];
            return (x - (double)n) * (y1 - this.values[n - 1]) + y1;
        }
        double y0 = this.values[0];
        return x * (this.values[1] - y0) + y0;
    }

    @Override
    public double derivative(double x) {
        int i = Math.max(0, Math.min(this.values.length - 2, (int)x));
        return this.values[i + 1] - this.values[i];
    }

    @Override
    public MathTransform1D inverse() throws NoninvertibleTransformException {
        return this.inverse != null ? this.inverse : super.inverse();
    }

    @Override
    protected int computeHashCode() {
        return super.computeHashCode() ^ Arrays.hashCode(this.values);
    }

    @Override
    public boolean equals(Object object, ComparisonMode mode) {
        if (super.equals(object, mode)) {
            return Arrays.equals(this.values, ((LinearInterpolator1D)object).values);
        }
        return false;
    }

    private static final class Inverse
    extends AbstractMathTransform1D.Inverse
    implements MathTransform1D,
    Serializable {
        private static final long serialVersionUID = -5112948223332095009L;
        private final LinearInterpolator1D forward;

        Inverse(LinearInterpolator1D forward) {
            this.forward = forward;
        }

        @Override
        public MathTransform1D inverse() {
            return this.forward;
        }

        @Override
        public Matrix transform(double[] srcPts, int srcOff, double[] dstPts, int dstOff, boolean derivate) throws TransformException {
            double d;
            double x;
            double[] values = this.forward.values;
            double y = srcPts[srcOff];
            int i = Arrays.binarySearch(values, y);
            if (i >= 0) {
                x = i;
                i = Math.max(1, Math.min(values.length - 1, i));
                d = values[i] - values[i - 1];
            } else if ((i ^= 0xFFFFFFFF) >= 1) {
                if (i < values.length) {
                    double y0 = values[i - 1];
                    d = values[i] - y0;
                    x = (y - y0) / d + (double)(i - 1);
                } else {
                    int n = values.length - 1;
                    double y1 = values[n];
                    d = y1 - values[n - 1];
                    x = (y - y1) / d + (double)n;
                }
            } else {
                double y0 = values[0];
                d = values[1] - y0;
                x = (y - y0) / d;
            }
            if (dstPts != null) {
                dstPts[dstOff] = x;
            }
            return derivate ? new Matrix1(1.0 / d) : null;
        }

        @Override
        public double transform(double y) {
            double[] values = this.forward.values;
            int i = Arrays.binarySearch(values, y);
            if (i >= 0) {
                return i;
            }
            if ((i ^= 0xFFFFFFFF) >= 1) {
                if (i < values.length) {
                    double y0 = values[i - 1];
                    return (y - y0) / (values[i] - y0) + (double)(i - 1);
                }
                int n = values.length - 1;
                double y1 = values[n];
                return (y - y1) / (y1 - values[n - 1]) + (double)n;
            }
            double y0 = values[0];
            return (y - y0) / (values[1] - y0);
        }

        @Override
        public double derivative(double y) {
            double[] values = this.forward.values;
            int i = Arrays.binarySearch(values, y);
            if (i < 0) {
                i ^= 0xFFFFFFFF;
            }
            i = Math.max(1, Math.min(values.length - 1, i));
            return 1.0 / (values[i] - values[i - 1]);
        }
    }
}

