/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdfs;

public class ReadStatistics {
    private long totalBytesRead;
    private long totalLocalBytesRead;
    private long totalShortCircuitBytesRead;
    private long totalZeroCopyBytesRead;

    public ReadStatistics() {
        this.clear();
    }

    public ReadStatistics(ReadStatistics rhs) {
        this.totalBytesRead = rhs.getTotalBytesRead();
        this.totalLocalBytesRead = rhs.getTotalLocalBytesRead();
        this.totalShortCircuitBytesRead = rhs.getTotalShortCircuitBytesRead();
        this.totalZeroCopyBytesRead = rhs.getTotalZeroCopyBytesRead();
    }

    public synchronized long getTotalBytesRead() {
        return this.totalBytesRead;
    }

    public synchronized long getTotalLocalBytesRead() {
        return this.totalLocalBytesRead;
    }

    public synchronized long getTotalShortCircuitBytesRead() {
        return this.totalShortCircuitBytesRead;
    }

    public synchronized long getTotalZeroCopyBytesRead() {
        return this.totalZeroCopyBytesRead;
    }

    public synchronized long getRemoteBytesRead() {
        return this.totalBytesRead - this.totalLocalBytesRead;
    }

    public synchronized void addRemoteBytes(long amt) {
        this.totalBytesRead += amt;
    }

    public synchronized void addLocalBytes(long amt) {
        this.totalBytesRead += amt;
        this.totalLocalBytesRead += amt;
    }

    public synchronized void addShortCircuitBytes(long amt) {
        this.totalBytesRead += amt;
        this.totalLocalBytesRead += amt;
        this.totalShortCircuitBytesRead += amt;
    }

    public synchronized void addZeroCopyBytes(long amt) {
        this.totalBytesRead += amt;
        this.totalLocalBytesRead += amt;
        this.totalShortCircuitBytesRead += amt;
        this.totalZeroCopyBytesRead += amt;
    }

    public synchronized void clear() {
        this.totalBytesRead = 0L;
        this.totalLocalBytesRead = 0L;
        this.totalShortCircuitBytesRead = 0L;
        this.totalZeroCopyBytesRead = 0L;
    }
}

