/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tez.dag.history.logging.ats;

import com.google.common.annotations.VisibleForTesting;
import java.io.IOException;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.yarn.api.records.ApplicationId;
import org.apache.hadoop.yarn.api.records.timeline.TimelineEntity;
import org.apache.hadoop.yarn.api.records.timeline.TimelineEntityGroupId;
import org.apache.hadoop.yarn.api.records.timeline.TimelinePutResponse;
import org.apache.hadoop.yarn.client.api.TimelineClient;
import org.apache.tez.common.ReflectionUtils;
import org.apache.tez.common.TezUtilsInternal;
import org.apache.tez.common.security.DAGAccessControls;
import org.apache.tez.common.security.HistoryACLPolicyException;
import org.apache.tez.common.security.HistoryACLPolicyManager;
import org.apache.tez.dag.api.DagTypeConverters;
import org.apache.tez.dag.api.TezReflectionException;
import org.apache.tez.dag.api.records.DAGProtos;
import org.apache.tez.dag.history.DAGHistoryEvent;
import org.apache.tez.dag.history.HistoryEvent;
import org.apache.tez.dag.history.HistoryEventType;
import org.apache.tez.dag.history.events.DAGRecoveredEvent;
import org.apache.tez.dag.history.events.DAGSubmittedEvent;
import org.apache.tez.dag.history.logging.EntityTypes;
import org.apache.tez.dag.history.logging.HistoryLoggingService;
import org.apache.tez.dag.history.logging.ats.HistoryEventTimelineConversion;
import org.apache.tez.dag.records.TezDAGID;
import org.apache.tez.hadoop.shim.HadoopShim;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ATSV15HistoryLoggingService
extends HistoryLoggingService {
    private static final Logger LOG = LoggerFactory.getLogger(ATSV15HistoryLoggingService.class);
    @VisibleForTesting
    LinkedBlockingQueue<DAGHistoryEvent> eventQueue = new LinkedBlockingQueue();
    private Thread eventHandlingThread;
    private AtomicBoolean stopped = new AtomicBoolean(false);
    private int eventCounter = 0;
    private int eventsProcessed = 0;
    private final Object lock = new Object();
    private boolean historyLoggingEnabled = true;
    @VisibleForTesting
    TimelineClient timelineClient;
    private HashSet<TezDAGID> skippedDAGs = new HashSet();
    private Map<TezDAGID, String> dagDomainIdMap = new HashMap<TezDAGID, String>();
    private long maxTimeToWaitOnShutdown;
    private boolean waitForeverOnShutdown = false;
    private long maxPollingTimeMillis;
    private String sessionDomainId;
    private static final String atsHistoryLoggingServiceClassName = ATSV15HistoryLoggingService.class.getName();
    private static final String atsHistoryACLManagerClassName = "org.apache.tez.dag.history.ats.acls.ATSV15HistoryACLPolicyManager";
    @VisibleForTesting
    HistoryACLPolicyManager historyACLPolicyManager;
    private int numDagsPerGroup;

    public ATSV15HistoryLoggingService() {
        super(ATSV15HistoryLoggingService.class.getName());
    }

    public void serviceInit(Configuration serviceConf) throws Exception {
        Configuration conf = new Configuration(serviceConf);
        String summaryEntityTypesStr = EntityTypes.TEZ_APPLICATION + "," + EntityTypes.TEZ_APPLICATION_ATTEMPT + "," + EntityTypes.TEZ_DAG_ID;
        if (conf.getBoolean("tez.am.ats.v15.override.summary-types", true)) {
            conf.set("yarn.timeline-service.entity-group-fs-store.summary-entity-types", summaryEntityTypesStr);
        }
        this.historyLoggingEnabled = conf.getBoolean("tez.am.history.logging.enabled", true);
        if (!this.historyLoggingEnabled) {
            LOG.info("ATSService: History Logging disabled. tez.am.history.logging.enabled set to false");
            return;
        }
        if (conf.getBoolean("yarn.timeline-service.enabled", false)) {
            this.timelineClient = TimelineClient.createTimelineClient();
            this.timelineClient.init(conf);
        } else {
            this.timelineClient = null;
            if (conf.get("tez.history.logging.service.class", "").equals(atsHistoryLoggingServiceClassName)) {
                LOG.warn(atsHistoryLoggingServiceClassName + " is disabled due to Timeline Service being disabled, " + "yarn.timeline-service.enabled" + " set to false");
            }
        }
        this.maxTimeToWaitOnShutdown = conf.getLong("tez.yarn.ats.event.flush.timeout.millis", -1L);
        this.maxPollingTimeMillis = conf.getInt("tez.yarn.ats.max.polling.time.per.event.millis", 10);
        if (this.maxTimeToWaitOnShutdown < 0L) {
            this.waitForeverOnShutdown = true;
        }
        LOG.info("Initializing " + ATSV15HistoryLoggingService.class.getSimpleName() + " with , maxPollingTime(ms)=" + this.maxPollingTimeMillis + ", waitTimeForShutdown(ms)=" + this.maxTimeToWaitOnShutdown + ", TimelineACLManagerClass=" + atsHistoryACLManagerClassName);
        try {
            this.historyACLPolicyManager = (HistoryACLPolicyManager)ReflectionUtils.createClazzInstance((String)atsHistoryACLManagerClassName);
            this.historyACLPolicyManager.setConf(conf);
        }
        catch (TezReflectionException e) {
            LOG.warn("Could not instantiate object for org.apache.tez.dag.history.ats.acls.ATSV15HistoryACLPolicyManager. ACLs cannot be enforced correctly for history data in Timeline", (Throwable)e);
            if (!conf.getBoolean("tez.allow.disabled.timeline-domains", false)) {
                throw e;
            }
            this.historyACLPolicyManager = null;
        }
        this.numDagsPerGroup = conf.getInt("tez.history.logging.timeline.num-dags-per-group", 1);
    }

    public void serviceStart() {
        if (!this.historyLoggingEnabled || this.timelineClient == null) {
            return;
        }
        this.timelineClient.start();
        try {
            this.sessionDomainId = this.createSessionDomain();
        }
        catch (IOException | HistoryACLPolicyException e) {
            LOG.warn("Could not setup history acls, disabling history logging.", e);
            this.historyLoggingEnabled = false;
            return;
        }
        this.eventHandlingThread = new Thread(new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                boolean interrupted = false;
                TezUtilsInternal.setHadoopCallerContext((HadoopShim)ATSV15HistoryLoggingService.this.appContext.getHadoopShim(), (ApplicationId)ATSV15HistoryLoggingService.this.appContext.getApplicationID());
                while (!(ATSV15HistoryLoggingService.this.stopped.get() || Thread.currentThread().isInterrupted() || interrupted)) {
                    if (ATSV15HistoryLoggingService.this.eventCounter != 0 && ATSV15HistoryLoggingService.this.eventCounter % 1000 == 0) {
                        if (ATSV15HistoryLoggingService.this.eventsProcessed != 0 && !ATSV15HistoryLoggingService.this.eventQueue.isEmpty()) {
                            LOG.info("Event queue stats, eventsProcessedSinceLastUpdate=" + ATSV15HistoryLoggingService.this.eventsProcessed + ", eventQueueSize=" + ATSV15HistoryLoggingService.this.eventQueue.size());
                        }
                        ATSV15HistoryLoggingService.this.eventCounter = 0;
                        ATSV15HistoryLoggingService.this.eventsProcessed = 0;
                    } else {
                        ++ATSV15HistoryLoggingService.this.eventCounter;
                    }
                    Object object = ATSV15HistoryLoggingService.this.lock;
                    synchronized (object) {
                        try {
                            DAGHistoryEvent event = ATSV15HistoryLoggingService.this.eventQueue.poll(ATSV15HistoryLoggingService.this.maxPollingTimeMillis, TimeUnit.MILLISECONDS);
                            if (event == null) {
                                continue;
                            }
                            if (!ATSV15HistoryLoggingService.this.isValidEvent(event)) {
                                continue;
                            }
                            try {
                                ATSV15HistoryLoggingService.this.handleEvents(event);
                                ATSV15HistoryLoggingService.this.eventsProcessed = ATSV15HistoryLoggingService.this.eventsProcessed + 1;
                            }
                            catch (Exception e) {
                                LOG.warn("Error handling events", (Throwable)e);
                            }
                        }
                        catch (InterruptedException e) {
                            interrupted = true;
                        }
                    }
                }
            }
        }, "HistoryEventHandlingThread");
        this.eventHandlingThread.start();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void serviceStop() {
        LOG.info("Stopping ATSService, eventQueueBacklog=" + this.eventQueue.size());
        this.stopped.set(true);
        if (this.eventHandlingThread != null) {
            this.eventHandlingThread.interrupt();
        }
        try {
            TezUtilsInternal.setHadoopCallerContext((HadoopShim)this.appContext.getHadoopShim(), (ApplicationId)this.appContext.getApplicationID());
            Object object = this.lock;
            synchronized (object) {
                if (!this.eventQueue.isEmpty()) {
                    LOG.warn("ATSService being stopped, eventQueueBacklog=" + this.eventQueue.size() + ", maxTimeLeftToFlush=" + this.maxTimeToWaitOnShutdown + ", waitForever=" + this.waitForeverOnShutdown);
                    long startTime = this.appContext.getClock().getTime();
                    long endTime = startTime + this.maxTimeToWaitOnShutdown;
                    while (this.waitForeverOnShutdown || endTime >= this.appContext.getClock().getTime()) {
                        try {
                            DAGHistoryEvent event = this.eventQueue.poll(this.maxPollingTimeMillis, TimeUnit.MILLISECONDS);
                            if (event == null) {
                                LOG.info("Event queue empty, stopping ATS Service");
                                break;
                            }
                            if (!this.isValidEvent(event)) continue;
                            try {
                                this.handleEvents(event);
                            }
                            catch (Exception e) {
                                LOG.warn("Error handling event", (Throwable)e);
                            }
                        }
                        catch (InterruptedException e) {
                            LOG.info("ATSService interrupted while shutting down. Exiting. EventQueueBacklog=" + this.eventQueue.size());
                        }
                    }
                }
            }
        }
        finally {
            this.appContext.getHadoopShim().clearHadoopCallerContext();
        }
        if (!this.eventQueue.isEmpty()) {
            LOG.warn("Did not finish flushing eventQueue before stopping ATSService, eventQueueBacklog=" + this.eventQueue.size());
        }
        if (this.timelineClient != null) {
            this.timelineClient.stop();
        }
        if (this.historyACLPolicyManager != null) {
            this.historyACLPolicyManager.close();
        }
    }

    @VisibleForTesting
    public TimelineEntityGroupId getGroupId(DAGHistoryEvent event) {
        switch (event.getHistoryEvent().getEventType()) {
            case DAG_SUBMITTED: 
            case DAG_INITIALIZED: 
            case DAG_STARTED: 
            case DAG_FINISHED: 
            case DAG_KILL_REQUEST: 
            case VERTEX_INITIALIZED: 
            case VERTEX_STARTED: 
            case VERTEX_CONFIGURE_DONE: 
            case VERTEX_FINISHED: 
            case TASK_STARTED: 
            case TASK_FINISHED: 
            case TASK_ATTEMPT_STARTED: 
            case TASK_ATTEMPT_FINISHED: 
            case DAG_COMMIT_STARTED: 
            case VERTEX_COMMIT_STARTED: 
            case VERTEX_GROUP_COMMIT_STARTED: 
            case VERTEX_GROUP_COMMIT_FINISHED: 
            case DAG_RECOVERED: {
                String entityGroupId = this.numDagsPerGroup > 1 ? event.getDagID().getGroupId(this.numDagsPerGroup) : event.getDagID().toString();
                return TimelineEntityGroupId.newInstance((ApplicationId)event.getDagID().getApplicationId(), (String)entityGroupId);
            }
            case APP_LAUNCHED: 
            case AM_LAUNCHED: 
            case AM_STARTED: 
            case CONTAINER_LAUNCHED: 
            case CONTAINER_STOPPED: {
                return TimelineEntityGroupId.newInstance((ApplicationId)this.appContext.getApplicationID(), (String)this.appContext.getApplicationID().toString());
            }
        }
        return null;
    }

    public void handle(DAGHistoryEvent event) {
        if (this.historyLoggingEnabled && this.timelineClient != null) {
            this.eventQueue.add(event);
        }
    }

    private boolean isValidEvent(DAGHistoryEvent event) {
        DAGRecoveredEvent dagRecoveredEvent;
        DAGSubmittedEvent dagSubmittedEvent;
        String dagName;
        HistoryEventType eventType = event.getHistoryEvent().getEventType();
        TezDAGID dagId = event.getDagID();
        if (eventType.equals((Object)HistoryEventType.DAG_SUBMITTED) && ((dagName = (dagSubmittedEvent = (DAGSubmittedEvent)event.getHistoryEvent()).getDAGName()) != null && dagName.startsWith("TezPreWarmDAG") || !dagSubmittedEvent.isHistoryLoggingEnabled())) {
            this.skippedDAGs.add(dagId);
            return false;
        }
        if (eventType.equals((Object)HistoryEventType.DAG_RECOVERED) && !(dagRecoveredEvent = (DAGRecoveredEvent)event.getHistoryEvent()).isHistoryLoggingEnabled()) {
            this.skippedDAGs.add(dagRecoveredEvent.getDagID());
            return false;
        }
        if (eventType.equals((Object)HistoryEventType.DAG_FINISHED) && this.skippedDAGs.remove(dagId)) {
            return false;
        }
        return dagId == null || !this.skippedDAGs.contains(dagId);
    }

    private void handleEvents(DAGHistoryEvent event) {
        String domainId = this.getDomainForEvent(event);
        if (event.getDagID() != null && this.skippedDAGs.contains(event.getDagID())) {
            return;
        }
        TimelineEntityGroupId groupId = this.getGroupId(event);
        List entities = HistoryEventTimelineConversion.convertToTimelineEntities((HistoryEvent)event.getHistoryEvent());
        for (TimelineEntity entity : entities) {
            this.logEntity(groupId, entity, domainId);
        }
    }

    private void logEntity(TimelineEntityGroupId groupId, TimelineEntity entity, String domainId) {
        if (this.historyACLPolicyManager != null && domainId != null && !domainId.isEmpty()) {
            this.historyACLPolicyManager.updateTimelineEntityDomain((Object)entity, domainId);
        }
        try {
            TimelinePutResponse response = this.timelineClient.putEntities(this.appContext.getApplicationAttemptId(), groupId, new TimelineEntity[]{entity});
            if (response != null && !response.getErrors().isEmpty()) {
                int count = response.getErrors().size();
                for (int i = 0; i < count; ++i) {
                    TimelinePutResponse.TimelinePutError err = (TimelinePutResponse.TimelinePutError)response.getErrors().get(i);
                    if (err.getErrorCode() == 0) continue;
                    LOG.warn("Could not post history event to ATS, atsPutError=" + err.getErrorCode() + ", entityId=" + err.getEntityId());
                }
            }
        }
        catch (Exception e) {
            LOG.warn("Could not handle history events", (Throwable)e);
        }
    }

    private String getDomainForEvent(DAGHistoryEvent event) {
        String domainId = this.sessionDomainId;
        if (this.historyACLPolicyManager == null) {
            return domainId;
        }
        TezDAGID dagId = event.getDagID();
        HistoryEvent historyEvent = event.getHistoryEvent();
        if (dagId == null || !HistoryEventType.isDAGSpecificEvent((HistoryEventType)historyEvent.getEventType())) {
            return domainId;
        }
        if (this.dagDomainIdMap.containsKey(dagId)) {
            domainId = this.dagDomainIdMap.get(dagId);
            if (historyEvent.getEventType() == HistoryEventType.DAG_FINISHED) {
                this.dagDomainIdMap.remove(dagId);
            }
        } else if (HistoryEventType.DAG_SUBMITTED == historyEvent.getEventType() || HistoryEventType.DAG_RECOVERED == historyEvent.getEventType()) {
            DAGProtos.DAGPlan dagPlan;
            Configuration conf;
            if (HistoryEventType.DAG_SUBMITTED == historyEvent.getEventType()) {
                conf = ((DAGSubmittedEvent)historyEvent).getConf();
                dagPlan = ((DAGSubmittedEvent)historyEvent).getDAGPlan();
            } else {
                conf = this.appContext.getCurrentDAG().getConf();
                dagPlan = this.appContext.getCurrentDAG().getJobPlan();
            }
            domainId = this.createDagDomain(conf, dagPlan, dagId);
            if (this.skippedDAGs.contains(dagId)) {
                return null;
            }
            this.dagDomainIdMap.put(dagId, domainId);
        }
        return domainId;
    }

    private String createSessionDomain() throws IOException, HistoryACLPolicyException {
        if (this.historyACLPolicyManager == null) {
            return null;
        }
        Map domainInfo = this.historyACLPolicyManager.setupSessionACLs(this.getConfig(), this.appContext.getApplicationID());
        if (domainInfo != null) {
            return (String)domainInfo.get("tez.yarn.ats.acl.session.domain.id");
        }
        return null;
    }

    private String createDagDomain(Configuration dagConf, DAGProtos.DAGPlan dagPlan, TezDAGID dagId) {
        if (!this.appContext.isSession()) {
            return this.sessionDomainId;
        }
        DAGAccessControls dagAccessControls = dagPlan.hasAclInfo() ? DagTypeConverters.convertDAGAccessControlsFromProto((DAGProtos.ACLInfo)dagPlan.getAclInfo()) : null;
        try {
            Map domainInfo = this.historyACLPolicyManager.setupSessionDAGACLs(dagConf, this.appContext.getApplicationID(), Integer.toString(dagId.getId()), dagAccessControls);
            if (domainInfo != null) {
                return (String)domainInfo.get("tez.yarn.ats.acl.dag.domain.id");
            }
            return this.sessionDomainId;
        }
        catch (IOException | HistoryACLPolicyException e) {
            LOG.warn("Could not setup ACLs for DAG, disabling history logging for dag.", e);
            this.skippedDAGs.add(dagId);
            return null;
        }
    }
}

