/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tez.dag.app.launcher;

import com.google.common.annotations.VisibleForTesting;
import java.net.UnknownHostException;
import java.util.List;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.service.AbstractService;
import org.apache.hadoop.yarn.event.Event;
import org.apache.hadoop.yarn.event.EventHandler;
import org.apache.tez.Utils;
import org.apache.tez.common.Preconditions;
import org.apache.tez.common.ReflectionUtils;
import org.apache.tez.common.security.JobTokenSecretManager;
import org.apache.tez.dag.api.NamedEntityDescriptor;
import org.apache.tez.dag.api.TezConstants;
import org.apache.tez.dag.api.TezException;
import org.apache.tez.dag.api.TezUncheckedException;
import org.apache.tez.dag.api.UserPayload;
import org.apache.tez.dag.app.AppContext;
import org.apache.tez.dag.app.ContainerLauncherContextImpl;
import org.apache.tez.dag.app.ServicePluginLifecycleAbstractService;
import org.apache.tez.dag.app.TaskCommunicatorManagerInterface;
import org.apache.tez.dag.app.dag.event.DAGAppMasterEventType;
import org.apache.tez.dag.app.dag.event.DAGAppMasterEventUserServiceFatalError;
import org.apache.tez.dag.app.launcher.ContainerLauncherWrapper;
import org.apache.tez.dag.app.launcher.LocalContainerLauncher;
import org.apache.tez.dag.app.launcher.TezContainerLauncherImpl;
import org.apache.tez.dag.app.rm.ContainerLauncherEvent;
import org.apache.tez.dag.app.rm.ContainerLauncherEventType;
import org.apache.tez.dag.app.rm.ContainerLauncherLaunchRequestEvent;
import org.apache.tez.dag.records.TezDAGID;
import org.apache.tez.serviceplugins.api.ContainerLaunchRequest;
import org.apache.tez.serviceplugins.api.ContainerLauncher;
import org.apache.tez.serviceplugins.api.ContainerLauncherContext;
import org.apache.tez.serviceplugins.api.ContainerStopRequest;
import org.apache.tez.serviceplugins.api.DagInfo;
import org.apache.tez.serviceplugins.api.ServicePluginError;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ContainerLauncherManager
extends AbstractService
implements EventHandler<ContainerLauncherEvent> {
    static final Logger LOG = LoggerFactory.getLogger(TezContainerLauncherImpl.class);
    @VisibleForTesting
    final ContainerLauncherWrapper[] containerLaunchers;
    @VisibleForTesting
    final ContainerLauncherContext[] containerLauncherContexts;
    protected final ServicePluginLifecycleAbstractService[] containerLauncherServiceWrappers;
    private final AppContext appContext;
    private final boolean isIncompleteCtor;

    public ContainerLauncherManager(AppContext context, TaskCommunicatorManagerInterface taskCommunicatorManagerInterface, String workingDirectory, List<NamedEntityDescriptor> containerLauncherDescriptors, boolean isLocalMode) throws TezException {
        super(ContainerLauncherManager.class.getName());
        this.isIncompleteCtor = false;
        this.appContext = context;
        if (containerLauncherDescriptors == null || containerLauncherDescriptors.isEmpty()) {
            throw new IllegalArgumentException("ContainerLauncherDescriptors must be specified");
        }
        this.containerLauncherContexts = new ContainerLauncherContext[containerLauncherDescriptors.size()];
        this.containerLaunchers = new ContainerLauncherWrapper[containerLauncherDescriptors.size()];
        this.containerLauncherServiceWrappers = new ServicePluginLifecycleAbstractService[containerLauncherDescriptors.size()];
        for (int i = 0; i < containerLauncherDescriptors.size(); ++i) {
            UserPayload userPayload = containerLauncherDescriptors.get(i).getUserPayload();
            ContainerLauncherContextImpl containerLauncherContext = new ContainerLauncherContextImpl(context, this, taskCommunicatorManagerInterface, userPayload, i);
            this.containerLauncherContexts[i] = containerLauncherContext;
            this.containerLaunchers[i] = new ContainerLauncherWrapper(this.createContainerLauncher(containerLauncherDescriptors.get(i), context, containerLauncherContext, taskCommunicatorManagerInterface, workingDirectory, i, isLocalMode));
            this.containerLauncherServiceWrappers[i] = new ServicePluginLifecycleAbstractService<ContainerLauncher>(this.containerLaunchers[i].getContainerLauncher());
        }
    }

    @VisibleForTesting
    public ContainerLauncherManager(AppContext context) {
        super(ContainerLauncherManager.class.getName());
        this.isIncompleteCtor = true;
        this.appContext = context;
        this.containerLaunchers = new ContainerLauncherWrapper[1];
        this.containerLauncherContexts = new ContainerLauncherContext[1];
        this.containerLauncherServiceWrappers = new ServicePluginLifecycleAbstractService[1];
    }

    @VisibleForTesting
    public void setContainerLauncher(ContainerLauncher containerLauncher) {
        Preconditions.checkState((this.isIncompleteCtor ? 1 : 0) != 0, (Object)"Can only be used with the Test constructor");
        this.containerLaunchers[0] = new ContainerLauncherWrapper(containerLauncher);
        this.containerLauncherContexts[0] = containerLauncher.getContext();
        this.containerLauncherServiceWrappers[0] = new ServicePluginLifecycleAbstractService<ContainerLauncher>(containerLauncher);
    }

    @VisibleForTesting
    ContainerLauncher createContainerLauncher(NamedEntityDescriptor containerLauncherDescriptor, AppContext context, ContainerLauncherContext containerLauncherContext, TaskCommunicatorManagerInterface taskCommunicatorManagerInterface, String workingDirectory, int containerLauncherIndex, boolean isPureLocalMode) throws TezException {
        if (containerLauncherDescriptor.getEntityName().equals(TezConstants.getTezYarnServicePluginName())) {
            return this.createYarnContainerLauncher(containerLauncherContext);
        }
        if (containerLauncherDescriptor.getEntityName().equals(TezConstants.getTezUberServicePluginName())) {
            return this.createUberContainerLauncher(containerLauncherContext, context, taskCommunicatorManagerInterface, workingDirectory, isPureLocalMode);
        }
        return this.createCustomContainerLauncher(containerLauncherContext, containerLauncherDescriptor);
    }

    @VisibleForTesting
    ContainerLauncher createYarnContainerLauncher(ContainerLauncherContext containerLauncherContext) {
        LOG.info("Creating DefaultContainerLauncher");
        return new TezContainerLauncherImpl(containerLauncherContext);
    }

    @VisibleForTesting
    ContainerLauncher createUberContainerLauncher(ContainerLauncherContext containerLauncherContext, AppContext context, TaskCommunicatorManagerInterface taskCommunicatorManagerInterface, String workingDirectory, boolean isLocalMode) throws TezException {
        LOG.info("Creating LocalContainerLauncher");
        try {
            return new LocalContainerLauncher(containerLauncherContext, context, taskCommunicatorManagerInterface, workingDirectory, isLocalMode);
        }
        catch (UnknownHostException e) {
            throw new TezUncheckedException((Throwable)e);
        }
    }

    @VisibleForTesting
    ContainerLauncher createCustomContainerLauncher(ContainerLauncherContext containerLauncherContext, NamedEntityDescriptor containerLauncherDescriptor) throws TezException {
        LOG.info("Creating container launcher {}:{} ", (Object)containerLauncherDescriptor.getEntityName(), (Object)containerLauncherDescriptor.getClassName());
        return (ContainerLauncher)ReflectionUtils.createClazzInstance((String)containerLauncherDescriptor.getClassName(), (Class[])new Class[]{ContainerLauncherContext.class}, (Object[])new Object[]{containerLauncherContext});
    }

    public void serviceInit(Configuration conf) {
        for (int i = 0; i < this.containerLaunchers.length; ++i) {
            this.containerLauncherServiceWrappers[i].init(conf);
        }
    }

    public void serviceStart() {
        for (int i = 0; i < this.containerLaunchers.length; ++i) {
            this.containerLauncherServiceWrappers[i].start();
        }
    }

    public void serviceStop() {
        for (int i = 0; i < this.containerLaunchers.length; ++i) {
            this.containerLauncherServiceWrappers[i].stop();
        }
    }

    public void dagComplete(TezDAGID dag, JobTokenSecretManager secretManager) {
        for (int i = 0; i < this.containerLaunchers.length; ++i) {
            this.containerLaunchers[i].dagComplete(dag, secretManager);
        }
    }

    public void dagSubmitted() {
    }

    public void handle(ContainerLauncherEvent event) {
        int launcherId = event.getLauncherId();
        String schedulerName = this.appContext.getTaskSchedulerName(event.getSchedulerId());
        String taskCommName = this.appContext.getTaskCommunicatorName(event.getTaskCommId());
        switch ((ContainerLauncherEventType)event.getType()) {
            case CONTAINER_LAUNCH_REQUEST: {
                ContainerLauncherLaunchRequestEvent launchEvent = (ContainerLauncherLaunchRequestEvent)event;
                ContainerLaunchRequest launchRequest = new ContainerLaunchRequest(launchEvent.getNodeId(), launchEvent.getContainerId(), launchEvent.getContainerToken(), launchEvent.getContainerLaunchContext(), launchEvent.getContainer(), schedulerName, taskCommName);
                try {
                    this.containerLaunchers[launcherId].launchContainer(launchRequest);
                }
                catch (Exception e) {
                    String msg = "Error when launching container, containerLauncher=" + Utils.getContainerLauncherIdentifierString(launcherId, this.appContext) + ", scheduler=" + Utils.getTaskSchedulerIdentifierString(event.getSchedulerId(), this.appContext) + ", taskCommunicator=" + Utils.getTaskCommIdentifierString(event.getTaskCommId(), this.appContext);
                    LOG.error(msg, (Throwable)e);
                    this.sendEvent((Event<?>)new DAGAppMasterEventUserServiceFatalError(DAGAppMasterEventType.CONTAINER_LAUNCHER_SERVICE_FATAL_ERROR, msg, e));
                }
                break;
            }
            case CONTAINER_STOP_REQUEST: {
                ContainerStopRequest stopRequest = new ContainerStopRequest(event.getNodeId(), event.getContainerId(), event.getContainerToken(), schedulerName, taskCommName);
                try {
                    this.containerLaunchers[launcherId].stopContainer(stopRequest);
                    break;
                }
                catch (Exception e) {
                    String msg = "Error when stopping container, containerLauncher=" + Utils.getContainerLauncherIdentifierString(launcherId, this.appContext) + ", scheduler=" + Utils.getTaskSchedulerIdentifierString(event.getSchedulerId(), this.appContext) + ", taskCommunicator=" + Utils.getTaskCommIdentifierString(event.getTaskCommId(), this.appContext);
                    LOG.error(msg, (Throwable)e);
                    this.sendEvent((Event<?>)new DAGAppMasterEventUserServiceFatalError(DAGAppMasterEventType.CONTAINER_LAUNCHER_SERVICE_FATAL_ERROR, msg, e));
                }
            }
        }
    }

    public void reportError(int containerLauncherIndex, ServicePluginError servicePluginError, String diagnostics, DagInfo dagInfo) {
        if (servicePluginError.getErrorType() == ServicePluginError.ErrorType.PERMANENT) {
            String msg = "Fatal Error reported by ContainerLauncher, containerLauncher=" + Utils.getContainerLauncherIdentifierString(containerLauncherIndex, this.appContext) + ", servicePluginError=" + servicePluginError + ", diagnostics= " + (diagnostics == null ? "" : diagnostics);
            LOG.error(msg);
            this.sendEvent((Event<?>)new DAGAppMasterEventUserServiceFatalError(DAGAppMasterEventType.CONTAINER_LAUNCHER_SERVICE_FATAL_ERROR, msg, null));
        } else {
            Utils.processNonFatalServiceErrorReport(Utils.getContainerLauncherIdentifierString(containerLauncherIndex, this.appContext), servicePluginError, diagnostics, dagInfo, this.appContext, "ContainerLauncher");
        }
    }

    private void sendEvent(Event<?> event) {
        this.appContext.getEventHandler().handle(event);
    }

    public String getContainerLauncherClassName(int containerLauncherIndex) {
        return this.containerLaunchers[containerLauncherIndex].getContainerLauncher().getClass().getName();
    }
}

