/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tapestry5.upload.internal.services;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import org.apache.commons.fileupload.FileItem;
import org.apache.commons.io.FilenameUtils;
import org.apache.tapestry5.upload.internal.services.UploadMessages;
import org.apache.tapestry5.upload.services.UploadedFile;

public class UploadedFileItem
implements UploadedFile {
    private final FileItem item;

    public UploadedFileItem(FileItem item) {
        this.item = item;
    }

    @Override
    public String getContentType() {
        return this.item.getContentType();
    }

    @Override
    public String getFileName() {
        return FilenameUtils.getName((String)this.getFilePath());
    }

    @Override
    public String getFilePath() {
        return this.item.getName();
    }

    @Override
    public long getSize() {
        return this.item.getSize();
    }

    @Override
    public InputStream getStream() {
        try {
            return this.item.getInputStream();
        }
        catch (IOException e) {
            throw new RuntimeException(UploadMessages.unableToOpenContentFile(this), e);
        }
    }

    @Override
    public boolean isInMemory() {
        return this.item.isInMemory();
    }

    @Override
    public void write(File file) {
        try {
            this.item.write(file);
        }
        catch (Exception e) {
            throw new RuntimeException(UploadMessages.writeFailure(file), e);
        }
    }

    public void cleanup() {
        this.item.delete();
    }
}

