/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tapestry5.internal.services;

import org.apache.tapestry5.services.ApplicationStateCreator;
import org.apache.tapestry5.services.ApplicationStatePersistenceStrategy;
import org.apache.tapestry5.services.Request;
import org.apache.tapestry5.services.Session;

public class SessionApplicationStatePersistenceStrategy
implements ApplicationStatePersistenceStrategy {
    static final String PREFIX = "sso:";
    private final Request request;

    public SessionApplicationStatePersistenceStrategy(Request request) {
        this.request = request;
    }

    protected Session getSession() {
        return this.request.getSession(true);
    }

    @Override
    public <T> T get(Class<T> ssoClass, ApplicationStateCreator<T> creator) {
        return (T)this.getOrCreate(ssoClass, creator);
    }

    protected <T> Object getOrCreate(Class<T> ssoClass, ApplicationStateCreator<T> creator) {
        String key;
        Session session = this.getSession();
        Object sso = session.getAttribute(key = this.buildKey(ssoClass));
        if (sso == null) {
            sso = creator.create();
            this.set(ssoClass, sso);
        }
        return sso;
    }

    @Override
    public <T> T getIfExists(Class<T> ssoClass) {
        Session session = this.request.getSession(false);
        if (session != null) {
            String key = this.buildKey(ssoClass);
            Object sso = session.getAttribute(key);
            return (T)(sso != null ? sso : null);
        }
        return null;
    }

    protected <T> String buildKey(Class<T> ssoClass) {
        return PREFIX + ssoClass.getName();
    }

    @Override
    public <T> void set(Class<T> ssoClass, T sso) {
        String key = this.buildKey(ssoClass);
        this.getSession().setAttribute(key, sso);
    }

    @Override
    public <T> boolean exists(Class<T> ssoClass) {
        Session session = this.request.getSession(false);
        return session != null && !session.isInvalidated() && session.getAttribute(this.buildKey(ssoClass)) != null;
    }
}

