/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sysds.runtime.controlprogram.caching;

import java.io.DataOutput;
import java.io.IOException;
import java.io.UTFDataFormatException;
import org.apache.sysds.runtime.data.SparseBlock;
import org.apache.sysds.runtime.io.IOUtilFunctions;
import org.apache.sysds.runtime.matrix.data.MatrixBlockDataOutput;

public class CacheDataOutput
implements DataOutput,
MatrixBlockDataOutput {
    protected final byte[] _buff;
    protected int _count;

    public CacheDataOutput(int size) {
        this(new byte[size]);
    }

    public CacheDataOutput(byte[] mem) {
        this._buff = mem;
        this._count = 0;
    }

    @Override
    public void write(int b) throws IOException {
        this._buff[this._count++] = (byte)b;
    }

    @Override
    public void write(byte[] b) throws IOException {
        System.arraycopy(b, 0, this._buff, this._count, b.length);
        this._count += b.length;
    }

    @Override
    public void write(byte[] b, int off, int len) throws IOException {
        System.arraycopy(b, off, this._buff, this._count, len);
        this._count += len;
    }

    @Override
    public void writeBoolean(boolean v) throws IOException {
        this._buff[this._count++] = (byte)(v ? 1 : 0);
    }

    @Override
    public void writeInt(int v) throws IOException {
        CacheDataOutput.intToBa(v, this._buff, this._count);
        this._count += 4;
    }

    @Override
    public void writeDouble(double v) throws IOException {
        long tmp = Double.doubleToRawLongBits(v);
        CacheDataOutput.longToBa(tmp, this._buff, this._count);
        this._count += 8;
    }

    @Override
    public void writeByte(int v) throws IOException {
        this._buff[this._count++] = (byte)v;
    }

    @Override
    public void writeBytes(String s) throws IOException {
        throw new IOException("Not supported.");
    }

    @Override
    public void writeChar(int v) throws IOException {
        this.writeShort(v);
    }

    @Override
    public void writeChars(String s) throws IOException {
        throw new IOException("Not supported.");
    }

    @Override
    public void writeFloat(float v) throws IOException {
        int tmp = Float.floatToRawIntBits(v);
        CacheDataOutput.intToBa(tmp, this._buff, this._count);
        this._count += 4;
    }

    @Override
    public void writeLong(long v) throws IOException {
        CacheDataOutput.longToBa(v, this._buff, this._count);
        this._count += 8;
    }

    @Override
    public void writeShort(int v) throws IOException {
        CacheDataOutput.shortToBa(v, this._buff, this._count);
        this._count += 2;
    }

    @Override
    public void writeUTF(String s) throws IOException {
        int slen = s.length();
        int utflen = IOUtilFunctions.getUTFSize(s) - 2;
        if (utflen - 2 > 65535) {
            throw new UTFDataFormatException("encoded string too long: " + utflen);
        }
        this.writeShort(utflen);
        for (int i = 0; i < slen; ++i) {
            char c = s.charAt(i);
            if (c >= '\u0001' && c <= '\u007f') {
                this.writeByte(c);
                continue;
            }
            if (c >= '\u0800') {
                this._buff[this._count++] = (byte)(0xE0 | c >> 12 & 0xF);
                this._buff[this._count++] = (byte)(0x80 | c >> 6 & 0x3F);
                this._buff[this._count++] = (byte)(0x80 | c >> 0 & 0x3F);
                continue;
            }
            this._buff[this._count++] = (byte)(0xC0 | c >> 6 & 0x1F);
            this._buff[this._count++] = (byte)(0x80 | c >> 0 & 0x3F);
        }
    }

    @Override
    public void writeDoubleArray(int len, double[] varr) throws IOException {
        int off = this._count;
        for (int i = 0; i < len; ++i) {
            long tmp = Double.doubleToRawLongBits(varr[i]);
            CacheDataOutput.longToBa(tmp, this._buff, off + i * 8);
        }
        this._count = off + len * 8;
    }

    @Override
    public void writeSparseRows(int rlen, SparseBlock rows) throws IOException {
        int i;
        int lrlen = Math.min(rows.numRows(), rlen);
        for (i = 0; i < lrlen; ++i) {
            if (!rows.isEmpty(i)) {
                int apos = rows.pos(i);
                int alen = rows.size(i);
                int[] aix = rows.indexes(i);
                double[] avals = rows.values(i);
                this.writeInt(alen);
                for (int j = apos; j < apos + alen; ++j) {
                    CacheDataOutput.intToBa(aix[j], this._buff, this._count);
                    long tmp2 = Double.doubleToRawLongBits(avals[j]);
                    CacheDataOutput.longToBa(tmp2, this._buff, this._count + 4);
                    this._count += 12;
                }
                continue;
            }
            this.writeInt(0);
        }
        for (i = lrlen; i < rlen; ++i) {
            this.writeInt(0);
        }
    }

    public byte[] getBytes() {
        return this._buff;
    }

    private static void shortToBa(int val, byte[] ba, int off) {
        IOUtilFunctions.shortToBa(val, ba, off);
    }

    private static void intToBa(int val, byte[] ba, int off) {
        IOUtilFunctions.intToBa(val, ba, off);
    }

    private static void longToBa(long val, byte[] ba, int off) {
        IOUtilFunctions.longToBa(val, ba, off);
    }
}

