/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sysds.runtime.compress.readers;

import java.util.Arrays;
import org.apache.sysds.runtime.compress.readers.ReaderColumnSelection;
import org.apache.sysds.runtime.compress.utils.DblArray;
import org.apache.sysds.runtime.data.SparseBlock;
import org.apache.sysds.runtime.matrix.data.MatrixBlock;

public class ReaderColumnSelectionSparse
extends ReaderColumnSelection {
    private final SparseBlock a;

    protected ReaderColumnSelectionSparse(MatrixBlock data, int[] colIndexes, int rl, int ru) {
        super(colIndexes, rl, Math.min(ru, data.getNumRows()) - 1);
        this.a = data.getSparseBlock();
    }

    @Override
    protected final DblArray getNextRow() {
        boolean empty = true;
        while (empty && this._rl < this._ru) {
            boolean zeroResult;
            ++this._rl;
            if (this.a.isEmpty(this._rl) || (zeroResult = this.processInRange(this._rl))) continue;
            return this.reusableReturn;
        }
        return null;
    }

    final boolean processInRange(int r) {
        boolean zeroResult = true;
        int apos = this.a.pos(r);
        int alen = this.a.size(r) + apos;
        int[] aix = this.a.indexes(r);
        double[] avals = this.a.values(r);
        int skip = 0;
        int j = Arrays.binarySearch(aix, apos, alen, this._colIndexes[0]);
        if (j < 0) {
            j = Math.abs(j + 1);
        }
        while (skip < this._colIndexes.length && j < alen) {
            if (this._colIndexes[skip] == aix[j]) {
                this.reusableArr[skip] = avals[j];
                zeroResult = false;
                ++skip;
                ++j;
                continue;
            }
            if (this._colIndexes[skip] > aix[j]) {
                ++j;
                continue;
            }
            this.reusableArr[skip++] = 0.0;
        }
        if (zeroResult) {
            return true;
        }
        while (skip < this._colIndexes.length) {
            this.reusableArr[skip++] = 0.0;
        }
        return false;
    }
}

