/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sysds.hops.estim;

import org.apache.commons.lang.NotImplementedException;
import org.apache.sysds.hops.OptimizerUtils;
import org.apache.sysds.hops.estim.MMNode;
import org.apache.sysds.hops.estim.SparsityEstimator;
import org.apache.sysds.runtime.matrix.data.MatrixBlock;
import org.apache.sysds.runtime.meta.DataCharacteristics;
import org.apache.sysds.runtime.meta.MatrixCharacteristics;

public class EstimatorBasicAvg
extends SparsityEstimator {
    @Override
    public DataCharacteristics estim(MMNode root) {
        DataCharacteristics dc1;
        DataCharacteristics dataCharacteristics = dc1 = !root.getLeft().isLeaf() ? this.estim(root.getLeft()) : root.getLeft().getDataCharacteristics();
        DataCharacteristics dc2 = root.getRight() == null ? null : (!root.getRight().isLeaf() ? this.estim(root.getRight()) : root.getRight().getDataCharacteristics());
        return root.setDataCharacteristics(this.estimIntern(dc1, dc2, root.getOp()));
    }

    @Override
    public double estim(MatrixBlock m1, MatrixBlock m2) {
        return this.estim(m1, m2, SparsityEstimator.OpCode.MM);
    }

    @Override
    public double estim(MatrixBlock m1, MatrixBlock m2, SparsityEstimator.OpCode op) {
        return this.estimIntern(m1.getDataCharacteristics(), m2.getDataCharacteristics(), op).getSparsity();
    }

    @Override
    public double estim(MatrixBlock m, SparsityEstimator.OpCode op) {
        return this.estimIntern(m.getDataCharacteristics(), null, op).getSparsity();
    }

    private DataCharacteristics estimIntern(DataCharacteristics dc1, DataCharacteristics dc2, SparsityEstimator.OpCode op) {
        switch (op) {
            case MM: {
                return new MatrixCharacteristics(dc1.getRows(), dc2.getCols(), OptimizerUtils.getMatMultNnz(dc1.getSparsity(), dc2.getSparsity(), dc1.getRows(), dc1.getCols(), dc2.getCols(), false));
            }
            case MULT: {
                return new MatrixCharacteristics(dc1.getRows(), dc1.getCols(), OptimizerUtils.getNnz(dc1.getRows(), dc1.getCols(), dc1.getSparsity() * dc2.getSparsity()));
            }
            case PLUS: {
                return new MatrixCharacteristics(dc1.getRows(), dc1.getCols(), OptimizerUtils.getNnz(dc1.getRows(), dc1.getCols(), dc1.getSparsity() + dc2.getSparsity() - dc1.getSparsity() * dc2.getSparsity()));
            }
            case EQZERO: 
            case DIAG: 
            case CBIND: 
            case RBIND: 
            case NEQZERO: 
            case TRANS: 
            case RESHAPE: {
                return this.estimExactMetaData(dc1, dc2, op);
            }
        }
        throw new NotImplementedException();
    }
}

