/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sysds.runtime.compress.utils;

public class IntIntMap {
    private static final int FREE_KEY = 0;
    private static final int INT_PHI = -1640531527;
    private int[] _data;
    private boolean _hasFreeKey;
    private int _freeValue = 0;
    private final float _fillFactor;
    private int _threshold;
    private int _size;
    private int _mask;
    private int _mask2;
    private int _capacity;

    public IntIntMap(int size, float fillFactor) {
        this._capacity = (int)IntIntMap.nextPowerOfTwo(size);
        this._mask = this._capacity - 1;
        this._mask2 = this._capacity * 2 - 1;
        this._fillFactor = fillFactor;
        this._data = new int[this._capacity * 2];
        this._threshold = (int)((float)this._capacity * fillFactor);
    }

    public int getCapacity() {
        return this._capacity;
    }

    public int getFreeValue() {
        return this._freeValue;
    }

    public int[] getMap() {
        return this._data;
    }

    public void inc(int key) {
        if (key == 0) {
            if (this._hasFreeKey) {
                ++this._size;
            }
            this._hasFreeKey = true;
            ++this._freeValue;
            return;
        }
        int ptr = (IntIntMap.phiMix(key) & this._mask) << 1;
        int k = this._data[ptr];
        if (k == 0) {
            this._data[ptr] = key;
            int n = ptr + 1;
            this._data[n] = this._data[n] + 1;
            this.shouldRehash();
            return;
        }
        if (k == key) {
            int n = ptr + 1;
            this._data[n] = this._data[n] + 1;
            return;
        }
        do {
            if ((k = this._data[ptr = ptr + 2 & this._mask2]) != 0) continue;
            this._data[ptr] = key;
            int n = ptr + 1;
            this._data[n] = this._data[n] + 1;
            this.shouldRehash();
            return;
        } while (k != key);
        int n = ptr + 1;
        this._data[n] = this._data[n] + 1;
    }

    public void inc(int key, int v) {
        if (key == 0) {
            if (this._hasFreeKey) {
                ++this._size;
            }
            this._hasFreeKey = true;
            this._freeValue += v;
            return;
        }
        int ptr = (IntIntMap.phiMix(key) & this._mask) << 1;
        int k = this._data[ptr];
        if (k == 0) {
            this._data[ptr] = key;
            int n = ptr + 1;
            this._data[n] = this._data[n] + v;
            this.shouldRehash();
            return;
        }
        if (k == key) {
            int n = ptr + 1;
            this._data[n] = this._data[n] + v;
            return;
        }
        do {
            if ((k = this._data[ptr = ptr + 2 & this._mask2]) != 0) continue;
            this._data[ptr] = key;
            int n = ptr + 1;
            this._data[n] = this._data[n] + v;
            this.shouldRehash();
            return;
        } while (k != key);
        int n = ptr + 1;
        this._data[n] = this._data[n] + v;
    }

    private void put(int key, int value) {
        int ptr = (IntIntMap.phiMix(key) & this._mask) << 1;
        int k = this._data[ptr];
        if (k == 0) {
            this._data[ptr] = key;
            this._data[ptr + 1] = value;
            ++this._size;
            return;
        }
        if (k == key) {
            this._data[ptr + 1] = value;
            return;
        }
        do {
            if ((k = this._data[ptr = ptr + 2 & this._mask2]) != 0) continue;
            this._data[ptr] = key;
            this._data[ptr + 1] = value;
            ++this._size;
            return;
        } while (k != key);
        this._data[ptr + 1] = value;
    }

    private void shouldRehash() {
        if (this._size >= this._threshold) {
            this.rehash();
        } else {
            ++this._size;
        }
    }

    private void rehash() {
        this._capacity *= 2;
        this._threshold = (int)((float)this._capacity * this._fillFactor);
        this._mask = this._capacity - 1;
        this._mask2 = this._capacity * 2 - 1;
        int[] oldData = this._data;
        this._data = new int[this._capacity * 2];
        this._size = this._hasFreeKey ? 1 : 0;
        for (int i = 0; i < this._capacity; i += 2) {
            int oldKey = oldData[i];
            if (oldKey == 0) continue;
            this.put(oldKey, oldData[i + 1]);
        }
    }

    private static int phiMix(int x) {
        int h = x * -1640531527;
        return h ^ h >> 16;
    }

    private static long nextPowerOfTwo(int x) {
        if (x == 0) {
            return 1L;
        }
        --x;
        x |= x >> 1;
        x |= x >> 2;
        x |= x >> 4;
        x |= x >> 8;
        x |= x >> 16;
        return (x | x >> 32) + 1;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append(this.getClass().getSimpleName());
        int size = 0;
        int count = 0;
        sb.append(" {");
        int len = this._capacity * 2;
        boolean hadLast = false;
        for (int x = 0; x < len; x += 2) {
            if (this._data[x] == 0) continue;
            if (hadLast) {
                sb.append(", ");
            }
            sb.append(this._data[x] + "->" + this._data[x + 1]);
            count += this._data[x + 1];
            ++size;
            hadLast = true;
        }
        if (this._hasFreeKey) {
            sb.append(", 0->" + this._freeValue);
            ++size;
            count += this._freeValue;
        }
        sb.append("}");
        sb.append(" Size: " + size);
        sb.append(" count: " + count);
        return sb.toString();
    }
}

