/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sysds.runtime.compress;

import java.util.ArrayList;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.commons.math3.random.Well1024a;
import org.apache.sysds.runtime.DMLRuntimeException;
import org.apache.sysds.runtime.compress.CompressedMatrixBlock;
import org.apache.sysds.runtime.compress.colgroup.ColGroup;
import org.apache.sysds.runtime.compress.colgroup.ColGroupUncompressed;
import org.apache.sysds.runtime.compress.colgroup.ColGroupValue;
import org.apache.sysds.runtime.controlprogram.caching.CacheBlock;
import org.apache.sysds.runtime.controlprogram.caching.MatrixObject;
import org.apache.sysds.runtime.instructions.cp.CM_COV_Object;
import org.apache.sysds.runtime.instructions.cp.ScalarObject;
import org.apache.sysds.runtime.instructions.spark.data.IndexedMatrixValue;
import org.apache.sysds.runtime.matrix.data.CTableMap;
import org.apache.sysds.runtime.matrix.data.LibMatrixBincell;
import org.apache.sysds.runtime.matrix.data.MatrixBlock;
import org.apache.sysds.runtime.matrix.data.MatrixIndexes;
import org.apache.sysds.runtime.matrix.data.MatrixValue;
import org.apache.sysds.runtime.matrix.data.RandomMatrixGenerator;
import org.apache.sysds.runtime.matrix.operators.AggregateBinaryOperator;
import org.apache.sysds.runtime.matrix.operators.AggregateOperator;
import org.apache.sysds.runtime.matrix.operators.AggregateTernaryOperator;
import org.apache.sysds.runtime.matrix.operators.AggregateUnaryOperator;
import org.apache.sysds.runtime.matrix.operators.BinaryOperator;
import org.apache.sysds.runtime.matrix.operators.CMOperator;
import org.apache.sysds.runtime.matrix.operators.COVOperator;
import org.apache.sysds.runtime.matrix.operators.Operator;
import org.apache.sysds.runtime.matrix.operators.QuaternaryOperator;
import org.apache.sysds.runtime.matrix.operators.ReorgOperator;
import org.apache.sysds.runtime.matrix.operators.TernaryOperator;
import org.apache.sysds.runtime.matrix.operators.UnaryOperator;
import org.apache.sysds.runtime.util.IndexRange;
import org.apache.sysds.runtime.util.SortUtils;

public abstract class AbstractCompressedMatrixBlock
extends MatrixBlock {
    private static final Log LOG = LogFactory.getLog((String)AbstractCompressedMatrixBlock.class.getName());
    protected List<ColGroup> _colGroups;

    public AbstractCompressedMatrixBlock() {
    }

    public AbstractCompressedMatrixBlock(int rl, int cl, boolean sparse) {
        super(rl, cl, sparse);
    }

    public AbstractCompressedMatrixBlock(MatrixBlock that) {
        super(that.getNumRows(), that.getNumColumns(), that.isInSparseFormat());
        if (this.isInSparseFormat()) {
            this.sparseBlock = that.getSparseBlock();
        } else {
            this.denseBlock = that.getDenseBlock();
        }
        this.nonZeros = that.getNonZeros();
    }

    public abstract MatrixBlock decompress();

    @Override
    public boolean isEmptyBlock(boolean safe) {
        return this._colGroups == null || this.getNonZeros() == 0L;
    }

    public static long estimateOriginalSizeInMemory(int nrows, int ncols, double sparsity) {
        long size = MatrixBlock.estimateSizeInMemory(nrows, ncols, sparsity);
        size += 4L;
        size += 4L;
        ++size;
        size += 8L;
        size += 8L;
        size += 8L;
        if ((size += 4L) % 8L != 0L) {
            size += 8L - size % 8L;
        }
        return size;
    }

    @Override
    public MatrixBlock unaryOperations(UnaryOperator op, MatrixValue result) {
        this.printDecompressWarning("unaryOperations");
        MatrixBlock tmp = this.decompress();
        return tmp.unaryOperations(op, result);
    }

    @Override
    public MatrixBlock binaryOperations(BinaryOperator op, MatrixValue thatValue, MatrixValue result) {
        MatrixBlock that = AbstractCompressedMatrixBlock.getUncompressed(thatValue);
        if (!LibMatrixBincell.isValidDimensionsBinary(this, that)) {
            throw new RuntimeException("Block sizes are not matched for binary cell operations: " + this.rlen + "x" + this.clen + " vs " + that.getNumRows() + "x" + that.getNumColumns());
        }
        MatrixBlock right = AbstractCompressedMatrixBlock.getUncompressed(thatValue);
        CompressedMatrixBlock ret = null;
        if (result == null || !(result instanceof CompressedMatrixBlock)) {
            ret = new CompressedMatrixBlock(this.getNumRows(), this.getNumColumns(), this.sparse);
        } else {
            ret = (CompressedMatrixBlock)result;
            ret.reset(this.rlen, this.clen);
        }
        this.bincellOp(right, ret, op);
        return ret;
    }

    private void bincellOp(MatrixBlock m2, CompressedMatrixBlock ret, BinaryOperator op) {
        LibMatrixBincell.BinaryAccessType atype = LibMatrixBincell.getBinaryAccessType(this, m2);
        if (atype == LibMatrixBincell.BinaryAccessType.MATRIX_COL_VECTOR || atype == LibMatrixBincell.BinaryAccessType.MATRIX_ROW_VECTOR) {
            this.binaryMV(m2, ret, op, atype);
        } else if (atype == LibMatrixBincell.BinaryAccessType.OUTER_VECTOR_VECTOR) {
            this.binaryVV(m2, ret, op, atype);
        } else {
            this.binaryMM(m2, ret, op);
        }
    }

    protected abstract void binaryMV(MatrixBlock var1, CompressedMatrixBlock var2, BinaryOperator var3, LibMatrixBincell.BinaryAccessType var4);

    protected abstract void binaryVV(MatrixBlock var1, CompressedMatrixBlock var2, BinaryOperator var3, LibMatrixBincell.BinaryAccessType var4);

    protected abstract void binaryMM(MatrixBlock var1, CompressedMatrixBlock var2, BinaryOperator var3);

    @Override
    public MatrixBlock binaryOperationsInPlace(BinaryOperator op, MatrixValue thatValue) {
        this.printDecompressWarning("binaryOperationsInPlace", (MatrixBlock)thatValue);
        MatrixBlock left = this.decompress();
        MatrixBlock right = AbstractCompressedMatrixBlock.getUncompressed(thatValue);
        left.binaryOperationsInPlace(op, right);
        return this;
    }

    @Override
    public void incrementalAggregate(AggregateOperator aggOp, MatrixValue correction, MatrixValue newWithCorrection, boolean deep) {
        throw new DMLRuntimeException("CompressedMatrixBlock: incrementalAggregate not supported.");
    }

    @Override
    public void incrementalAggregate(AggregateOperator aggOp, MatrixValue newWithCorrection) {
        throw new DMLRuntimeException("CompressedMatrixBlock: incrementalAggregate not supported.");
    }

    @Override
    public MatrixBlock reorgOperations(ReorgOperator op, MatrixValue ret, int startRow, int startColumn, int length) {
        this.printDecompressWarning("reorgOperations");
        MatrixBlock tmp = this.decompress();
        return tmp.reorgOperations(op, ret, startRow, startColumn, length);
    }

    @Override
    public MatrixBlock append(MatrixBlock that, MatrixBlock ret, boolean cbind) {
        if (cbind) {
            return this.append(that, ret);
        }
        this.printDecompressWarning("append-rbind", that);
        MatrixBlock left = this.decompress();
        MatrixBlock right = AbstractCompressedMatrixBlock.getUncompressed(that);
        return left.append(right, ret, cbind);
    }

    @Override
    public void append(MatrixValue v2, ArrayList<IndexedMatrixValue> outlist, int blen, boolean cbind, boolean m2IsLast, int nextNCol) {
        this.printDecompressWarning("append", (MatrixBlock)v2);
        MatrixBlock left = this.decompress();
        MatrixBlock right = AbstractCompressedMatrixBlock.getUncompressed(v2);
        left.append(right, outlist, blen, cbind, m2IsLast, nextNCol);
    }

    @Override
    public void permutationMatrixMultOperations(MatrixValue m2Val, MatrixValue out1Val, MatrixValue out2Val) {
        this.permutationMatrixMultOperations(m2Val, out1Val, out2Val, 1);
    }

    @Override
    public void permutationMatrixMultOperations(MatrixValue m2Val, MatrixValue out1Val, MatrixValue out2Val, int k) {
        this.printDecompressWarning("permutationMatrixMultOperations", (MatrixBlock)m2Val);
        MatrixBlock left = this.decompress();
        MatrixBlock right = AbstractCompressedMatrixBlock.getUncompressed(m2Val);
        left.permutationMatrixMultOperations(right, out1Val, out2Val, k);
    }

    @Override
    public MatrixBlock leftIndexingOperations(MatrixBlock rhsMatrix, int rl, int ru, int cl, int cu, MatrixBlock ret, MatrixObject.UpdateType update) {
        this.printDecompressWarning("leftIndexingOperations");
        MatrixBlock left = this.decompress();
        MatrixBlock right = AbstractCompressedMatrixBlock.getUncompressed(rhsMatrix);
        return left.leftIndexingOperations(right, rl, ru, cl, cu, ret, update);
    }

    @Override
    public MatrixBlock leftIndexingOperations(ScalarObject scalar, int rl, int cl, MatrixBlock ret, MatrixObject.UpdateType update) {
        this.printDecompressWarning("leftIndexingOperations");
        MatrixBlock tmp = this.decompress();
        return tmp.leftIndexingOperations(scalar, rl, cl, ret, update);
    }

    @Override
    public MatrixBlock slice(int rl, int ru, int cl, int cu, boolean deep, CacheBlock ret) {
        this.printDecompressWarning("slice");
        MatrixBlock tmp = this.decompress();
        return tmp.slice(rl, ru, cl, cu, ret);
    }

    @Override
    public void slice(ArrayList<IndexedMatrixValue> outlist, IndexRange range, int rowCut, int colCut, int blen, int boundaryRlen, int boundaryClen) {
        this.printDecompressWarning("slice");
        try {
            MatrixBlock tmp = this.decompress();
            tmp.slice(outlist, range, rowCut, colCut, blen, boundaryRlen, boundaryClen);
        }
        catch (DMLRuntimeException ex) {
            throw new RuntimeException(ex);
        }
    }

    @Override
    public MatrixBlock zeroOutOperations(MatrixValue result, IndexRange range, boolean complementary) {
        this.printDecompressWarning("zeroOutOperations");
        MatrixBlock tmp = this.decompress();
        return tmp.zeroOutOperations(result, range, complementary);
    }

    @Override
    public CM_COV_Object cmOperations(CMOperator op) {
        this.printDecompressWarning("cmOperations");
        if (this.isEmptyBlock()) {
            return super.cmOperations(op);
        }
        ColGroup grp = this._colGroups.get(0);
        MatrixBlock vals = grp.getValuesAsBlock();
        if (grp instanceof ColGroupValue) {
            int[] counts = ((ColGroupValue)grp).getCounts();
            return vals.cmOperations(op, AbstractCompressedMatrixBlock.getCountsAsBlock(counts));
        }
        return vals.cmOperations(op);
    }

    private static MatrixBlock getCountsAsBlock(int[] counts) {
        MatrixBlock ret = new MatrixBlock(counts.length, 1, false);
        for (int i = 0; i < counts.length; ++i) {
            ret.quickSetValue(i, 0, counts[i]);
        }
        return ret;
    }

    @Override
    public CM_COV_Object cmOperations(CMOperator op, MatrixBlock weights) {
        this.printDecompressWarning("cmOperations");
        MatrixBlock right = AbstractCompressedMatrixBlock.getUncompressed(weights);
        if (this.isEmptyBlock()) {
            return super.cmOperations(op, right);
        }
        ColGroup grp = this._colGroups.get(0);
        if (grp instanceof ColGroupUncompressed) {
            return ((ColGroupUncompressed)grp).getData().cmOperations(op);
        }
        return this.decompress().cmOperations(op, right);
    }

    @Override
    public CM_COV_Object covOperations(COVOperator op, MatrixBlock that) {
        this.printDecompressWarning("covOperations");
        MatrixBlock left = this.decompress();
        MatrixBlock right = AbstractCompressedMatrixBlock.getUncompressed(that);
        return left.covOperations(op, right);
    }

    @Override
    public CM_COV_Object covOperations(COVOperator op, MatrixBlock that, MatrixBlock weights) {
        this.printDecompressWarning("covOperations");
        MatrixBlock left = this.decompress();
        MatrixBlock right1 = AbstractCompressedMatrixBlock.getUncompressed(that);
        MatrixBlock right2 = AbstractCompressedMatrixBlock.getUncompressed(weights);
        return left.covOperations(op, right1, right2);
    }

    @Override
    public MatrixBlock sortOperations(MatrixValue weights, MatrixBlock result) {
        this.printDecompressWarning("sortOperations");
        MatrixBlock right = AbstractCompressedMatrixBlock.getUncompressed(weights);
        ColGroup grp = this._colGroups.get(0);
        if (!grp.getIfCountsType()) {
            return grp.getValuesAsBlock().sortOperations(right, result);
        }
        if (right == null && grp instanceof ColGroupValue) {
            MatrixBlock vals = grp.getValuesAsBlock();
            int[] counts = ((ColGroupValue)grp).getCounts();
            double[] data = vals.getDenseBlock() != null ? vals.getDenseBlockValues() : null;
            SortUtils.sortByValue(0, vals.getNumRows(), data, counts);
            MatrixBlock counts2 = AbstractCompressedMatrixBlock.getCountsAsBlock(counts);
            return vals.sortOperations(counts2, result);
        }
        return this.decompress().sortOperations(right, result);
    }

    @Override
    public MatrixBlock aggregateBinaryOperations(MatrixIndexes m1Index, MatrixBlock m1Value, MatrixIndexes m2Index, MatrixBlock m2Value, MatrixBlock result, AggregateBinaryOperator op) {
        this.printDecompressWarning("aggregateBinaryOperations");
        MatrixBlock left = this.decompress();
        MatrixBlock right = AbstractCompressedMatrixBlock.getUncompressed(m2Value);
        return left.aggregateBinaryOperations(m1Index, left, m2Index, right, result, op);
    }

    @Override
    public MatrixBlock aggregateTernaryOperations(MatrixBlock m1, MatrixBlock m2, MatrixBlock m3, MatrixBlock ret, AggregateTernaryOperator op, boolean inCP) {
        this.printDecompressWarning("aggregateTernaryOperations");
        MatrixBlock left = this.decompress();
        MatrixBlock right1 = AbstractCompressedMatrixBlock.getUncompressed(m2);
        MatrixBlock right2 = AbstractCompressedMatrixBlock.getUncompressed(m3);
        return left.aggregateTernaryOperations(left, right1, right2, ret, op, inCP);
    }

    @Override
    public MatrixBlock uaggouterchainOperations(MatrixBlock mbLeft, MatrixBlock mbRight, MatrixBlock mbOut, BinaryOperator bOp, AggregateUnaryOperator uaggOp) {
        this.printDecompressWarning("uaggouterchainOperations");
        MatrixBlock left = this.decompress();
        MatrixBlock right = AbstractCompressedMatrixBlock.getUncompressed(mbRight);
        return left.uaggouterchainOperations(left, right, mbOut, bOp, uaggOp);
    }

    @Override
    public MatrixBlock groupedAggOperations(MatrixValue tgt, MatrixValue wghts, MatrixValue ret, int ngroups, Operator op) {
        return this.groupedAggOperations(tgt, wghts, ret, ngroups, op, 1);
    }

    @Override
    public MatrixBlock groupedAggOperations(MatrixValue tgt, MatrixValue wghts, MatrixValue ret, int ngroups, Operator op, int k) {
        this.printDecompressWarning("groupedAggOperations");
        MatrixBlock left = this.decompress();
        MatrixBlock right = AbstractCompressedMatrixBlock.getUncompressed(wghts);
        return left.groupedAggOperations(left, right, ret, ngroups, op, k);
    }

    @Override
    public MatrixBlock removeEmptyOperations(MatrixBlock ret, boolean rows, boolean emptyReturn, MatrixBlock select) {
        this.printDecompressWarning("removeEmptyOperations");
        MatrixBlock tmp = this.decompress();
        return tmp.removeEmptyOperations(ret, rows, emptyReturn, select);
    }

    @Override
    public MatrixBlock removeEmptyOperations(MatrixBlock ret, boolean rows, boolean emptyReturn) {
        this.printDecompressWarning("removeEmptyOperations");
        MatrixBlock tmp = this.decompress();
        return tmp.removeEmptyOperations(ret, rows, emptyReturn);
    }

    @Override
    public MatrixBlock rexpandOperations(MatrixBlock ret, double max, boolean rows, boolean cast, boolean ignore, int k) {
        this.printDecompressWarning("rexpandOperations");
        MatrixBlock tmp = this.decompress();
        return tmp.rexpandOperations(ret, max, rows, cast, ignore, k);
    }

    @Override
    public MatrixBlock replaceOperations(MatrixValue result, double pattern, double replacement) {
        this.printDecompressWarning("replaceOperations");
        MatrixBlock tmp = this.decompress();
        return tmp.replaceOperations(result, pattern, replacement);
    }

    @Override
    public void ctableOperations(Operator op, double scalar, MatrixValue that, CTableMap resultMap, MatrixBlock resultBlock) {
        this.printDecompressWarning("ctableOperations");
        MatrixBlock left = this.decompress();
        MatrixBlock right = AbstractCompressedMatrixBlock.getUncompressed(that);
        left.ctableOperations(op, scalar, (MatrixValue)right, resultMap, resultBlock);
    }

    @Override
    public void ctableOperations(Operator op, double scalar, double scalar2, CTableMap resultMap, MatrixBlock resultBlock) {
        this.printDecompressWarning("ctableOperations");
        MatrixBlock tmp = this.decompress();
        tmp.ctableOperations(op, scalar, scalar2, resultMap, resultBlock);
    }

    @Override
    public void ctableOperations(Operator op, MatrixIndexes ix1, double scalar, boolean left, int brlen, CTableMap resultMap, MatrixBlock resultBlock) {
        this.printDecompressWarning("ctableOperations");
        MatrixBlock tmp = this.decompress();
        tmp.ctableOperations(op, ix1, scalar, left, brlen, resultMap, resultBlock);
    }

    @Override
    public void ctableOperations(Operator op, MatrixValue that, double scalar, boolean ignoreZeros, CTableMap resultMap, MatrixBlock resultBlock) {
        this.printDecompressWarning("ctableOperations");
        MatrixBlock left = this.decompress();
        MatrixBlock right = AbstractCompressedMatrixBlock.getUncompressed(that);
        left.ctableOperations(op, right, scalar, ignoreZeros, resultMap, resultBlock);
    }

    @Override
    public MatrixBlock ctableSeqOperations(MatrixValue that, double scalar, MatrixBlock resultBlock) {
        this.printDecompressWarning("ctableOperations");
        MatrixBlock right = AbstractCompressedMatrixBlock.getUncompressed(that);
        return this.ctableSeqOperations(right, scalar, resultBlock);
    }

    @Override
    public void ctableOperations(Operator op, MatrixValue that, MatrixValue that2, CTableMap resultMap) {
        this.printDecompressWarning("ctableOperations");
        MatrixBlock left = this.decompress();
        MatrixBlock right1 = AbstractCompressedMatrixBlock.getUncompressed(that);
        MatrixBlock right2 = AbstractCompressedMatrixBlock.getUncompressed(that2);
        left.ctableOperations(op, right1, right2, resultMap);
    }

    @Override
    public void ctableOperations(Operator op, MatrixValue that, MatrixValue that2, CTableMap resultMap, MatrixBlock resultBlock) {
        this.printDecompressWarning("ctableOperations");
        MatrixBlock left = this.decompress();
        MatrixBlock right1 = AbstractCompressedMatrixBlock.getUncompressed(that);
        MatrixBlock right2 = AbstractCompressedMatrixBlock.getUncompressed(that2);
        left.ctableOperations(op, right1, (MatrixValue)right2, resultMap, resultBlock);
    }

    @Override
    public MatrixBlock ternaryOperations(TernaryOperator op, MatrixBlock m2, MatrixBlock m3, MatrixBlock ret) {
        this.printDecompressWarning("ternaryOperations");
        MatrixBlock left = this.decompress();
        MatrixBlock right1 = AbstractCompressedMatrixBlock.getUncompressed(m2);
        MatrixBlock right2 = AbstractCompressedMatrixBlock.getUncompressed(m3);
        return left.ternaryOperations(op, right1, right2, ret);
    }

    @Override
    public MatrixBlock quaternaryOperations(QuaternaryOperator qop, MatrixBlock um, MatrixBlock vm, MatrixBlock wm, MatrixBlock out) {
        return this.quaternaryOperations(qop, um, vm, wm, out, 1);
    }

    @Override
    public MatrixBlock quaternaryOperations(QuaternaryOperator qop, MatrixBlock um, MatrixBlock vm, MatrixBlock wm, MatrixBlock out, int k) {
        this.printDecompressWarning("quaternaryOperations");
        MatrixBlock left = this.decompress();
        MatrixBlock right1 = AbstractCompressedMatrixBlock.getUncompressed(um);
        MatrixBlock right2 = AbstractCompressedMatrixBlock.getUncompressed(vm);
        MatrixBlock right3 = AbstractCompressedMatrixBlock.getUncompressed(wm);
        return left.quaternaryOperations(qop, right1, right2, right3, out, k);
    }

    @Override
    public MatrixBlock randOperationsInPlace(RandomMatrixGenerator rgen, Well1024a bigrand, long bSeed) {
        throw new DMLRuntimeException("CompressedMatrixBlock: randOperationsInPlace not supported.");
    }

    @Override
    public MatrixBlock randOperationsInPlace(RandomMatrixGenerator rgen, Well1024a bigrand, long bSeed, int k) {
        throw new DMLRuntimeException("CompressedMatrixBlock: randOperationsInPlace not supported.");
    }

    @Override
    public MatrixBlock seqOperationsInPlace(double from, double to, double incr) {
        throw new DMLRuntimeException("CompressedMatrixBlock: seqOperationsInPlace not supported.");
    }

    private static boolean isCompressed(MatrixBlock mb) {
        return mb instanceof CompressedMatrixBlock;
    }

    private static MatrixBlock getUncompressed(MatrixValue mVal) {
        return AbstractCompressedMatrixBlock.isCompressed((MatrixBlock)mVal) ? ((CompressedMatrixBlock)mVal).decompress() : (MatrixBlock)mVal;
    }

    protected void printDecompressWarning(String operation) {
        LOG.warn((Object)("Operation '" + operation + "' not supported yet - decompressing for ULA operations."));
    }

    protected void printDecompressWarning(String operation, MatrixBlock m2) {
        if (AbstractCompressedMatrixBlock.isCompressed(m2)) {
            LOG.warn((Object)("Operation '" + operation + "' not supported yet - decompressing for ULA operations."));
        } else {
            LOG.warn((Object)("Operation '" + operation + "' not supported yet - decompressing'"));
        }
    }

    @Override
    public boolean isShallowSerialize() {
        return true;
    }

    @Override
    public boolean isShallowSerialize(boolean inclConvert) {
        return true;
    }

    @Override
    public void toShallowSerializeBlock() {
    }
}

