/*
 * Decompiled with CFR 0.152.
 */
package org.apache.synapse.mediators;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Stack;
import javax.activation.DataHandler;
import org.apache.axiom.om.OMText;
import org.apache.axis2.addressing.EndpointReference;
import org.apache.axis2.description.AxisOperation;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.synapse.MessageContext;
import org.apache.synapse.config.Entry;
import org.apache.synapse.core.axis2.Axis2MessageContext;
import org.apache.synapse.mediators.template.TemplateContext;
import org.apache.synapse.registry.Registry;
import org.jaxen.Context;
import org.jaxen.Function;
import org.jaxen.FunctionCallException;
import org.jaxen.Navigator;
import org.jaxen.function.StringFunction;

public class GetPropertyFunction
implements Function {
    private static final Log log = LogFactory.getLog(GetPropertyFunction.class);
    private static final Log trace = LogFactory.getLog((String)"TRACE_LOGGER");
    public static final String NULL_STRING = "";
    private final MessageContext synCtx;

    public GetPropertyFunction(MessageContext synCtx) {
        this.synCtx = synCtx;
    }

    public MessageContext getSynCtx() {
        return this.synCtx;
    }

    public Object call(Context context, List args) throws FunctionCallException {
        boolean traceOrDebugOn;
        if (this.synCtx == null) {
            if (log.isDebugEnabled()) {
                log.debug((Object)"Synapse message context has not been set for the XPath extension function 'synapse:get-property(prop-name)'");
            }
            return null;
        }
        boolean traceOn = this.synCtx.getTracingState() == 1;
        boolean bl = traceOrDebugOn = traceOn || log.isDebugEnabled();
        if (args == null || args.size() == 0) {
            if (traceOrDebugOn) {
                this.traceOrDebug(traceOn, "Property key value for lookup is not specified");
            }
            return NULL_STRING;
        }
        int size = args.size();
        if (size == 1) {
            return this.evaluate("default", args.get(0), null, context.getNavigator());
        }
        if (size == 2) {
            String argOne = StringFunction.evaluate(args.get(0), (Navigator)context.getNavigator());
            if (argOne != null) {
                if (!("axis2".equals(argOne) || "default".equals(argOne) || "transport".equals(argOne) || "registry".equals(argOne) || "func".equals(argOne) || "system".equals(argOne))) {
                    return this.evaluate("default", args.get(0), args.get(1), context.getNavigator());
                }
                return this.evaluate(args.get(0), args.get(1), null, context.getNavigator());
            }
        } else {
            if (size == 3) {
                return this.evaluate(args.get(0), args.get(1), args.get(2), context.getNavigator());
            }
            String msg = "Invalid arguments for synapse:get-property(prop-name) 0r  synapse:get-property(scope, prop-name) XPath function ";
            if (traceOn) {
                trace.error((Object)msg);
            }
            log.error((Object)msg);
            throw new FunctionCallException(msg);
        }
        return NULL_STRING;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public Object evaluate(Object scopeObject, Object keyObject, Object dateformat, Navigator navigator) {
        boolean traceOn = this.synCtx.getTracingState() == 1;
        boolean traceOrDebugOn = traceOn || log.isDebugEnabled();
        String scope = StringFunction.evaluate((Object)scopeObject, (Navigator)navigator);
        String key = StringFunction.evaluate((Object)keyObject, (Navigator)navigator);
        if (key == null || NULL_STRING.equals(key)) {
            if (!traceOrDebugOn) return NULL_STRING;
            this.traceOrDebug(traceOn, "property-name should be provided when executing synapse:get-property(scope,prop-name) or synapse:get-property(prop-name) Xpath function");
            return NULL_STRING;
        }
        if ("SYSTEM_DATE".equals(key)) {
            if (dateformat != null) {
                SimpleDateFormat formatter = new SimpleDateFormat(dateformat.toString());
                return formatter.format((Object)new Date());
            }
            SimpleDateFormat formatter = new SimpleDateFormat();
            return formatter.format((Object)new Date());
        }
        if ("SYSTEM_TIME".equals(key)) {
            return Long.toString(System.currentTimeMillis());
        }
        if ("default".equals(scope)) {
            if ("To".equals(key)) {
                EndpointReference toEPR = this.synCtx.getTo();
                if (toEPR == null) return NULL_STRING;
                return toEPR.getAddress();
            }
            if ("From".equals(key)) {
                EndpointReference fromEPR = this.synCtx.getFrom();
                if (fromEPR == null) return NULL_STRING;
                return fromEPR.getAddress();
            }
            if ("Action".equals(key)) {
                String wsaAction = this.synCtx.getWSAAction();
                if (wsaAction == null) return NULL_STRING;
                return wsaAction;
            }
            if ("FaultTo".equals(key)) {
                EndpointReference faultEPR = this.synCtx.getFaultTo();
                if (faultEPR == null) return NULL_STRING;
                return faultEPR.getAddress();
            }
            if ("ReplyTo".equals(key)) {
                EndpointReference replyToEPR = this.synCtx.getReplyTo();
                if (replyToEPR == null) return NULL_STRING;
                return replyToEPR.getAddress();
            }
            if ("MessageID".equals(key)) {
                String messageID = this.synCtx.getMessageID();
                if (messageID == null) return NULL_STRING;
                return messageID;
            }
            if ("FAULT".equals(key)) {
                if (this.synCtx.getEnvelope().hasFault()) {
                    return "TRUE";
                }
                if (!(this.synCtx instanceof Axis2MessageContext)) return NULL_STRING;
                org.apache.axis2.context.MessageContext axis2MessageContext = ((Axis2MessageContext)this.synCtx).getAxis2MessageContext();
                if (axis2MessageContext.getProperty("FAULT_MESSAGE") == null || !"TRUE".equals(axis2MessageContext.getProperty("FAULT_MESSAGE"))) return NULL_STRING;
                return "TRUE";
            }
            if ("MESSAGE_FORMAT".equals(key)) {
                if (this.synCtx.isDoingPOX()) {
                    return "pox";
                }
                if (this.synCtx.isDoingGET()) {
                    return "get";
                }
                if (!this.synCtx.isSOAP11()) return "soap12";
                return "soap11";
            }
            if ("OperationName".equals(key) || "OperationNamespace".equals(key)) {
                AxisOperation axisOperation;
                if (!(this.synCtx instanceof Axis2MessageContext) || (axisOperation = ((Axis2MessageContext)this.synCtx).getAxis2MessageContext().getAxisOperation()) == null) return NULL_STRING;
                if (!"OperationNamespace".equals(key)) return axisOperation.getName().getLocalPart();
                return axisOperation.getName().getNamespaceURI();
            }
            Object result = this.synCtx.getProperty(key);
            if (result == null) return this.synCtx.getLocalEntry(key);
            return result;
        }
        if ("axis2".equals(scope) && this.synCtx instanceof Axis2MessageContext) {
            org.apache.axis2.context.MessageContext axis2MessageContext = ((Axis2MessageContext)this.synCtx).getAxis2MessageContext();
            return axis2MessageContext.getProperty(key);
        }
        if ("func".equals(scope)) {
            Stack functionStack = (Stack)this.synCtx.getProperty("_SYNAPSE_FUNCTION_STACK");
            TemplateContext topCtxt = (TemplateContext)functionStack.peek();
            if (topCtxt == null) return NULL_STRING;
            return topCtxt.getParameterValue(key);
        }
        if ("transport".equals(scope) && this.synCtx instanceof Axis2MessageContext) {
            org.apache.axis2.context.MessageContext axis2MessageContext = ((Axis2MessageContext)this.synCtx).getAxis2MessageContext();
            Object headers = axis2MessageContext.getProperty("TRANSPORT_HEADERS");
            if (headers == null || !(headers instanceof Map)) return NULL_STRING;
            Map headersMap = (Map)headers;
            return headersMap.get(key);
        }
        if ("registry".equals(scope)) {
            Registry registry;
            String[] regParam = key.split("@");
            String regPath = null;
            String propName = null;
            if (regParam.length == 2) {
                regPath = regParam[0];
                propName = regParam[1];
            } else if (regParam.length == 1) {
                regPath = regParam[0];
            }
            Entry propEntry = this.synCtx.getConfiguration().getEntryDefinition(regPath);
            if (propEntry == null) {
                propEntry = new Entry();
                propEntry.setType(3);
                propEntry.setKey(key);
            }
            if ((registry = this.synCtx.getConfiguration().getRegistry()) == null) return NULL_STRING;
            registry.getResource(propEntry, new Properties());
            if (propName != null) {
                Properties reqProperties = propEntry.getEntryProperties();
                if (reqProperties == null || reqProperties.get(propName) == null) return NULL_STRING;
                return reqProperties.getProperty(propName);
            }
            if (propEntry.getValue() == null) return NULL_STRING;
            if (!(propEntry.getValue() instanceof OMText)) return propEntry.getValue().toString();
            OMText omText = (OMText)propEntry.getValue();
            DataHandler dh = (DataHandler)omText.getDataHandler();
            if (omText.getDataHandler() != null) {
                InputStream in = null;
                try {
                    String tempStr;
                    in = dh.getInputStream();
                    InputStreamReader streamReader = new InputStreamReader(in);
                    BufferedReader stringReader = new BufferedReader(streamReader);
                    StringBuilder omTextString = new StringBuilder(NULL_STRING);
                    while ((tempStr = stringReader.readLine()) != null) {
                        omTextString.append(tempStr);
                    }
                    String string = omTextString.toString();
                    return string;
                }
                catch (IOException e) {
                    String string = NULL_STRING;
                    return string;
                }
                finally {
                    if (in != null) {
                        try {
                            in.close();
                        }
                        catch (IOException iOException) {}
                    }
                }
            }
            omText.getText();
            return propEntry.getValue().toString();
        }
        if ("system".equals(scope)) {
            String val = System.getProperty(key);
            if (val != null) {
                return val;
            }
            if (!traceOrDebugOn) return NULL_STRING;
            this.traceOrDebug(traceOn, "No system property is found for key '" + key + "'");
            return NULL_STRING;
        }
        if (!traceOrDebugOn) return NULL_STRING;
        this.traceOrDebug(traceOn, "Invalid scope : '" + scope + "' has been set for the synapse:get-property(scope,prop-name) XPath function");
        return NULL_STRING;
    }

    private void traceOrDebug(boolean traceOn, String msg) {
        if (traceOn) {
            trace.info((Object)msg);
        }
        if (log.isDebugEnabled()) {
            log.debug((Object)msg);
        }
    }
}

