/*
 * Decompiled with CFR 0.152.
 */
package org.apache.synapse.endpoints;

import java.util.Collections;
import java.util.Map;
import java.util.Set;
import org.apache.axis2.addressing.EndpointReference;
import org.apache.axis2.clustering.ClusteringAgent;
import org.apache.axis2.clustering.Member;
import org.apache.axis2.clustering.management.DefaultGroupManagementAgent;
import org.apache.axis2.clustering.management.GroupManagementAgent;
import org.apache.axis2.context.ConfigurationContext;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.synapse.MessageContext;
import org.apache.synapse.SynapseException;
import org.apache.synapse.core.LoadBalanceMembershipHandler;
import org.apache.synapse.core.SynapseEnvironment;
import org.apache.synapse.core.axis2.Axis2MessageContext;
import org.apache.synapse.core.axis2.Axis2SynapseEnvironment;
import org.apache.synapse.core.axis2.ServiceLoadBalanceMembershipHandler;
import org.apache.synapse.endpoints.DynamicLoadbalanceEndpoint;
import org.apache.synapse.endpoints.DynamicLoadbalanceFaultHandler;
import org.apache.synapse.endpoints.Endpoint;
import org.apache.synapse.endpoints.algorithms.LoadbalanceAlgorithm;
import org.apache.synapse.endpoints.dispatch.SALSessions;
import org.apache.synapse.endpoints.dispatch.SessionInformation;

public class ServiceDynamicLoadbalanceEndpoint
extends DynamicLoadbalanceEndpoint {
    private static final Log log = LogFactory.getLog(ServiceDynamicLoadbalanceEndpoint.class);
    private ServiceLoadBalanceMembershipHandler slbMembershipHandler;
    private Map<String, String> hostDomainMap;

    @Override
    public void init(SynapseEnvironment synapseEnvironment) {
        if (!this.initialized) {
            super.init(synapseEnvironment);
            ConfigurationContext cfgCtx = ((Axis2SynapseEnvironment)synapseEnvironment).getAxis2ConfigurationContext();
            ClusteringAgent clusteringAgent = cfgCtx.getAxisConfiguration().getClusteringAgent();
            if (clusteringAgent == null) {
                throw new SynapseException("Axis2 ClusteringAgent not defined in axis2.xml");
            }
            for (String domain : this.hostDomainMap.values()) {
                if (clusteringAgent.getGroupManagementAgent(domain) != null) continue;
                clusteringAgent.addGroupManagementAgent((GroupManagementAgent)new DefaultGroupManagementAgent(), domain);
            }
            this.slbMembershipHandler = new ServiceLoadBalanceMembershipHandler(this.hostDomainMap, this.getAlgorithm(), cfgCtx, this.isClusteringEnabled, this.getName());
            SALSessions salSessions = SALSessions.getInstance();
            if (!salSessions.isInitialized()) {
                salSessions.initialize(this.isClusteringEnabled, cfgCtx);
            }
            this.initialized = true;
            log.info((Object)"ServiceDynamicLoadbalanceEndpoint initialized");
        }
    }

    public ServiceDynamicLoadbalanceEndpoint(Map<String, String> hostDomainMap, LoadbalanceAlgorithm algorithm) {
        this.hostDomainMap = hostDomainMap;
        this.setAlgorithm(algorithm);
    }

    @Override
    public LoadBalanceMembershipHandler getLbMembershipHandler() {
        return this.slbMembershipHandler;
    }

    public Map<String, String> getHostDomainMap() {
        return Collections.unmodifiableMap(this.hostDomainMap);
    }

    @Override
    public void send(MessageContext synCtx) {
        this.setCookieHeader(synCtx);
        Member currentMember = null;
        SessionInformation sessionInformation = null;
        if (this.isSessionAffinityBasedLB()) {
            sessionInformation = (SessionInformation)synCtx.getProperty("synapse.sal.endpoint.current.sessioninformation");
            currentMember = (Member)synCtx.getProperty("synapse.sal.current.member");
            if (sessionInformation == null && currentMember == null && (sessionInformation = this.dispatcher.getSession(synCtx)) != null) {
                if (log.isDebugEnabled()) {
                    log.debug((Object)("Current session id : " + sessionInformation.getId()));
                }
                currentMember = sessionInformation.getMember();
                synCtx.setProperty("synapse.sal.current.member", currentMember);
                synCtx.setProperty("synapse.sal.endpoint.current.sessioninformation", sessionInformation);
            }
        }
        String targetHost = this.getTargetHost(synCtx);
        ConfigurationContext configCtx = ((Axis2MessageContext)synCtx).getAxis2MessageContext().getConfigurationContext();
        if (this.slbMembershipHandler.getConfigurationContext() == null) {
            this.slbMembershipHandler.setConfigurationContext(configCtx);
        }
        ServiceDynamicLoadbalanceFaultHandlerImpl faultHandler = new ServiceDynamicLoadbalanceFaultHandlerImpl();
        faultHandler.setHost(targetHost);
        if (sessionInformation != null && currentMember != null) {
            sessionInformation.updateExpiryTime();
            this.sendToApplicationMember(synCtx, currentMember, faultHandler, false);
        } else {
            currentMember = this.slbMembershipHandler.getNextApplicationMember(targetHost);
            if (currentMember == null) {
                String msg = "No application members available";
                log.error((Object)msg);
                throw new SynapseException(msg);
            }
            this.sendToApplicationMember(synCtx, currentMember, faultHandler, true);
        }
    }

    private String getTargetHost(MessageContext synCtx) {
        org.apache.axis2.context.MessageContext axis2MessageContext = ((Axis2MessageContext)synCtx).getAxis2MessageContext();
        Map headers = (Map)axis2MessageContext.getProperty("TRANSPORT_HEADERS");
        String address = (String)headers.get("Host");
        synCtx.setProperty("LB_REQUEST_HOST", address);
        if (address.contains(":")) {
            address = address.substring(0, address.indexOf(":"));
        }
        return address;
    }

    private class ServiceDynamicLoadbalanceFaultHandlerImpl
    extends DynamicLoadbalanceFaultHandler {
        private EndpointReference to;
        private Member currentMember;
        private Endpoint currentEp;
        private String host;
        private static final int MAX_RETRY_COUNT = 5;
        private ThreadLocal<Integer> callCount = new ThreadLocal<Integer>(){

            @Override
            protected Integer initialValue() {
                return 0;
            }
        };

        public void setHost(String host) {
            this.host = host;
        }

        @Override
        public void setCurrentMember(Member currentMember) {
            this.currentMember = currentMember;
        }

        @Override
        public void setTo(EndpointReference to) {
            this.to = to;
        }

        private ServiceDynamicLoadbalanceFaultHandlerImpl() {
        }

        @Override
        public void onFault(MessageContext synCtx) {
            Integer errorCode;
            if (this.currentMember == null) {
                return;
            }
            this.currentMember.suspend(10000L);
            log.info((Object)("Suspended member " + this.currentMember + " for 10s"));
            this.callCount.set(this.callCount.get() + 1);
            if (this.callCount.get() >= 5) {
                return;
            }
            if (this.currentEp != null) {
                this.currentEp.destroy();
            }
            if ((errorCode = (Integer)synCtx.getProperty("ERROR_CODE")) != null) {
                if (errorCode.equals(101503) || errorCode.equals(101507) || errorCode.equals(101508)) {
                    Set pros;
                    Member newMember = ServiceDynamicLoadbalanceEndpoint.this.slbMembershipHandler.getNextApplicationMember(this.host);
                    if (newMember == null) {
                        String msg = "No application members available";
                        log.error((Object)msg);
                        throw new SynapseException(msg);
                    }
                    log.info((Object)("Failed over to " + newMember));
                    synCtx.setTo(this.to);
                    if (ServiceDynamicLoadbalanceEndpoint.this.isSessionAffinityBasedLB() && (pros = synCtx.getPropertyKeySet()) != null) {
                        pros.remove("synapse.sal.endpoint.current.sessioninformation");
                    }
                    try {
                        Thread.sleep(1000L);
                    }
                    catch (InterruptedException interruptedException) {
                        // empty catch block
                    }
                    ServiceDynamicLoadbalanceEndpoint.this.sendToApplicationMember(synCtx, newMember, this, true);
                } else if (errorCode.equals(101500) || errorCode.equals(101505)) {
                    // empty if block
                }
            }
        }

        @Override
        public void setCurrentEp(Endpoint currentEp) {
            this.currentEp = currentEp;
        }
    }
}

