/*
 * Decompiled with CFR 0.152.
 */
package com.google.gxp.compiler;

import com.google.gxp.com.google.common.base.Function;
import com.google.gxp.com.google.common.base.Preconditions;
import com.google.gxp.com.google.common.base.Supplier;
import com.google.gxp.com.google.common.base.Suppliers;
import com.google.gxp.compiler.base.TemplateName;
import com.google.gxp.compiler.bind.Binder;
import com.google.gxp.compiler.bind.BoundTree;
import com.google.gxp.compiler.collapse.SpaceCollapsedTree;
import com.google.gxp.compiler.collapse.SpaceCollapser;
import com.google.gxp.compiler.escape.EscapedTree;
import com.google.gxp.compiler.escape.Escaper;
import com.google.gxp.compiler.flatten.ContentFlattenedTree;
import com.google.gxp.compiler.flatten.ContentFlattener;
import com.google.gxp.compiler.fs.FileRef;
import com.google.gxp.compiler.i18ncheck.I18nCheckedTree;
import com.google.gxp.compiler.i18ncheck.I18nChecker;
import com.google.gxp.compiler.ifexpand.IfExpandedTree;
import com.google.gxp.compiler.ifexpand.IfExpander;
import com.google.gxp.compiler.msgextract.MessageExtractedTree;
import com.google.gxp.compiler.msgextract.MessageExtractor;
import com.google.gxp.compiler.parser.ParseTree;
import com.google.gxp.compiler.parser.Parser;
import com.google.gxp.compiler.phinsert.PlaceholderInsertedTree;
import com.google.gxp.compiler.phinsert.PlaceholderInserter;
import com.google.gxp.compiler.phpivot.PlaceholderPivotedTree;
import com.google.gxp.compiler.phpivot.PlaceholderPivoter;
import com.google.gxp.compiler.reparent.ReparentedTree;
import com.google.gxp.compiler.reparent.Reparenter;
import com.google.gxp.compiler.servicedir.ServiceDirectory;
import com.google.gxp.compiler.validate.ValidatedTree;
import com.google.gxp.compiler.validate.Validator;
import java.io.IOException;

public class CompilationUnit {
    private final ServiceDirectory serviceDirectory;
    private final Parser parser;
    private final FileRef sourceFileRef;
    private final String className;
    private final long compilationVersion;
    private final Supplier<ParseTree> parseTreeSupplier = Suppliers.memoize(new Supplier<ParseTree>(){

        @Override
        public ParseTree get() {
            try {
                return CompilationUnit.this.parser.parse(CompilationUnit.this.sourceFileRef);
            }
            catch (IOException iox) {
                throw new RuntimeException(iox);
            }
        }
    });
    private final Supplier<IfExpandedTree> ifExpandedTreeSupplier = this.memoCompose(new IfExpander(), this.parseTreeSupplier);
    private final Supplier<ReparentedTree> reparentedTreeSupplier = Suppliers.memoize(new Supplier<ReparentedTree>(){

        @Override
        public ReparentedTree get() {
            return new Reparenter(CompilationUnit.this.parser.getSchemaFactory(), CompilationUnit.this.className).apply(CompilationUnit.this.getIfExpandedTree());
        }
    });
    private final Supplier<BoundTree> boundTreeSupplier = Suppliers.memoize(new Supplier<BoundTree>(){

        @Override
        public BoundTree get() {
            return new Binder(CompilationUnit.this.parser.getSchemaFactory(), CompilationUnit.this.serviceDirectory).apply(CompilationUnit.this.getReparentedTree());
        }
    });
    private final Supplier<SpaceCollapsedTree> spaceCollapsedTreeSupplier = this.memoCompose(new SpaceCollapser(), this.boundTreeSupplier);
    private final Supplier<PlaceholderInsertedTree> placeholderInsertedTreeSupplier = this.memoCompose(new PlaceholderInserter(), this.spaceCollapsedTreeSupplier);
    private final Supplier<EscapedTree> escapedTreeSupplier = this.memoCompose(new Escaper(), this.placeholderInsertedTreeSupplier);
    private final Supplier<ValidatedTree> validatedTreeSupplier = this.memoCompose(new Validator(), this.escapedTreeSupplier);
    private final Supplier<ContentFlattenedTree> contentFlattenedTreeSupplier = this.memoCompose(new ContentFlattener(), this.validatedTreeSupplier);
    private final Supplier<PlaceholderPivotedTree> placeholderPivotedTreeSupplier = this.memoCompose(new PlaceholderPivoter(), this.contentFlattenedTreeSupplier);
    private final Supplier<I18nCheckedTree> i18nCheckedTreeSupplier = Suppliers.memoize(new Supplier<I18nCheckedTree>(){

        @Override
        public I18nCheckedTree get() {
            return I18nChecker.INSTANCE.apply(CompilationUnit.this.getSpaceCollapsedTree(), CompilationUnit.this.getPlaceholderPivotedTree());
        }
    });
    private final Supplier<MessageExtractedTree> messageExtractedTreeSupplier = this.memoCompose(new MessageExtractor(), this.i18nCheckedTreeSupplier);

    CompilationUnit(ServiceDirectory serviceDirectory, Parser parser, FileRef sourceFileRef, long compilationVersion) {
        this.serviceDirectory = Preconditions.checkNotNull(serviceDirectory);
        this.parser = Preconditions.checkNotNull(parser);
        this.sourceFileRef = Preconditions.checkNotNull(sourceFileRef);
        String fileName = sourceFileRef.removeExtension().getName();
        this.className = fileName.substring(1).replace('/', '.');
        this.compilationVersion = compilationVersion;
    }

    public FileRef getSourceFileRef() {
        return this.sourceFileRef;
    }

    public long getCompilationVersion() {
        return this.compilationVersion;
    }

    public TemplateName.FullyQualified getTemplateName() {
        return TemplateName.parseFullyQualifiedDottedName(this.className);
    }

    private <K, V> Supplier<V> memoCompose(Function<K, V> function, Supplier<? extends K> supplier) {
        return Suppliers.memoize(Suppliers.compose(function, supplier));
    }

    public ParseTree getParseTree() {
        return this.parseTreeSupplier.get();
    }

    public IfExpandedTree getIfExpandedTree() {
        return this.ifExpandedTreeSupplier.get();
    }

    public ReparentedTree getReparentedTree() {
        return this.reparentedTreeSupplier.get();
    }

    public BoundTree getBoundTree() {
        return this.boundTreeSupplier.get();
    }

    public SpaceCollapsedTree getSpaceCollapsedTree() {
        return this.spaceCollapsedTreeSupplier.get();
    }

    public PlaceholderInsertedTree getPlaceholderInsertedTree() {
        return this.placeholderInsertedTreeSupplier.get();
    }

    public EscapedTree getEscapedTree() {
        return this.escapedTreeSupplier.get();
    }

    public ValidatedTree getValidatedTree() {
        return this.validatedTreeSupplier.get();
    }

    public ContentFlattenedTree getContentFlattenedTree() {
        return this.contentFlattenedTreeSupplier.get();
    }

    public PlaceholderPivotedTree getPlaceholderPivotedTree() {
        return this.placeholderPivotedTreeSupplier.get();
    }

    public I18nCheckedTree getI18nCheckedTree() {
        return this.i18nCheckedTreeSupplier.get();
    }

    public MessageExtractedTree getMessageExtractedTree() {
        return this.messageExtractedTreeSupplier.get();
    }
}

