/*
 * Decompiled with CFR 0.152.
 */
package net.sf.oval.expression;

import java.util.Map;
import net.sf.oval.exception.ExpressionEvaluationException;
import net.sf.oval.expression.AbstractExpressionLanguage;
import net.sf.oval.internal.Log;
import net.sf.oval.internal.util.ObjectCache;
import org.apache.commons.jexl2.Expression;
import org.apache.commons.jexl2.JexlContext;
import org.apache.commons.jexl2.JexlEngine;
import org.apache.commons.jexl2.MapContext;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ExpressionLanguageJEXLImpl
extends AbstractExpressionLanguage {
    private static final Log LOG = Log.getLog(ExpressionLanguageJEXLImpl.class);
    private static final JexlEngine jexl = new JexlEngine();
    private final ObjectCache<String, Expression> expressionCache = new ObjectCache();

    @Override
    public Object evaluate(String expression, Map<String, ?> values) throws ExpressionEvaluationException {
        LOG.debug("Evaluating JEXL expression: {1}", expression);
        try {
            Expression expr = this.expressionCache.get(expression);
            if (expr == null) {
                expr = jexl.createExpression(expression);
                this.expressionCache.put(expression, expr);
            }
            return expr.evaluate((JexlContext)new MapContext(values));
        }
        catch (Exception ex) {
            throw new ExpressionEvaluationException("Evaluating JEXL expression failed: " + expression, ex);
        }
    }
}

