/*
 * Decompiled with CFR 0.152.
 */
package org.springdoc.webmvc.core;

import java.util.List;
import java.util.Optional;
import org.springdoc.core.AbstractRequestService;
import org.springdoc.core.GenericParameterService;
import org.springdoc.core.GenericResponseService;
import org.springdoc.core.OpenAPIService;
import org.springdoc.core.OperationService;
import org.springdoc.core.PropertyResolverUtils;
import org.springdoc.core.RequestBodyService;
import org.springdoc.core.ReturnTypeParser;
import org.springdoc.core.SpringDocConfigProperties;
import org.springdoc.core.SpringDocProviders;
import org.springdoc.core.SpringDocUtils;
import org.springdoc.core.customizers.OpenApiCustomiser;
import org.springdoc.core.customizers.OperationCustomizer;
import org.springdoc.core.customizers.ParameterCustomizer;
import org.springdoc.core.filters.OpenApiMethodFilter;
import org.springdoc.core.providers.ActuatorProvider;
import org.springdoc.core.providers.SpringWebProvider;
import org.springdoc.webmvc.api.OpenApiActuatorResource;
import org.springdoc.webmvc.api.OpenApiWebMvcResource;
import org.springdoc.webmvc.core.ActuatorWebMvcProvider;
import org.springdoc.webmvc.core.MultipleOpenApiSupportConfiguration;
import org.springdoc.webmvc.core.RequestService;
import org.springdoc.webmvc.core.RouterFunctionWebMvcProvider;
import org.springdoc.webmvc.core.SpringWebMvcProvider;
import org.springframework.beans.factory.ObjectFactory;
import org.springframework.boot.actuate.autoconfigure.endpoint.web.WebEndpointProperties;
import org.springframework.boot.actuate.autoconfigure.web.server.ConditionalOnManagementPort;
import org.springframework.boot.actuate.autoconfigure.web.server.ManagementPortType;
import org.springframework.boot.actuate.autoconfigure.web.server.ManagementServerProperties;
import org.springframework.boot.actuate.endpoint.web.servlet.ControllerEndpointHandlerMapping;
import org.springframework.boot.actuate.endpoint.web.servlet.WebMvcEndpointHandlerMapping;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.boot.autoconfigure.condition.ConditionalOnExpression;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.boot.autoconfigure.condition.ConditionalOnWebApplication;
import org.springframework.boot.autoconfigure.web.ServerProperties;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.Lazy;
import org.springframework.core.LocalVariableTableParameterNameDiscoverer;
import org.springframework.web.servlet.ModelAndView;
import org.springframework.web.servlet.function.RouterFunction;
import org.springframework.web.servlet.mvc.method.annotation.ResponseEntityExceptionHandler;

@Lazy(value=false)
@Configuration(proxyBeanMethods=false)
@ConditionalOnWebApplication(type=ConditionalOnWebApplication.Type.SERVLET)
@ConditionalOnProperty(name={"springdoc.api-docs.enabled"}, matchIfMissing=true)
public class SpringDocWebMvcConfiguration {
    @Bean
    @ConditionalOnMissingBean
    @ConditionalOnProperty(name={"springdoc.use-management-port"}, havingValue="false", matchIfMissing=true)
    @Lazy(value=false)
    OpenApiWebMvcResource openApiResource(ObjectFactory<OpenAPIService> openAPIBuilderObjectFactory, AbstractRequestService requestBuilder, GenericResponseService responseBuilder, OperationService operationParser, SpringDocConfigProperties springDocConfigProperties, Optional<List<OperationCustomizer>> operationCustomizers, Optional<List<OpenApiCustomiser>> openApiCustomisers, Optional<List<OpenApiMethodFilter>> methodFilters, SpringDocProviders springDocProviders) {
        return new OpenApiWebMvcResource(openAPIBuilderObjectFactory, requestBuilder, responseBuilder, operationParser, operationCustomizers, openApiCustomisers, methodFilters, springDocConfigProperties, springDocProviders);
    }

    @Bean
    @ConditionalOnMissingBean
    @Lazy(value=false)
    RequestService requestBuilder(GenericParameterService parameterBuilder, RequestBodyService requestBodyService, OperationService operationService, Optional<List<ParameterCustomizer>> parameterCustomizers, LocalVariableTableParameterNameDiscoverer localSpringDocParameterNameDiscoverer) {
        return new RequestService(parameterBuilder, requestBodyService, operationService, parameterCustomizers, localSpringDocParameterNameDiscoverer);
    }

    @Bean
    @ConditionalOnMissingBean
    @Lazy(value=false)
    SpringWebProvider springWebProvider() {
        return new SpringWebMvcProvider();
    }

    @Bean
    @ConditionalOnMissingBean
    @Lazy(value=false)
    GenericResponseService responseBuilder(OperationService operationService, List<ReturnTypeParser> returnTypeParsers, SpringDocConfigProperties springDocConfigProperties, PropertyResolverUtils propertyResolverUtils) {
        return new GenericResponseService(operationService, returnTypeParsers, springDocConfigProperties, propertyResolverUtils);
    }

    static {
        SpringDocUtils.getConfig().setResponseEntityExceptionHandlerClass(ResponseEntityExceptionHandler.class).setModelAndViewClass(ModelAndView.class);
    }

    @ConditionalOnClass(value={WebMvcEndpointHandlerMapping.class})
    static class SpringDocWebMvcActuatorConfiguration {
        SpringDocWebMvcActuatorConfiguration() {
        }

        @Bean
        @ConditionalOnMissingBean
        @ConditionalOnExpression(value="${springdoc.show-actuator:false} or ${springdoc.use-management-port:false}")
        @Lazy(value=false)
        ActuatorProvider actuatorProvider(ServerProperties serverProperties, SpringDocConfigProperties springDocConfigProperties, Optional<ManagementServerProperties> managementServerProperties, Optional<WebEndpointProperties> webEndpointProperties, Optional<WebMvcEndpointHandlerMapping> webMvcEndpointHandlerMapping, Optional<ControllerEndpointHandlerMapping> controllerEndpointHandlerMapping) {
            return new ActuatorWebMvcProvider(serverProperties, springDocConfigProperties, managementServerProperties, webEndpointProperties, webMvcEndpointHandlerMapping, controllerEndpointHandlerMapping);
        }

        @Bean
        @ConditionalOnMissingBean(value={MultipleOpenApiSupportConfiguration.class})
        @ConditionalOnProperty(value={"springdoc.use-management-port"})
        @ConditionalOnManagementPort(value=ManagementPortType.DIFFERENT)
        @Lazy(value=false)
        OpenApiActuatorResource openApiActuatorResource(ObjectFactory<OpenAPIService> openAPIBuilderObjectFactory, AbstractRequestService requestBuilder, GenericResponseService responseBuilder, OperationService operationParser, SpringDocConfigProperties springDocConfigProperties, Optional<List<OperationCustomizer>> operationCustomizers, Optional<List<OpenApiCustomiser>> openApiCustomisers, Optional<List<OpenApiMethodFilter>> methodFilters, SpringDocProviders springDocProviders) {
            return new OpenApiActuatorResource(openAPIBuilderObjectFactory, requestBuilder, responseBuilder, operationParser, operationCustomizers, openApiCustomisers, methodFilters, springDocConfigProperties, springDocProviders);
        }
    }

    @ConditionalOnClass(value={RouterFunction.class})
    static class SpringDocWebMvcRouterConfiguration {
        SpringDocWebMvcRouterConfiguration() {
        }

        @Bean
        @ConditionalOnMissingBean
        @Lazy(value=false)
        RouterFunctionWebMvcProvider routerFunctionProvider() {
            return new RouterFunctionWebMvcProvider();
        }
    }
}

