/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.jobmaster.slotpool;

import java.util.Collection;
import java.util.Optional;
import javax.annotation.Nonnull;
import org.apache.flink.runtime.clusterframework.types.ResourceProfile;
import org.apache.flink.runtime.jobmanager.scheduler.Locality;
import org.apache.flink.runtime.jobmaster.slotpool.LocationPreferenceSlotSelectionStrategy;
import org.apache.flink.runtime.jobmaster.slotpool.SlotSelectionStrategy;

class DefaultLocationPreferenceSlotSelectionStrategy
extends LocationPreferenceSlotSelectionStrategy {
    DefaultLocationPreferenceSlotSelectionStrategy() {
    }

    @Override
    @Nonnull
    protected Optional<SlotSelectionStrategy.SlotInfoAndLocality> selectWithoutLocationPreference(@Nonnull Collection<SlotSelectionStrategy.SlotInfoAndResources> availableSlots, @Nonnull ResourceProfile resourceProfile) {
        for (SlotSelectionStrategy.SlotInfoAndResources candidate : availableSlots) {
            if (!candidate.getRemainingResources().isMatching(resourceProfile)) continue;
            return Optional.of(SlotSelectionStrategy.SlotInfoAndLocality.of(candidate.getSlotInfo(), Locality.UNCONSTRAINED));
        }
        return Optional.empty();
    }

    @Override
    protected double calculateCandidateScore(int localWeigh, int hostLocalWeigh, double taskExecutorUtilization) {
        return localWeigh * 10 + hostLocalWeigh;
    }
}

