/*
 * Decompiled with CFR 0.152.
 */
package org.apache.streampark.flink.core.scala;

import java.time.Duration;
import org.apache.flink.api.common.eventtime.SerializableTimestampAssigner;
import org.apache.flink.api.common.eventtime.WatermarkGeneratorSupplier;
import org.apache.flink.api.common.eventtime.WatermarkStrategy;
import org.apache.flink.api.common.typeinfo.TypeInformation;
import org.apache.flink.streaming.api.functions.AssignerWithPeriodicWatermarks;
import org.apache.flink.streaming.api.functions.AssignerWithPunctuatedWatermarks;
import org.apache.flink.streaming.api.functions.ProcessFunction;
import org.apache.flink.streaming.api.watermark.Watermark;
import org.apache.flink.streaming.api.windowing.time.Time;
import org.apache.flink.streaming.runtime.operators.util.AssignerWithPeriodicWatermarksAdapter;
import org.apache.flink.streaming.runtime.operators.util.AssignerWithPunctuatedWatermarksAdapter;
import org.apache.flink.util.Collector;
import org.apache.flink.util.OutputTag;
import scala.Function1;
import scala.Function2;
import scala.Function3;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.Null$;

@ScalaSignature(bytes="\u0006\u0001\u0005}w!B\u0001\u0003\u0011\u0003y\u0011!\u0004#bi\u0006\u001cFO]3b[\u0016CHO\u0003\u0002\u0004\t\u0005)1oY1mC*\u0011QAB\u0001\u0005G>\u0014XM\u0003\u0002\b\u0011\u0005)a\r\\5oW*\u0011\u0011BC\u0001\u000bgR\u0014X-Y7qCJ\\'BA\u0006\r\u0003\u0019\t\u0007/Y2iK*\tQ\"A\u0002pe\u001e\u001c\u0001\u0001\u0005\u0002\u0011#5\t!AB\u0003\u0013\u0005!\u00051CA\u0007ECR\f7\u000b\u001e:fC6,\u0005\u0010^\n\u0003#Q\u0001\"!F\f\u000e\u0003YQ\u0011aA\u0005\u00031Y\u0011a!\u00118z%\u00164\u0007\"\u0002\u000e\u0012\t\u0003Y\u0012A\u0002\u001fj]&$h\bF\u0001\u0010\r\u0011i\u0012\u0003\u0001\u0010\u0003\u0015\u0011\u000bG/Y*ue\u0016\fW.\u0006\u0002 [M\u0011A\u0004\u0006\u0005\tCq\u0011\t\u0011)A\u0005E\u0005QA-\u0019;b'R\u0014X-Y7\u0011\u0007\rR3&D\u0001%\u0015\t\u0019QE\u0003\u0002'O\u0005\u0019\u0011\r]5\u000b\u0005!J\u0013!C:ue\u0016\fW.\u001b8h\u0015\t9!\"\u0003\u0002\u001eIA\u0011A&\f\u0007\u0001\t\u0015qCD1\u00010\u0005\u0005!\u0016C\u0001\u00194!\t)\u0012'\u0003\u00023-\t9aj\u001c;iS:<\u0007CA\u000b5\u0013\t)dCA\u0002B]fD\u0001b\u000e\u000f\u0003\u0004\u0003\u0006Y\u0001O\u0001\u000bKZLG-\u001a8dK\u0012\n\u0004cA\u001d@W5\t!H\u0003\u0002<y\u0005AA/\u001f9fS:4wN\u0003\u0002>}\u000511m\\7n_:T!AJ\u0015\n\u0005\u0001S$a\u0004+za\u0016LeNZ8s[\u0006$\u0018n\u001c8\t\u000biaB\u0011\u0001\"\u0015\u0005\r;EC\u0001#G!\r)EdK\u0007\u0002#!)q'\u0011a\u0002q!)\u0011%\u0011a\u0001E!)\u0011\n\bC\u0001\u0015\u000691/\u001b3f\u001fV$HC\u0001\u0012L\u0011\u0015a\u0005\n1\u0001N\u0003\r1WO\u001c\t\u0006+9[\u0003+W\u0005\u0003\u001fZ\u0011\u0011BR;oGRLwN\u001c\u001a\u0011\u0005E;\u0006\u0003\u0002*VW-j\u0011a\u0015\u0006\u0003)\u0016\n\u0011BZ;oGRLwN\\:\n\u0005Y\u001b&a\u0004)s_\u000e,7o\u001d$v]\u000e$\u0018n\u001c8\n\u0005a+&aB\"p]R,\u0007\u0010\u001e\t\u0003+iK!a\u0017\f\u0003\tUs\u0017\u000e\u001e\u0005\u0006;r!\tAX\u0001\bg&$WmR3u+\ty6\r\u0006\u0002aQR\u0011\u0011-\u001a\t\u0004G)\u0012\u0007C\u0001\u0017d\t\u0015!GL1\u00010\u0005\u0005\u0011\u0006b\u00024]\u0003\u0003\u0005\u001daZ\u0001\u000bKZLG-\u001a8dK\u0012\u0012\u0004cA\u001d@E\")\u0011\u000e\u0018a\u0001U\u000691/\u001b3f)\u0006<\u0007CA6o\u001d\t)B.\u0003\u0002n-\u00051\u0001K]3eK\u001aL!a\u001c9\u0003\rM#(/\u001b8h\u0015\tig\u0003C\u0003s9\u0011\u00051/\u0001\u0010c_VtG-\u001a3PkR|em\u0014:eKJtWm]:XCR,'/\\1sWR\u0019!\u0005\u001e?\t\u000bU\f\b\u0019\u0001<\u0002\t\u0019,hn\u0019\t\u0005+]\\\u00130\u0003\u0002y-\tIa)\u001e8di&|g.\r\t\u0003+iL!a\u001f\f\u0003\t1{gn\u001a\u0005\u0006{F\u0004\rA`\u0001\tIV\u0014\u0018\r^5p]B\u0019q0!\u0003\u000e\u0005\u0005\u0005!\u0002BA\u0002\u0003\u000b\tA\u0001^5nK*\u0011\u0011qA\u0001\u0005U\u00064\u0018-\u0003\u0003\u0002\f\u0005\u0005!\u0001\u0003#ve\u0006$\u0018n\u001c8\t\u000f\u0005=A\u0004\"\u0001\u0002\u0012\u0005\u0001B/[7f\u0019\u0006<w+\u0019;fe6\f'o\u001b\u000b\u0006E\u0005M\u0011Q\u0003\u0005\u0007\u0019\u00065\u0001\u0019\u0001<\t\u0011\u0005]\u0011Q\u0002a\u0001\u00033\t!\"\\1y)&lW\rT1h!\u0011\tY\"a\t\u000e\u0005\u0005u!\u0002BA\u0002\u0003?Q1!!\t&\u0003%9\u0018N\u001c3po&tw-\u0003\u0003\u0002&\u0005u!\u0001\u0002+j[\u0016Dq!!\u000b\u001d\t\u0003\tY#A\nqk:\u001cG/^1uK\u0012<\u0016\r^3s[\u0006\u00148\u000eF\u0003#\u0003[\t\t\u0004C\u0004\u00020\u0005\u001d\u0002\u0019\u0001<\u0002\u001d\u0015DHO]1diRKW.\u001a$v]\"A\u00111GA\u0014\u0001\u0004\t)$A\u0005dQ\u0016\u001c7NR;oGB)Qc^\u0016\u00028A\u0019Q#!\u000f\n\u0007\u0005mbCA\u0004C_>dW-\u00198\t\u000f\u0005}B\u0004\"\u0001\u0002B\u0005!\u0001O]8d+\u0011\t\u0019%a\u0013\u0015\r\u0005\u0015\u00131KA7)\u0011\t9%!\u0014\u0011\t\rR\u0013\u0011\n\t\u0004Y\u0005-CA\u00023\u0002>\t\u0007q\u0006\u0003\u0006\u0002P\u0005u\u0012\u0011!a\u0002\u0003#\n!\"\u001a<jI\u0016t7-\u001a\u00134!\u0011It(!\u0013\t\u0011\u0005U\u0013Q\ba\u0001\u0003/\nq\u0002\u001d:pG\u0016\u001c8OR;oGRLwN\u001c\t\n+\u0005e3&!\u0018\u0002beK1!a\u0017\u0017\u0005%1UO\\2uS>t7\u0007E\u0002\u0002`]\u0003RAU+,\u0003\u0013\u0002b!a\u0019\u0002j\u0005%SBAA3\u0015\r\t9'K\u0001\u0005kRLG.\u0003\u0003\u0002l\u0005\u0015$!C\"pY2,7\r^8s\u0011)\ty'!\u0010\u0011\u0002\u0003\u0007\u0011\u0011O\u0001\u0010_:$\u0016.\\3s\rVt7\r^5p]BIQ#!\u0017z\u0003g\n\t'\u0017\t\u0005\u0003?\n)(C\u0002\u0002xU\u0013ab\u00148US6,'oQ8oi\u0016DH\u000fC\u0005\u0002|q\t\n\u0011\"\u0001\u0002~\u0005q\u0001O]8dI\u0011,g-Y;mi\u0012\u0012T\u0003BA@\u00037+\"!!!+\t\u0005\r\u0015\u0011\u0012\t\u0004+\u0005\u0015\u0015bAAD-\t!a*\u001e7mW\t\tY\t\u0005\u0003\u0002\u000e\u0006]UBAAH\u0015\u0011\t\t*a%\u0002\u0013Ut7\r[3dW\u0016$'bAAK-\u0005Q\u0011M\u001c8pi\u0006$\u0018n\u001c8\n\t\u0005e\u0015q\u0012\u0002\u0012k:\u001c\u0007.Z2lK\u00124\u0016M]5b]\u000e,GA\u00023\u0002z\t\u0007qFB\u0003W#\u0001\ty*\u0006\u0004\u0002\"\u0006=\u0016QW\n\u0004\u0003;#\u0002bCAS\u0003;\u0013)\u0019!C\u0001\u0003O\u000b1a\u0019;y+\t\tI\u000bE\u0002\u0002,^\u0003bAU+\u0002.\u0006M\u0006c\u0001\u0017\u00020\u00129\u0011\u0011WAO\u0005\u0004y#AA%O!\ra\u0013Q\u0017\u0003\b\u0003o\u000biJ1\u00010\u0005\ryU\u000b\u0016\u0005\f\u0003w\u000biJ!A!\u0002\u0013\tI+\u0001\u0003dib\u0004\u0003b\u0002\u000e\u0002\u001e\u0012\u0005\u0011q\u0018\u000b\u0005\u0003\u0003\f\u0019\rE\u0004F\u0003;\u000bi+a-\t\u0011\u0005\u0015\u0016Q\u0018a\u0001\u0003SCq!SAO\t\u0003\t9-\u0006\u0003\u0002J\u0006UGCBAf\u0003/\fY\u000eF\u0002Z\u0003\u001bD!\"a4\u0002F\u0006\u0005\t9AAi\u0003))g/\u001b3f]\u000e,G\u0005\u000e\t\u0005s}\n\u0019\u000eE\u0002-\u0003+$a\u0001ZAc\u0005\u0004y\u0003bBAm\u0003\u000b\u0004\rA[\u0001\n_V$\b/\u001e;UC\u001eD\u0001\"!8\u0002F\u0002\u0007\u00111[\u0001\u0006m\u0006dW/\u001a")
public final class DataStreamExt {

    public static class DataStream<T> {
        private final org.apache.flink.streaming.api.scala.DataStream<T> dataStream;
        private final TypeInformation<T> evidence$1;

        public org.apache.flink.streaming.api.scala.DataStream<T> sideOut(Function2<T, ProcessFunction.Context, BoxedUnit> fun) {
            return this.dataStream.process(new org.apache.flink.streaming.api.functions.ProcessFunction<T, T>(this, fun){
                private final Function2 fun$1;

                public void processElement(T value, ProcessFunction.Context ctx, Collector<T> out) {
                    this.fun$1.apply(value, (Object)ctx);
                    out.collect(value);
                }
                {
                    this.fun$1 = fun$1;
                }
            }, this.evidence$1);
        }

        public <R> org.apache.flink.streaming.api.scala.DataStream<R> sideGet(String sideTag, TypeInformation<R> evidence$2) {
            return this.dataStream.getSideOutput(new org.apache.flink.streaming.api.scala.OutputTag(sideTag, evidence$2), evidence$2);
        }

        public org.apache.flink.streaming.api.scala.DataStream<T> boundedOutOfOrdernessWatermark(Function1<T, Object> func, Duration duration) {
            return this.dataStream.assignTimestampsAndWatermarks(WatermarkStrategy.forBoundedOutOfOrderness((Duration)duration).withTimestampAssigner(new SerializableTimestampAssigner<T>(this, func){
                private final Function1 func$1;

                public long extractTimestamp(T element, long recordTimestamp) {
                    return BoxesRunTime.unboxToLong((Object)this.func$1.apply(element));
                }
                {
                    this.func$1 = func$1;
                }
            }));
        }

        public org.apache.flink.streaming.api.scala.DataStream<T> timeLagWatermark(Function1<T, Object> fun, Time maxTimeLag) {
            AssignerWithPeriodicWatermarks assigner = new AssignerWithPeriodicWatermarks<T>(this, fun, maxTimeLag){
                private final Function1 fun$2;
                private final Time maxTimeLag$1;

                public long extractTimestamp(T element, long previousElementTimestamp) {
                    return BoxesRunTime.unboxToLong((Object)this.fun$2.apply(element));
                }

                public Watermark getCurrentWatermark() {
                    return new Watermark(System.currentTimeMillis() - this.maxTimeLag$1.toMilliseconds());
                }
                {
                    void var3_3;
                    this.fun$2 = fun$2;
                    this.maxTimeLag$1 = var3_3;
                }
            };
            return this.dataStream.assignTimestampsAndWatermarks(WatermarkStrategy.forGenerator((WatermarkGeneratorSupplier)new AssignerWithPeriodicWatermarksAdapter.Strategy(assigner)));
        }

        public org.apache.flink.streaming.api.scala.DataStream<T> punctuatedWatermark(Function1<T, Object> extractTimeFun, Function1<T, Object> checkFunc) {
            AssignerWithPunctuatedWatermarks assigner = new AssignerWithPunctuatedWatermarks<T>(this, extractTimeFun, checkFunc){
                private final Function1 extractTimeFun$1;
                private final Function1 checkFunc$1;

                public long extractTimestamp(T element, long previousElementTimestamp) {
                    return BoxesRunTime.unboxToLong((Object)this.extractTimeFun$1.apply(element));
                }

                public Watermark checkAndGetNextWatermark(T lastElement, long extractedTimestamp) {
                    return BoxesRunTime.unboxToBoolean((Object)this.checkFunc$1.apply(lastElement)) ? new Watermark(extractedTimestamp) : null;
                }
                {
                    void var3_3;
                    this.extractTimeFun$1 = extractTimeFun$1;
                    this.checkFunc$1 = var3_3;
                }
            };
            return this.dataStream.assignTimestampsAndWatermarks(WatermarkStrategy.forGenerator((WatermarkGeneratorSupplier)new AssignerWithPunctuatedWatermarksAdapter.Strategy(assigner)));
        }

        public <R> org.apache.flink.streaming.api.scala.DataStream<R> proc(Function3<T, ProcessFunction.Context, Collector<R>, BoxedUnit> processFunction, Function3<Object, ProcessFunction.OnTimerContext, Collector<R>, BoxedUnit> onTimerFunction, TypeInformation<R> evidence$3) {
            return this.dataStream.process(new org.apache.flink.streaming.api.functions.ProcessFunction<T, R>(this, processFunction, onTimerFunction){
                private final Function3 processFunction$1;
                private final Function3 onTimerFunction$1;

                public void processElement(T value, ProcessFunction.Context ctx, Collector<R> out) {
                    this.processFunction$1.apply(value, (Object)ctx, out);
                }

                public void onTimer(long timestamp, ProcessFunction.OnTimerContext ctx, Collector<R> out) {
                    if (this.onTimerFunction$1 == null) {
                        super.onTimer(timestamp, ctx, out);
                    } else {
                        this.onTimerFunction$1.apply((Object)BoxesRunTime.boxToLong((long)timestamp), (Object)ctx, out);
                    }
                }
                {
                    void var3_3;
                    this.processFunction$1 = processFunction$1;
                    this.onTimerFunction$1 = var3_3;
                }
            }, evidence$3);
        }

        public <R> Null$ proc$default$2() {
            return null;
        }

        public DataStream(org.apache.flink.streaming.api.scala.DataStream<T> dataStream, TypeInformation<T> evidence$1) {
            this.dataStream = dataStream;
            this.evidence$1 = evidence$1;
        }
    }

    public static class ProcessFunction<IN, OUT> {
        private final ProcessFunction.Context ctx;

        public ProcessFunction.Context ctx() {
            return this.ctx;
        }

        public <R> void sideOut(String outputTag, R value, TypeInformation<R> evidence$4) {
            org.apache.flink.streaming.api.scala.OutputTag tag = new org.apache.flink.streaming.api.scala.OutputTag(outputTag, evidence$4);
            this.ctx().output((OutputTag)tag, value);
        }

        public ProcessFunction(ProcessFunction.Context ctx) {
            this.ctx = ctx;
        }
    }
}

