/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jgit.transport;

import java.io.ByteArrayOutputStream;
import java.io.EOFException;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.UncheckedIOException;
import java.text.MessageFormat;
import java.time.Duration;
import java.time.Instant;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.TreeMap;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.eclipse.jgit.annotations.NonNull;
import org.eclipse.jgit.annotations.Nullable;
import org.eclipse.jgit.errors.CorruptObjectException;
import org.eclipse.jgit.errors.IncorrectObjectTypeException;
import org.eclipse.jgit.errors.MissingObjectException;
import org.eclipse.jgit.errors.PackProtocolException;
import org.eclipse.jgit.internal.JGitText;
import org.eclipse.jgit.internal.storage.pack.CachedPackUriProvider;
import org.eclipse.jgit.internal.storage.pack.PackWriter;
import org.eclipse.jgit.internal.transport.parser.FirstWant;
import org.eclipse.jgit.lib.Constants;
import org.eclipse.jgit.lib.NullProgressMonitor;
import org.eclipse.jgit.lib.ObjectId;
import org.eclipse.jgit.lib.ObjectReader;
import org.eclipse.jgit.lib.ProgressMonitor;
import org.eclipse.jgit.lib.Ref;
import org.eclipse.jgit.lib.RefDatabase;
import org.eclipse.jgit.lib.Repository;
import org.eclipse.jgit.revwalk.AsyncRevObjectQueue;
import org.eclipse.jgit.revwalk.DepthWalk;
import org.eclipse.jgit.revwalk.ObjectReachabilityChecker;
import org.eclipse.jgit.revwalk.ObjectWalk;
import org.eclipse.jgit.revwalk.ReachabilityChecker;
import org.eclipse.jgit.revwalk.RevCommit;
import org.eclipse.jgit.revwalk.RevFlag;
import org.eclipse.jgit.revwalk.RevFlagSet;
import org.eclipse.jgit.revwalk.RevObject;
import org.eclipse.jgit.revwalk.RevTag;
import org.eclipse.jgit.revwalk.RevWalk;
import org.eclipse.jgit.revwalk.filter.CommitTimeRevFilter;
import org.eclipse.jgit.storage.pack.PackConfig;
import org.eclipse.jgit.storage.pack.PackStatistics;
import org.eclipse.jgit.transport.AdvertiseRefsHook;
import org.eclipse.jgit.transport.CapabilitiesV2Request;
import org.eclipse.jgit.transport.FetchRequest;
import org.eclipse.jgit.transport.FetchV0Request;
import org.eclipse.jgit.transport.FetchV2Request;
import org.eclipse.jgit.transport.FilterSpec;
import org.eclipse.jgit.transport.GitProtocolConstants;
import org.eclipse.jgit.transport.LsRefsV2Request;
import org.eclipse.jgit.transport.ObjectInfoRequest;
import org.eclipse.jgit.transport.PacketLineIn;
import org.eclipse.jgit.transport.PacketLineOut;
import org.eclipse.jgit.transport.PostUploadHook;
import org.eclipse.jgit.transport.PreUploadHook;
import org.eclipse.jgit.transport.ProtocolV0Parser;
import org.eclipse.jgit.transport.ProtocolV2Hook;
import org.eclipse.jgit.transport.ProtocolV2Parser;
import org.eclipse.jgit.transport.RefAdvertiser;
import org.eclipse.jgit.transport.RefFilter;
import org.eclipse.jgit.transport.RequestNotYetReadException;
import org.eclipse.jgit.transport.ServiceMayNotContinueException;
import org.eclipse.jgit.transport.SideBandOutputStream;
import org.eclipse.jgit.transport.SideBandProgressMonitor;
import org.eclipse.jgit.transport.TransferConfig;
import org.eclipse.jgit.transport.UploadPackInternalServerErrorException;
import org.eclipse.jgit.transport.UserAgent;
import org.eclipse.jgit.transport.WantNotValidException;
import org.eclipse.jgit.util.RefMap;
import org.eclipse.jgit.util.io.InterruptTimer;
import org.eclipse.jgit.util.io.NullOutputStream;
import org.eclipse.jgit.util.io.TimeoutInputStream;
import org.eclipse.jgit.util.io.TimeoutOutputStream;

public class UploadPack {
    private final Repository db;
    private final RevWalk walk;
    private PackConfig packConfig;
    private TransferConfig transferConfig;
    private int timeout;
    private boolean biDirectionalPipe = true;
    private InterruptTimer timer;
    private boolean clientRequestedV2;
    private InputStream rawIn;
    private ResponseBufferedOutputStream rawOut;
    private PacketLineIn pckIn;
    private OutputStream msgOut = NullOutputStream.INSTANCE;
    private ErrorWriter errOut = new PackProtocolErrorWriter();
    private Map<String, Ref> refs;
    private ProtocolV2Hook protocolV2Hook = ProtocolV2Hook.DEFAULT;
    private AdvertiseRefsHook advertiseRefsHook = AdvertiseRefsHook.DEFAULT;
    private boolean advertiseRefsHookCalled;
    private RefFilter refFilter = RefFilter.DEFAULT;
    private PreUploadHook preUploadHook = PreUploadHook.NULL;
    private PostUploadHook postUploadHook = PostUploadHook.NULL;
    String userAgent;
    private Set<ObjectId> wantIds = new HashSet<ObjectId>();
    private final Set<RevObject> wantAll = new HashSet<RevObject>();
    private final Set<RevObject> commonBase = new HashSet<RevObject>();
    private int oldestTime;
    private Boolean okToGiveUp;
    private boolean sentReady;
    private Set<ObjectId> advertised;
    private final RevFlag WANT;
    private final RevFlag PEER_HAS;
    private final RevFlag COMMON;
    private final RevFlag SATISFIED;
    private final RevFlagSet SAVE;
    private RequestValidator requestValidator = new AdvertisedRequestValidator();
    private GitProtocolConstants.MultiAck multiAck = GitProtocolConstants.MultiAck.OFF;
    private boolean noDone;
    private PackStatistics statistics;
    private FetchRequest currentRequest;
    private CachedPackUriProvider cachedPackUriProvider;

    public UploadPack(Repository copyFrom) {
        this.db = copyFrom;
        this.walk = new RevWalk(this.db);
        this.walk.setRetainBody(false);
        this.WANT = this.walk.newFlag("WANT");
        this.PEER_HAS = this.walk.newFlag("PEER_HAS");
        this.COMMON = this.walk.newFlag("COMMON");
        this.SATISFIED = this.walk.newFlag("SATISFIED");
        this.walk.carry(this.PEER_HAS);
        this.SAVE = new RevFlagSet();
        this.SAVE.add(this.WANT);
        this.SAVE.add(this.PEER_HAS);
        this.SAVE.add(this.COMMON);
        this.SAVE.add(this.SATISFIED);
        this.setTransferConfig(null);
    }

    public final Repository getRepository() {
        return this.db;
    }

    public final RevWalk getRevWalk() {
        return this.walk;
    }

    public final Map<String, Ref> getAdvertisedRefs() {
        return this.refs;
    }

    public void setAdvertisedRefs(@Nullable Map<String, Ref> allRefs) {
        this.refs = allRefs != null ? allRefs : this.db.getAllRefs();
        this.refs = this.refFilter == RefFilter.DEFAULT ? this.transferConfig.getRefFilter().filter(this.refs) : this.refFilter.filter(this.refs);
    }

    public int getTimeout() {
        return this.timeout;
    }

    public void setTimeout(int seconds) {
        this.timeout = seconds;
    }

    public boolean isBiDirectionalPipe() {
        return this.biDirectionalPipe;
    }

    public void setBiDirectionalPipe(boolean twoWay) {
        this.biDirectionalPipe = twoWay;
    }

    public RequestPolicy getRequestPolicy() {
        if (this.requestValidator instanceof AdvertisedRequestValidator) {
            return RequestPolicy.ADVERTISED;
        }
        if (this.requestValidator instanceof ReachableCommitRequestValidator) {
            return RequestPolicy.REACHABLE_COMMIT;
        }
        if (this.requestValidator instanceof TipRequestValidator) {
            return RequestPolicy.TIP;
        }
        if (this.requestValidator instanceof ReachableCommitTipRequestValidator) {
            return RequestPolicy.REACHABLE_COMMIT_TIP;
        }
        if (this.requestValidator instanceof AnyRequestValidator) {
            return RequestPolicy.ANY;
        }
        return null;
    }

    public void setRequestPolicy(RequestPolicy policy) {
        switch (policy) {
            default: {
                this.requestValidator = new AdvertisedRequestValidator();
                break;
            }
            case REACHABLE_COMMIT: {
                this.requestValidator = new ReachableCommitRequestValidator();
                break;
            }
            case TIP: {
                this.requestValidator = new TipRequestValidator();
                break;
            }
            case REACHABLE_COMMIT_TIP: {
                this.requestValidator = new ReachableCommitTipRequestValidator();
                break;
            }
            case ANY: {
                this.requestValidator = new AnyRequestValidator();
            }
        }
    }

    public void setRequestValidator(@Nullable RequestValidator validator) {
        this.requestValidator = validator != null ? validator : new AdvertisedRequestValidator();
    }

    public AdvertiseRefsHook getAdvertiseRefsHook() {
        return this.advertiseRefsHook;
    }

    public RefFilter getRefFilter() {
        return this.refFilter;
    }

    public void setAdvertiseRefsHook(@Nullable AdvertiseRefsHook advertiseRefsHook) {
        this.advertiseRefsHook = advertiseRefsHook != null ? advertiseRefsHook : AdvertiseRefsHook.DEFAULT;
    }

    public void setProtocolV2Hook(@Nullable ProtocolV2Hook hook) {
        this.protocolV2Hook = hook != null ? hook : ProtocolV2Hook.DEFAULT;
    }

    public ProtocolV2Hook getProtocolV2Hook() {
        return this.protocolV2Hook != null ? this.protocolV2Hook : ProtocolV2Hook.DEFAULT;
    }

    public void setRefFilter(@Nullable RefFilter refFilter) {
        this.refFilter = refFilter != null ? refFilter : RefFilter.DEFAULT;
    }

    public PreUploadHook getPreUploadHook() {
        return this.preUploadHook;
    }

    public void setPreUploadHook(@Nullable PreUploadHook hook) {
        this.preUploadHook = hook != null ? hook : PreUploadHook.NULL;
    }

    public PostUploadHook getPostUploadHook() {
        return this.postUploadHook;
    }

    public void setPostUploadHook(@Nullable PostUploadHook hook) {
        this.postUploadHook = hook != null ? hook : PostUploadHook.NULL;
    }

    public void setPackConfig(@Nullable PackConfig pc) {
        this.packConfig = pc;
    }

    public void setTransferConfig(@Nullable TransferConfig tc) {
        TransferConfig transferConfig = this.transferConfig = tc != null ? tc : new TransferConfig(this.db);
        if (this.transferConfig.isAllowTipSha1InWant()) {
            this.setRequestPolicy(this.transferConfig.isAllowReachableSha1InWant() ? RequestPolicy.REACHABLE_COMMIT_TIP : RequestPolicy.TIP);
        } else {
            this.setRequestPolicy(this.transferConfig.isAllowReachableSha1InWant() ? RequestPolicy.REACHABLE_COMMIT : RequestPolicy.ADVERTISED);
        }
    }

    public boolean isSideBand() throws RequestNotYetReadException {
        if (this.currentRequest == null) {
            throw new RequestNotYetReadException();
        }
        Set<String> caps = this.currentRequest.getClientCapabilities();
        return caps.contains("side-band") || caps.contains("side-band-64k");
    }

    public void setExtraParameters(Collection<String> params) {
        this.clientRequestedV2 = params.contains("version=2");
    }

    public void setCachedPackUriProvider(@Nullable CachedPackUriProvider p) {
        this.cachedPackUriProvider = p;
    }

    private boolean useProtocolV2() {
        return (this.transferConfig.protocolVersion == null || TransferConfig.ProtocolVersion.V2.equals((Object)this.transferConfig.protocolVersion)) && this.clientRequestedV2;
    }

    public void upload(InputStream input, OutputStream output, @Nullable OutputStream messages) throws IOException {
        try {
            this.uploadWithExceptionPropagation(input, output, messages);
        }
        catch (ServiceMayNotContinueException err) {
            if (!err.isOutput() && err.getMessage() != null) {
                try {
                    this.errOut.writeError(err.getMessage());
                }
                catch (IOException e) {
                    err.addSuppressed(e);
                    throw err;
                }
                err.setOutput();
            }
            throw err;
        }
        catch (IOException | Error | RuntimeException err) {
            if (this.rawOut != null) {
                String msg = err instanceof PackProtocolException ? err.getMessage() : JGitText.get().internalServerError;
                try {
                    this.errOut.writeError(msg);
                }
                catch (IOException e) {
                    err.addSuppressed(e);
                    throw err;
                }
                throw new UploadPackInternalServerErrorException(err);
            }
            throw err;
        }
    }

    public void uploadWithExceptionPropagation(InputStream input, OutputStream output, @Nullable OutputStream messages) throws ServiceMayNotContinueException, IOException {
        try {
            this.rawIn = input;
            if (messages != null) {
                this.msgOut = messages;
            }
            if (this.timeout > 0) {
                Thread caller = Thread.currentThread();
                this.timer = new InterruptTimer(String.valueOf(caller.getName()) + "-Timer");
                TimeoutInputStream i = new TimeoutInputStream(this.rawIn, this.timer);
                TimeoutOutputStream o = new TimeoutOutputStream(output, this.timer);
                i.setTimeout(this.timeout * 1000);
                o.setTimeout(this.timeout * 1000);
                this.rawIn = i;
                output = o;
            }
            this.rawOut = new ResponseBufferedOutputStream(output);
            if (this.biDirectionalPipe) {
                this.rawOut.stopBuffering();
            }
            this.pckIn = new PacketLineIn(this.rawIn);
            PacketLineOut pckOut = new PacketLineOut(this.rawOut);
            if (this.useProtocolV2()) {
                this.serviceV2(pckOut);
            } else {
                this.service(pckOut);
            }
        }
        finally {
            this.msgOut = NullOutputStream.INSTANCE;
            this.walk.close();
            if (this.timer != null) {
                try {
                    this.timer.terminate();
                }
                finally {
                    this.timer = null;
                }
            }
        }
    }

    public PackStatistics getStatistics() {
        return this.statistics;
    }

    private Map<String, Ref> getAdvertisedOrDefaultRefs() throws IOException {
        if (this.refs != null) {
            return this.refs;
        }
        if (!this.advertiseRefsHookCalled) {
            this.advertiseRefsHook.advertiseRefs(this);
            this.advertiseRefsHookCalled = true;
        }
        if (this.refs == null) {
            this.setAdvertisedRefs(this.db.getRefDatabase().getRefs().stream().collect(RefMap.toRefMap((a, b) -> b)));
        }
        return this.refs;
    }

    private Map<String, Ref> getFilteredRefs(Collection<String> refPrefixes) throws IOException {
        if (refPrefixes.isEmpty()) {
            return this.getAdvertisedOrDefaultRefs();
        }
        if (this.refs == null && !this.advertiseRefsHookCalled) {
            this.advertiseRefsHook.advertiseRefs(this);
            this.advertiseRefsHookCalled = true;
        }
        if (this.refs == null) {
            String[] prefixes = refPrefixes.toArray(new String[0]);
            Map rs = this.db.getRefDatabase().getRefsByPrefix(prefixes).stream().collect(RefMap.toRefMap((a, b) -> b));
            if (this.refFilter != RefFilter.DEFAULT) {
                return this.refFilter.filter(rs);
            }
            return this.transferConfig.getRefFilter().filter(rs);
        }
        return this.refs.values().stream().filter(ref -> refPrefixes.stream().anyMatch(ref.getName()::startsWith)).collect(RefMap.toRefMap((a, b) -> b));
    }

    @NonNull
    private static Map<String, Ref> mapRefs(Map<String, Ref> refs, List<String> names) {
        return Collections.unmodifiableMap(names.stream().map(refs::get).filter(Objects::nonNull).collect(RefMap.toRefMap((a, b) -> b)));
    }

    @NonNull
    private Map<String, Ref> exactRefs(List<String> names) throws IOException {
        if (this.refs != null) {
            return UploadPack.mapRefs(this.refs, names);
        }
        if (!this.advertiseRefsHookCalled) {
            this.advertiseRefsHook.advertiseRefs(this);
            this.advertiseRefsHookCalled = true;
        }
        if (this.refs == null && this.refFilter == RefFilter.DEFAULT && this.transferConfig.hasDefaultRefFilter()) {
            String[] ns = names.toArray(new String[0]);
            return Collections.unmodifiableMap(this.db.getRefDatabase().exactRef(ns));
        }
        return UploadPack.mapRefs(this.getAdvertisedOrDefaultRefs(), names);
    }

    @Nullable
    private Ref findRef(String name) throws IOException {
        if (this.refs != null) {
            return RefDatabase.findRef(this.refs, name);
        }
        if (!this.advertiseRefsHookCalled) {
            this.advertiseRefsHook.advertiseRefs(this);
            this.advertiseRefsHookCalled = true;
        }
        if (this.refs == null && this.refFilter == RefFilter.DEFAULT && this.transferConfig.hasDefaultRefFilter()) {
            return this.db.getRefDatabase().findRef(name);
        }
        return RefDatabase.findRef(this.getAdvertisedOrDefaultRefs(), name);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void service(PacketLineOut pckOut) throws IOException {
        block16: {
            boolean sendPack = false;
            PackStatistics.Accumulator accumulator = new PackStatistics.Accumulator();
            ArrayList<ObjectId> unshallowCommits = new ArrayList<ObjectId>();
            try {
                if (this.biDirectionalPipe) {
                    this.sendAdvertisedRefs(new RefAdvertiser.PacketLineOutRefAdvertiser(pckOut));
                } else {
                    this.advertised = this.requestValidator instanceof AnyRequestValidator ? Collections.emptySet() : UploadPack.refIdSet(this.getAdvertisedOrDefaultRefs().values());
                }
                Instant negotiateStart = Instant.now();
                accumulator.advertised = this.advertised.size();
                ProtocolV0Parser parser = new ProtocolV0Parser(this.transferConfig);
                FetchV0Request req = parser.recvWants(this.pckIn);
                this.currentRequest = req;
                this.wantIds = req.getWantIds();
                if (req.getWantIds().isEmpty()) {
                    this.preUploadHook.onBeginNegotiateRound(this, req.getWantIds(), 0);
                    this.preUploadHook.onEndNegotiateRound(this, req.getWantIds(), 0, 0, false);
                }
                accumulator.wants = req.getWantIds().size();
                if (req.getClientCapabilities().contains("multi_ack_detailed")) {
                    this.multiAck = GitProtocolConstants.MultiAck.DETAILED;
                    this.noDone = req.getClientCapabilities().contains("no-done");
                } else {
                    this.multiAck = req.getClientCapabilities().contains("multi_ack") ? GitProtocolConstants.MultiAck.CONTINUE : GitProtocolConstants.MultiAck.OFF;
                }
                if (!req.getClientShallowCommits().isEmpty()) {
                    this.verifyClientShallow(req.getClientShallowCommits());
                }
                if (req.getDepth() != 0 || req.getDeepenSince() != 0) {
                    this.computeShallowsAndUnshallows(req, shallow -> pckOut.writeString("shallow " + shallow.name() + '\n'), unshallow -> {
                        pckOut.writeString("unshallow " + unshallow.name() + '\n');
                        unshallowCommits.add((ObjectId)unshallow);
                    }, Collections.emptyList());
                    pckOut.end();
                }
                if (!req.getClientShallowCommits().isEmpty()) {
                    this.walk.assumeShallow(req.getClientShallowCommits());
                }
                sendPack = this.negotiate(req, accumulator, pckOut);
                accumulator.timeNegotiating = Duration.between(negotiateStart, Instant.now()).toMillis();
                if (!sendPack) {
                }
                if (this.biDirectionalPipe) {
                }
                int eof = this.rawIn.read();
                if (eof >= 0) {
                    sendPack = false;
                    throw new CorruptObjectException(MessageFormat.format(JGitText.get().expectedEOFReceived, "\\x" + Integer.toHexString(eof)));
                }
            }
            finally {
                if (sendPack || this.biDirectionalPipe) break block16;
            }
            while (0L < this.rawIn.skip(2048L) || this.rawIn.read() >= 0) {
            }
        }
        this.rawOut.stopBuffering();
    }

    private void lsRefsV2(PacketLineOut pckOut) throws IOException {
        ProtocolV2Parser parser = new ProtocolV2Parser(this.transferConfig);
        LsRefsV2Request req = parser.parseLsRefsRequest(this.pckIn);
        this.protocolV2Hook.onLsRefs(req);
        this.rawOut.stopBuffering();
        RefAdvertiser.PacketLineOutRefAdvertiser adv = new RefAdvertiser.PacketLineOutRefAdvertiser(pckOut);
        adv.init(this.db);
        adv.setUseProtocolV2(true);
        if (req.getPeel()) {
            adv.setDerefTags(true);
        }
        Map<String, Ref> refsToSend = this.getFilteredRefs(req.getRefPrefixes());
        if (req.getSymrefs()) {
            UploadPack.findSymrefs(adv, refsToSend);
        }
        adv.send(refsToSend.values());
        adv.end();
    }

    private Map<String, ObjectId> wantedRefs(FetchV2Request req) throws IOException {
        TreeMap<String, ObjectId> result = new TreeMap<String, ObjectId>();
        List<String> wanted = req.getWantedRefs();
        Map<String, Ref> resolved = this.exactRefs(wanted);
        for (String refName : wanted) {
            Ref ref = resolved.get(refName);
            if (ref == null) {
                throw new PackProtocolException(MessageFormat.format(JGitText.get().invalidRefName, refName));
            }
            ObjectId oid = ref.getObjectId();
            if (oid == null) {
                throw new PackProtocolException(MessageFormat.format(JGitText.get().invalidRefName, refName));
            }
            result.put(refName, oid);
        }
        return result;
    }

    private void fetchV2(PacketLineOut pckOut) throws IOException {
        this.advertised = this.requestValidator instanceof TipRequestValidator || this.requestValidator instanceof ReachableCommitTipRequestValidator || this.requestValidator instanceof AnyRequestValidator ? Collections.emptySet() : UploadPack.refIdSet(this.getAdvertisedOrDefaultRefs().values());
        PackStatistics.Accumulator accumulator = new PackStatistics.Accumulator();
        Instant negotiateStart = Instant.now();
        ProtocolV2Parser parser = new ProtocolV2Parser(this.transferConfig);
        FetchV2Request req = parser.parseFetchRequest(this.pckIn);
        this.currentRequest = req;
        this.rawOut.stopBuffering();
        this.protocolV2Hook.onFetch(req);
        if (req.getSidebandAll()) {
            pckOut.setUsingSideband(true);
        }
        ArrayList<ObjectId> deepenNots = new ArrayList<ObjectId>();
        for (String s : req.getDeepenNotRefs()) {
            Ref ref = this.findRef(s);
            if (ref == null) {
                throw new PackProtocolException(MessageFormat.format(JGitText.get().invalidRefName, s));
            }
            deepenNots.add(ref.getObjectId());
        }
        Map<String, ObjectId> wantedRefs = this.wantedRefs(req);
        req.getWantIds().addAll(wantedRefs.values());
        this.wantIds = req.getWantIds();
        boolean sectionSent = false;
        boolean mayHaveShallow = req.getDepth() != 0 || req.getDeepenSince() != 0 || !req.getDeepenNotRefs().isEmpty();
        ArrayList shallowCommits = new ArrayList();
        ArrayList<ObjectId> unshallowCommits = new ArrayList<ObjectId>();
        if (!req.getClientShallowCommits().isEmpty()) {
            this.verifyClientShallow(req.getClientShallowCommits());
        }
        if (mayHaveShallow) {
            this.computeShallowsAndUnshallows(req, shallowCommit -> {
                boolean bl = shallowCommits.add(shallowCommit);
            }, unshallowCommit -> {
                boolean bl = unshallowCommits.add((ObjectId)unshallowCommit);
            }, deepenNots);
        }
        if (!req.getClientShallowCommits().isEmpty()) {
            this.walk.assumeShallow(req.getClientShallowCommits());
        }
        if (req.wasDoneReceived()) {
            this.processHaveLines(req.getPeerHas(), ObjectId.zeroId(), new PacketLineOut(NullOutputStream.INSTANCE, false), accumulator, req.wasWaitForDoneReceived() ? Option.WAIT_FOR_DONE : Option.NONE);
        } else {
            pckOut.writeString("acknowledgments\n");
            for (ObjectId objectId : req.getPeerHas()) {
                if (!this.walk.getObjectReader().has(objectId)) continue;
                pckOut.writeString("ACK " + objectId.getName() + "\n");
            }
            this.processHaveLines(req.getPeerHas(), ObjectId.zeroId(), new PacketLineOut(NullOutputStream.INSTANCE, false), accumulator, Option.NONE);
            if (!req.wasWaitForDoneReceived() && this.okToGiveUp()) {
                pckOut.writeString("ready\n");
            } else if (this.commonBase.isEmpty()) {
                pckOut.writeString("NAK\n");
            }
            sectionSent = true;
        }
        if (req.wasDoneReceived() || !req.wasWaitForDoneReceived() && this.okToGiveUp()) {
            if (mayHaveShallow) {
                if (sectionSent) {
                    pckOut.writeDelim();
                }
                pckOut.writeString("shallow-info\n");
                for (ObjectId objectId : shallowCommits) {
                    pckOut.writeString("shallow " + objectId.getName() + '\n');
                }
                for (ObjectId objectId : unshallowCommits) {
                    pckOut.writeString("unshallow " + objectId.getName() + '\n');
                }
                sectionSent = true;
            }
            if (!wantedRefs.isEmpty()) {
                if (sectionSent) {
                    pckOut.writeDelim();
                }
                pckOut.writeString("wanted-refs\n");
                for (Map.Entry entry : wantedRefs.entrySet()) {
                    pckOut.writeString(String.valueOf(((ObjectId)entry.getValue()).getName()) + ' ' + (String)entry.getKey() + '\n');
                }
                sectionSent = true;
            }
            if (sectionSent) {
                pckOut.writeDelim();
            }
            if (!pckOut.isUsingSideband()) {
                pckOut.writeString("packfile\n");
            }
            accumulator.timeNegotiating = Duration.between(negotiateStart, Instant.now()).toMillis();
            this.sendPack(accumulator, req, req.getClientCapabilities().contains("include-tag") ? this.db.getRefDatabase().getRefsByPrefix("refs/tags/") : null, unshallowCommits, deepenNots, pckOut);
        } else {
            pckOut.end();
        }
    }

    private void objectInfo(PacketLineOut pckOut) throws IOException {
        ProtocolV2Parser parser = new ProtocolV2Parser(this.transferConfig);
        ObjectInfoRequest req = parser.parseObjectInfoRequest(this.pckIn);
        this.protocolV2Hook.onObjectInfo(req);
        ObjectReader or = this.getRepository().newObjectReader();
        pckOut.writeString("size");
        for (ObjectId oid : req.getObjectIDs()) {
            long size;
            try {
                size = or.getObjectSize(oid, -1);
            }
            catch (MissingObjectException e) {
                throw new PackProtocolException(MessageFormat.format(JGitText.get().missingObject, oid.name()), e);
            }
            pckOut.writeString(String.valueOf(oid.getName()) + " " + size);
        }
        pckOut.end();
    }

    private boolean serveOneCommandV2(PacketLineOut pckOut) throws IOException {
        String command;
        try {
            command = this.pckIn.readString();
        }
        catch (EOFException eof) {
            return true;
        }
        if (PacketLineIn.isEnd(command)) {
            return true;
        }
        if (command.equals("command=ls-refs")) {
            this.lsRefsV2(pckOut);
            return false;
        }
        if (command.equals("command=fetch")) {
            this.fetchV2(pckOut);
            return false;
        }
        if (command.equals("command=object-info")) {
            this.objectInfo(pckOut);
            return false;
        }
        throw new PackProtocolException(MessageFormat.format(JGitText.get().unknownTransportCommand, command));
    }

    private List<String> getV2CapabilityAdvertisement() {
        ArrayList<String> caps = new ArrayList<String>();
        caps.add("version 2");
        caps.add("ls-refs");
        boolean advertiseRefInWant = this.transferConfig.isAllowRefInWant() && this.db.getConfig().getBoolean("uploadpack", null, "advertiserefinwant", true);
        caps.add("fetch=" + (this.transferConfig.isAllowFilter() ? "filter " : "") + (advertiseRefInWant ? "ref-in-want " : "") + (this.transferConfig.isAdvertiseSidebandAll() ? "sideband-all " : "") + (this.cachedPackUriProvider != null ? "packfile-uris " : "") + (this.transferConfig.isAdvertiseWaitForDone() ? "wait-for-done " : "") + "shallow");
        caps.add("server-option");
        return caps;
    }

    private void serviceV2(PacketLineOut pckOut) throws IOException {
        block7: {
            if (this.biDirectionalPipe) {
                this.protocolV2Hook.onCapabilities(CapabilitiesV2Request.builder().build());
                for (String s : this.getV2CapabilityAdvertisement()) {
                    pckOut.writeString(String.valueOf(s) + "\n");
                }
                pckOut.end();
                while (!this.serveOneCommandV2(pckOut)) {
                }
                return;
            }
            try {
                this.serveOneCommandV2(pckOut);
                break block7;
            }
            catch (Throwable throwable) {
                // empty catch block
            }
            while (0L < this.rawIn.skip(2048L) || this.rawIn.read() >= 0) {
            }
            this.rawOut.stopBuffering();
            throw throwable;
        }
        while (0L < this.rawIn.skip(2048L) || this.rawIn.read() >= 0) {
        }
        this.rawOut.stopBuffering();
    }

    private static Set<ObjectId> refIdSet(Collection<Ref> refs) {
        HashSet<ObjectId> ids = new HashSet<ObjectId>(refs.size());
        for (Ref ref : refs) {
            ObjectId id = ref.getObjectId();
            if (id != null) {
                ids.add(id);
            }
            if ((id = ref.getPeeledObjectId()) == null) continue;
            ids.add(id);
        }
        return ids;
    }

    private void computeShallowsAndUnshallows(FetchRequest req, IOConsumer<ObjectId> shallowFunc, IOConsumer<ObjectId> unshallowFunc, List<ObjectId> deepenNots) throws IOException {
        if (req.getClientCapabilities().contains("deepen-relative")) {
            throw new UnsupportedOperationException();
        }
        int walkDepth = req.getDepth() == 0 ? Integer.MAX_VALUE : req.getDepth() - 1;
        Throwable throwable = null;
        Object var7_8 = null;
        try (DepthWalk.RevWalk depthWalk = new DepthWalk.RevWalk(this.walk.getObjectReader(), walkDepth);){
            ObjectId o2;
            depthWalk.setDeepenSince(req.getDeepenSince());
            for (ObjectId o2 : req.getWantIds()) {
                try {
                    depthWalk.markRoot(depthWalk.parseCommit(o2));
                }
                catch (IncorrectObjectTypeException incorrectObjectTypeException) {
                    // empty catch block
                }
            }
            depthWalk.setDeepenNots(deepenNots);
            boolean atLeastOne = false;
            while ((o2 = depthWalk.next()) != null) {
                boolean isBoundary;
                DepthWalk.Commit c = (DepthWalk.Commit)o2;
                atLeastOne = true;
                boolean bl = isBoundary = c.getDepth() == walkDepth || c.isBoundary();
                if (isBoundary && !req.getClientShallowCommits().contains(c)) {
                    shallowFunc.accept(c.copy());
                }
                if (isBoundary || !req.getClientShallowCommits().remove(c)) continue;
                unshallowFunc.accept(c.copy());
            }
            if (!atLeastOne) {
                throw new PackProtocolException(JGitText.get().noCommitsSelectedForShallow);
            }
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
    }

    private void verifyClientShallow(Set<ObjectId> shallowCommits) throws IOException, PackProtocolException {
        block7: {
            AsyncRevObjectQueue q = this.walk.parseAny(shallowCommits, true);
            try {
                while (true) {
                    try {
                        RevObject o;
                        do {
                            if ((o = q.next()) != null) continue;
                            break block7;
                        } while (o instanceof RevCommit);
                        throw new PackProtocolException(MessageFormat.format(JGitText.get().invalidShallowObject, o.name()));
                    }
                    catch (MissingObjectException notCommit) {
                        shallowCommits.remove(notCommit.getObjectId());
                        continue;
                    }
                    break;
                }
            }
            finally {
                q.release();
            }
        }
    }

    public void sendAdvertisedRefs(RefAdvertiser adv) throws IOException, ServiceMayNotContinueException {
        this.sendAdvertisedRefs(adv, null);
    }

    public void sendAdvertisedRefs(RefAdvertiser adv, @Nullable String serviceName) throws IOException, ServiceMayNotContinueException {
        RequestPolicy policy;
        if (this.useProtocolV2()) {
            this.protocolV2Hook.onCapabilities(CapabilitiesV2Request.builder().build());
            for (String s : this.getV2CapabilityAdvertisement()) {
                adv.writeOne(s);
            }
            adv.end();
            return;
        }
        Map<String, Ref> advertisedOrDefaultRefs = this.getAdvertisedOrDefaultRefs();
        if (serviceName != null) {
            adv.writeOne("# service=" + serviceName + '\n');
            adv.end();
        }
        adv.init(this.db);
        adv.advertiseCapability("include-tag");
        adv.advertiseCapability("multi_ack_detailed");
        adv.advertiseCapability("multi_ack");
        adv.advertiseCapability("ofs-delta");
        adv.advertiseCapability("side-band");
        adv.advertiseCapability("side-band-64k");
        adv.advertiseCapability("thin-pack");
        adv.advertiseCapability("no-progress");
        adv.advertiseCapability("shallow");
        if (!this.biDirectionalPipe) {
            adv.advertiseCapability("no-done");
        }
        if ((policy = this.getRequestPolicy()) == RequestPolicy.TIP || policy == RequestPolicy.REACHABLE_COMMIT_TIP || policy == null) {
            adv.advertiseCapability("allow-tip-sha1-in-want");
        }
        if (policy == RequestPolicy.REACHABLE_COMMIT || policy == RequestPolicy.REACHABLE_COMMIT_TIP || policy == null) {
            adv.advertiseCapability("allow-reachable-sha1-in-want");
        }
        adv.advertiseCapability("agent", UserAgent.get());
        if (this.transferConfig.isAllowFilter()) {
            adv.advertiseCapability("filter");
        }
        adv.setDerefTags(true);
        UploadPack.findSymrefs(adv, advertisedOrDefaultRefs);
        this.advertised = adv.send(advertisedOrDefaultRefs.values());
        if (adv.isEmpty()) {
            adv.advertiseId(ObjectId.zeroId(), "capabilities^{}");
        }
        adv.end();
    }

    public void sendMessage(String what) {
        try {
            this.msgOut.write(Constants.encode(String.valueOf(what) + "\n"));
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    public OutputStream getMessageOutputStream() {
        return this.msgOut;
    }

    public int getDepth() {
        if (this.currentRequest == null) {
            throw new RequestNotYetReadException();
        }
        return this.currentRequest.getDepth();
    }

    @Deprecated
    public final long getFilterBlobLimit() {
        return this.getFilterSpec().getBlobLimit();
    }

    public final FilterSpec getFilterSpec() {
        if (this.currentRequest == null) {
            throw new RequestNotYetReadException();
        }
        return this.currentRequest.getFilterSpec();
    }

    public String getPeerUserAgent() {
        if (this.currentRequest != null && this.currentRequest.getAgent() != null) {
            return this.currentRequest.getAgent();
        }
        return this.userAgent;
    }

    private boolean negotiate(FetchRequest req, PackStatistics.Accumulator accumulator, PacketLineOut pckOut) throws IOException {
        String line;
        this.okToGiveUp = Boolean.FALSE;
        ObjectId last = ObjectId.zeroId();
        ArrayList<ObjectId> peerHas = new ArrayList<ObjectId>(64);
        while (true) {
            try {
                line = this.pckIn.readString();
            }
            catch (EOFException eof) {
                if (!this.biDirectionalPipe && req.getDepth() > 0) {
                    return false;
                }
                throw eof;
            }
            if (PacketLineIn.isEnd(line)) {
                last = this.processHaveLines(peerHas, last, pckOut, accumulator, Option.NONE);
                if (this.commonBase.isEmpty() || this.multiAck != GitProtocolConstants.MultiAck.OFF) {
                    pckOut.writeString("NAK\n");
                }
                if (this.noDone && this.sentReady) {
                    pckOut.writeString("ACK " + last.name() + "\n");
                    return true;
                }
                if (!this.biDirectionalPipe) {
                    return false;
                }
                pckOut.flush();
                continue;
            }
            if (!line.startsWith("have ") || line.length() != 45) break;
            peerHas.add(ObjectId.fromString(line.substring(5)));
            ++accumulator.haves;
        }
        if (line.equals("done")) {
            last = this.processHaveLines(peerHas, last, pckOut, accumulator, Option.NONE);
            if (this.commonBase.isEmpty()) {
                pckOut.writeString("NAK\n");
            } else if (this.multiAck != GitProtocolConstants.MultiAck.OFF) {
                pckOut.writeString("ACK " + last.name() + "\n");
            }
            return true;
        }
        throw new PackProtocolException(MessageFormat.format(JGitText.get().expectedGot, "have", line));
    }

    private ObjectId processHaveLines(List<ObjectId> peerHas, ObjectId last, PacketLineOut out, PackStatistics.Accumulator accumulator, Option option) throws IOException {
        this.preUploadHook.onBeginNegotiateRound(this, this.wantIds, peerHas.size());
        if (this.wantAll.isEmpty() && !this.wantIds.isEmpty()) {
            this.parseWants(accumulator);
        }
        if (peerHas.isEmpty()) {
            return last;
        }
        this.sentReady = false;
        int haveCnt = 0;
        this.walk.getObjectReader().setAvoidUnreachableObjects(true);
        AsyncRevObjectQueue q = this.walk.parseAny(peerHas, false);
        try {
            while (true) {
                RevObject obj;
                try {
                    obj = q.next();
                }
                catch (MissingObjectException notFound) {
                    continue;
                }
                if (obj == null) {
                    break;
                }
                last = obj;
                ++haveCnt;
                if (obj instanceof RevCommit) {
                    RevCommit c = (RevCommit)obj;
                    if (this.oldestTime == 0 || c.getCommitTime() < this.oldestTime) {
                        this.oldestTime = c.getCommitTime();
                    }
                }
                if (obj.has(this.PEER_HAS)) continue;
                obj.add(this.PEER_HAS);
                if (obj instanceof RevCommit) {
                    ((RevCommit)obj).carry(this.PEER_HAS);
                }
                this.addCommonBase(obj);
                switch (this.multiAck) {
                    case OFF: {
                        if (this.commonBase.size() != 1) break;
                        out.writeString("ACK " + obj.name() + "\n");
                        break;
                    }
                    case CONTINUE: {
                        out.writeString("ACK " + obj.name() + " continue\n");
                        break;
                    }
                    case DETAILED: {
                        out.writeString("ACK " + obj.name() + " common\n");
                    }
                }
            }
        }
        finally {
            q.release();
            this.walk.getObjectReader().setAvoidUnreachableObjects(false);
        }
        int missCnt = peerHas.size() - haveCnt;
        if (option != Option.WAIT_FOR_DONE) {
            this.sentReady = this.shouldGiveUp(peerHas, out, missCnt);
        }
        this.preUploadHook.onEndNegotiateRound(this, this.wantAll, haveCnt, missCnt, this.sentReady);
        peerHas.clear();
        return last;
    }

    private boolean shouldGiveUp(List<ObjectId> peerHas, PacketLineOut out, int missCnt) throws IOException {
        boolean sentReady = false;
        boolean didOkToGiveUp = false;
        if (missCnt > 0) {
            int i = peerHas.size() - 1;
            while (i >= 0) {
                ObjectId id = peerHas.get(i);
                if (this.walk.lookupOrNull(id) == null) {
                    didOkToGiveUp = true;
                    if (!this.okToGiveUp()) break;
                    switch (this.multiAck) {
                        case OFF: {
                            break;
                        }
                        case CONTINUE: {
                            out.writeString("ACK " + id.name() + " continue\n");
                            break;
                        }
                        case DETAILED: {
                            out.writeString("ACK " + id.name() + " ready\n");
                            sentReady = true;
                        }
                    }
                    break;
                }
                --i;
            }
        }
        if (this.multiAck == GitProtocolConstants.MultiAck.DETAILED && !didOkToGiveUp && this.okToGiveUp()) {
            ObjectId id = peerHas.get(peerHas.size() - 1);
            out.writeString("ACK " + id.name() + " ready\n");
            sentReady = true;
        }
        return sentReady;
    }

    private void parseWants(PackStatistics.Accumulator accumulator) throws IOException {
        ArrayList<ObjectId> notAdvertisedWants = null;
        for (ObjectId obj : this.wantIds) {
            if (this.advertised.contains(obj)) continue;
            if (notAdvertisedWants == null) {
                notAdvertisedWants = new ArrayList<ObjectId>();
            }
            notAdvertisedWants.add(obj);
        }
        if (notAdvertisedWants != null) {
            accumulator.notAdvertisedWants = notAdvertisedWants.size();
            Instant startReachabilityChecking = Instant.now();
            this.requestValidator.checkWants(this, (List<ObjectId>)notAdvertisedWants);
            accumulator.reachabilityCheckDuration = Duration.between(startReachabilityChecking, Instant.now()).toMillis();
        }
        AsyncRevObjectQueue q = this.walk.parseAny(this.wantIds, true);
        try {
            try {
                RevObject obj;
                while ((obj = q.next()) != null) {
                    this.want(obj);
                    if (!(obj instanceof RevCommit)) {
                        obj.add(this.SATISFIED);
                    }
                    if (!(obj instanceof RevTag) || !((obj = this.walk.peel(obj)) instanceof RevCommit)) continue;
                    this.want(obj);
                }
                this.wantIds.clear();
            }
            catch (MissingObjectException notFound) {
                throw new WantNotValidException(notFound.getObjectId(), (Throwable)notFound);
            }
        }
        finally {
            q.release();
        }
    }

    private void want(RevObject obj) {
        if (!obj.has(this.WANT)) {
            obj.add(this.WANT);
            this.wantAll.add(obj);
        }
    }

    private static void checkNotAdvertisedWants(UploadPack up, List<ObjectId> notAdvertisedWants, Collection<Ref> visibleRefs) throws IOException {
        ObjectReader reader = up.getRevWalk().getObjectReader();
        try {
            Throwable throwable = null;
            Object var5_7 = null;
            try (RevWalk walk = new RevWalk(reader);){
                Stream<RevCommit> reachableCommits;
                boolean repoHasBitmaps;
                walk.setRetainBody(false);
                List<RevObject> wantsAsObjs = UploadPack.objectIdsToRevObjects(walk, notAdvertisedWants);
                List<RevCommit> wantsAsCommits = wantsAsObjs.stream().filter(obj -> obj instanceof RevCommit).map(obj -> (RevCommit)obj).collect(Collectors.toList());
                boolean allWantsAreCommits = wantsAsObjs.size() == wantsAsCommits.size();
                boolean bl = repoHasBitmaps = reader.getBitmapIndex() != null;
                if (!allWantsAreCommits) {
                    if (!repoHasBitmaps && !up.transferConfig.isAllowFilter()) {
                        RevObject nonCommit = (RevObject)wantsAsObjs.stream().filter(obj -> !(obj instanceof RevCommit)).limit(1L).collect(Collectors.toList()).get(0);
                        throw new WantNotValidException(nonCommit);
                    }
                    Throwable nonCommit = null;
                    Object var12_18 = null;
                    try (ObjectWalk objWalk = walk.toObjectWalkWithSameObjects();){
                        Stream<RevObject> startersAsObjs = UploadPack.importantRefsFirst(visibleRefs).map(UploadPack::refToObjectId).map(objId -> UploadPack.objectIdToRevObject(objWalk, objId)).filter(Objects::nonNull);
                        ObjectReachabilityChecker reachabilityChecker = reader.createObjectReachabilityChecker(objWalk);
                        Optional<RevObject> unreachable = reachabilityChecker.areAllReachable(wantsAsObjs, startersAsObjs);
                        if (unreachable.isPresent()) {
                            throw new WantNotValidException(unreachable.get());
                        }
                    }
                    catch (Throwable throwable2) {
                        if (nonCommit == null) {
                            nonCommit = throwable2;
                        } else if (nonCommit != throwable2) {
                            nonCommit.addSuppressed(throwable2);
                        }
                        throw nonCommit;
                    }
                    return;
                }
                ReachabilityChecker reachabilityChecker = reader.createReachabilityChecker(walk);
                Optional<RevCommit> unreachable = reachabilityChecker.areAllReachable(wantsAsCommits, reachableCommits = UploadPack.importantRefsFirst(visibleRefs).map(UploadPack::refToObjectId).map(objId -> UploadPack.objectIdToRevCommit(walk, objId)).filter(Objects::nonNull));
                if (unreachable.isPresent()) {
                    throw new WantNotValidException(unreachable.get());
                }
            }
            catch (Throwable throwable3) {
                if (throwable == null) {
                    throwable = throwable3;
                } else if (throwable != throwable3) {
                    throwable.addSuppressed(throwable3);
                }
                throw throwable;
            }
        }
        catch (MissingObjectException notFound) {
            throw new WantNotValidException(notFound.getObjectId(), (Throwable)notFound);
        }
    }

    static Stream<Ref> importantRefsFirst(Collection<Ref> visibleRefs) {
        Predicate<Ref> startsWithRefsHeads = ref -> ref.getName().startsWith("refs/heads/");
        Predicate<Ref> startsWithRefsTags = ref -> ref.getName().startsWith("refs/tags/");
        Predicate<Ref> allOther = ref -> !startsWithRefsHeads.test((Ref)ref) && !startsWithRefsTags.test((Ref)ref);
        return Stream.concat(visibleRefs.stream().filter(startsWithRefsHeads), Stream.concat(visibleRefs.stream().filter(startsWithRefsTags), visibleRefs.stream().filter(allOther)));
    }

    private static ObjectId refToObjectId(Ref ref) {
        return ref.getObjectId() != null ? ref.getObjectId() : ref.getPeeledObjectId();
    }

    @Nullable
    private static RevCommit objectIdToRevCommit(RevWalk walk, ObjectId objectId) {
        if (objectId == null) {
            return null;
        }
        try {
            return walk.parseCommit(objectId);
        }
        catch (IOException e) {
            return null;
        }
    }

    @Nullable
    private static RevObject objectIdToRevObject(RevWalk walk, ObjectId objectId) {
        if (objectId == null) {
            return null;
        }
        try {
            return walk.parseAny(objectId);
        }
        catch (IOException e) {
            return null;
        }
    }

    private static List<RevObject> objectIdsToRevObjects(RevWalk walk, Iterable<ObjectId> objectIds) throws MissingObjectException, IOException {
        ArrayList<RevObject> result = new ArrayList<RevObject>();
        for (ObjectId objectId : objectIds) {
            result.add(walk.parseAny(objectId));
        }
        return result;
    }

    private void addCommonBase(RevObject o) {
        if (!o.has(this.COMMON)) {
            o.add(this.COMMON);
            this.commonBase.add(o);
            this.okToGiveUp = null;
        }
    }

    private boolean okToGiveUp() throws PackProtocolException {
        if (this.okToGiveUp == null) {
            this.okToGiveUp = this.okToGiveUpImp();
        }
        return this.okToGiveUp;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private boolean okToGiveUpImp() throws PackProtocolException {
        if (this.commonBase.isEmpty()) {
            return false;
        }
        try {
            RevObject obj;
            Iterator<RevObject> iterator = this.wantAll.iterator();
            do {
                if (iterator.hasNext()) continue;
                return true;
            } while (this.wantSatisfied(obj = iterator.next()));
            return false;
        }
        catch (IOException e) {
            throw new PackProtocolException(JGitText.get().internalRevisionError, e);
        }
    }

    private boolean wantSatisfied(RevObject want) throws IOException {
        RevCommit c;
        if (want.has(this.SATISFIED)) {
            return true;
        }
        if (((RevCommit)want).getParentCount() == 0) {
            want.add(this.SATISFIED);
            return true;
        }
        this.walk.resetRetain(this.SAVE);
        this.walk.markStart((RevCommit)want);
        if (this.oldestTime != 0) {
            this.walk.setRevFilter(CommitTimeRevFilter.after((long)this.oldestTime * 1000L));
        }
        while ((c = this.walk.next()) != null) {
            if (!c.has(this.PEER_HAS)) continue;
            this.addCommonBase(c);
            want.add(this.SATISFIED);
            return true;
        }
        return false;
    }

    private void sendPack(PackStatistics.Accumulator accumulator, FetchRequest req, @Nullable Collection<Ref> allTags, List<ObjectId> unshallowCommits, List<ObjectId> deepenNots, PacketLineOut pckOut) throws IOException {
        boolean sideband;
        Set<String> caps = req.getClientCapabilities();
        boolean bl = sideband = caps.contains("side-band") || caps.contains("side-band-64k");
        if (sideband) {
            this.errOut = new SideBandErrorWriter();
            int bufsz = 1000;
            if (req.getClientCapabilities().contains("side-band-64k")) {
                bufsz = 65520;
            }
            SideBandOutputStream packOut = new SideBandOutputStream(1, bufsz, this.rawOut);
            ProgressMonitor pm = NullProgressMonitor.INSTANCE;
            if (!req.getClientCapabilities().contains("no-progress")) {
                this.msgOut = new SideBandOutputStream(2, bufsz, this.rawOut);
                pm = new SideBandProgressMonitor(this.msgOut);
            }
            this.sendPack(pm, pckOut, packOut, req, accumulator, allTags, unshallowCommits, deepenNots);
            pckOut.end();
        } else {
            this.sendPack(NullProgressMonitor.INSTANCE, pckOut, this.rawOut, req, accumulator, allTags, unshallowCommits, deepenNots);
        }
    }

    private void sendPack(ProgressMonitor pm, PacketLineOut pckOut, OutputStream packOut, FetchRequest req, PackStatistics.Accumulator accumulator, @Nullable Collection<Ref> allTags, List<ObjectId> unshallowCommits, List<ObjectId> deepenNots) throws IOException {
        if (this.wantAll.isEmpty()) {
            this.preUploadHook.onSendPack(this, this.wantIds, this.commonBase);
        } else {
            this.preUploadHook.onSendPack(this, this.wantAll, this.commonBase);
        }
        this.msgOut.flush();
        this.advertised = null;
        this.refs = null;
        PackConfig cfg = this.packConfig;
        if (cfg == null) {
            cfg = new PackConfig(this.db);
        }
        PackWriter pw = new PackWriter(cfg, this.walk.getObjectReader(), accumulator);
        try {
            pw.setIndexDisabled(true);
            if (req.getFilterSpec().isNoOp()) {
                pw.setUseCachedPacks(true);
            } else {
                pw.setFilterSpec(req.getFilterSpec());
                pw.setUseCachedPacks(false);
            }
            pw.setUseBitmaps(req.getDepth() == 0 && req.getClientShallowCommits().isEmpty() && req.getFilterSpec().getTreeDepthLimit() == -1L);
            pw.setClientShallowCommits(req.getClientShallowCommits());
            pw.setReuseDeltaCommits(true);
            pw.setDeltaBaseAsOffset(req.getClientCapabilities().contains("ofs-delta"));
            pw.setThin(req.getClientCapabilities().contains("thin-pack"));
            pw.setReuseValidatingObjects(false);
            if (this.commonBase.isEmpty() && this.refs != null) {
                HashSet<ObjectId> tagTargets = new HashSet<ObjectId>();
                for (Ref ref : this.refs.values()) {
                    if (ref.getPeeledObjectId() != null) {
                        tagTargets.add(ref.getPeeledObjectId());
                        continue;
                    }
                    if (ref.getObjectId() == null || !ref.getName().startsWith("refs/heads/")) continue;
                    tagTargets.add(ref.getObjectId());
                }
                pw.setTagTargets(tagTargets);
            }
            RevWalk rw = this.walk;
            if (req.getDepth() > 0 || req.getDeepenSince() != 0 || !deepenNots.isEmpty()) {
                int walkDepth = req.getDepth() == 0 ? Integer.MAX_VALUE : req.getDepth() - 1;
                pw.setShallowPack(req.getDepth(), unshallowCommits);
                DepthWalk.RevWalk dw = new DepthWalk.RevWalk(this.walk.getObjectReader(), walkDepth);
                dw.setDeepenSince(req.getDeepenSince());
                dw.setDeepenNots(deepenNots);
                dw.assumeShallow(req.getClientShallowCommits());
                rw = dw;
            }
            if (this.wantAll.isEmpty()) {
                pw.preparePack(pm, this.wantIds, this.commonBase, req.getClientShallowCommits());
            } else {
                this.walk.reset();
                ObjectWalk ow = rw.toObjectWalkWithSameObjects();
                pw.preparePack(pm, ow, this.wantAll, this.commonBase, PackWriter.NONE);
                rw = ow;
            }
            if (req.getClientCapabilities().contains("include-tag") && allTags != null) {
                for (Ref ref : allTags) {
                    RevObject obj;
                    ObjectId objectId = ref.getObjectId();
                    if (objectId == null || (!this.wantAll.isEmpty() ? (obj = rw.lookupOrNull(objectId)) != null && obj.has(this.WANT) : this.wantIds.contains(objectId))) continue;
                    if (!ref.isPeeled()) {
                        ref = this.db.getRefDatabase().peel(ref);
                    }
                    ObjectId peeledId = ref.getPeeledObjectId();
                    objectId = ref.getObjectId();
                    if (peeledId == null || objectId == null) continue;
                    objectId = ref.getObjectId();
                    if (!pw.willInclude(peeledId) || pw.willInclude(objectId)) continue;
                    RevObject o = rw.parseAny(objectId);
                    this.addTagChain(o, pw);
                    pw.addObject(o);
                }
            }
            if (pckOut.isUsingSideband()) {
                if (req instanceof FetchV2Request && this.cachedPackUriProvider != null && !((FetchV2Request)req).getPackfileUriProtocols().isEmpty()) {
                    FetchV2Request reqV2 = (FetchV2Request)req;
                    pw.setPackfileUriConfig(new PackWriter.PackfileUriConfig(pckOut, reqV2.getPackfileUriProtocols(), this.cachedPackUriProvider));
                } else {
                    pckOut.writeString("packfile\n");
                }
            }
            pw.enableSearchForReuseTimeout();
            pw.writePack(pm, NullProgressMonitor.INSTANCE, packOut);
            if (this.msgOut != NullOutputStream.INSTANCE) {
                String msg = String.valueOf(pw.getStatistics().getMessage()) + '\n';
                this.msgOut.write(Constants.encode(msg));
                this.msgOut.flush();
            }
        }
        finally {
            this.statistics = pw.getStatistics();
            if (this.statistics != null) {
                this.postUploadHook.onPostUpload(this.statistics);
            }
            pw.close();
        }
    }

    private static void findSymrefs(RefAdvertiser adv, Map<String, Ref> refs) {
        Ref head = refs.get("HEAD");
        if (head != null && head.isSymbolic()) {
            adv.addSymref("HEAD", head.getLeaf().getName());
        }
    }

    private void addTagChain(RevObject o, PackWriter pw) throws IOException {
        while (4 == o.getType()) {
            RevTag t = (RevTag)o;
            if ((o = t.getObject()).getType() != 4 || pw.willInclude(o.getId())) continue;
            this.walk.parseBody(o);
            pw.addObject(o);
        }
    }

    public static final class AdvertisedRequestValidator
    implements RequestValidator {
        @Override
        public void checkWants(UploadPack up, List<ObjectId> wants) throws PackProtocolException, IOException {
            if (!up.isBiDirectionalPipe()) {
                new ReachableCommitRequestValidator().checkWants(up, wants);
            } else if (!wants.isEmpty()) {
                throw new WantNotValidException(wants.iterator().next());
            }
        }
    }

    public static final class AnyRequestValidator
    implements RequestValidator {
        @Override
        public void checkWants(UploadPack up, List<ObjectId> wants) throws PackProtocolException, IOException {
        }
    }

    private static interface ErrorWriter {
        public void writeError(String var1) throws IOException;
    }

    @Deprecated
    public static class FirstLine {
        private final FirstWant firstWant;

        public FirstLine(String line) {
            try {
                this.firstWant = FirstWant.fromLine(line);
            }
            catch (PackProtocolException e) {
                throw new UncheckedIOException(e);
            }
        }

        public String getLine() {
            return this.firstWant.getLine();
        }

        public Set<String> getOptions() {
            if (this.firstWant.getAgent() != null) {
                HashSet<String> caps = new HashSet<String>(this.firstWant.getCapabilities());
                caps.add("agent=" + this.firstWant.getAgent());
                return caps;
            }
            return this.firstWant.getCapabilities();
        }
    }

    @FunctionalInterface
    private static interface IOConsumer<R> {
        public void accept(R var1) throws IOException;
    }

    private static enum Option {
        WAIT_FOR_DONE,
        NONE;

    }

    private class PackProtocolErrorWriter
    implements ErrorWriter {
        private PackProtocolErrorWriter() {
        }

        @Override
        public void writeError(String message) throws IOException {
            new PacketLineOut(Objects.requireNonNull(UploadPack.this.rawOut)).writeString("ERR " + message + '\n');
        }
    }

    public static final class ReachableCommitRequestValidator
    implements RequestValidator {
        @Override
        public void checkWants(UploadPack up, List<ObjectId> wants) throws PackProtocolException, IOException {
            UploadPack.checkNotAdvertisedWants(up, wants, up.getAdvertisedRefs().values());
        }
    }

    public static final class ReachableCommitTipRequestValidator
    implements RequestValidator {
        @Override
        public void checkWants(UploadPack up, List<ObjectId> wants) throws PackProtocolException, IOException {
            UploadPack.checkNotAdvertisedWants(up, wants, up.getRepository().getRefDatabase().getRefs());
        }
    }

    public static enum RequestPolicy {
        ADVERTISED,
        REACHABLE_COMMIT,
        TIP,
        REACHABLE_COMMIT_TIP,
        ANY;

    }

    public static interface RequestValidator {
        public void checkWants(UploadPack var1, List<ObjectId> var2) throws PackProtocolException, IOException;
    }

    private static class ResponseBufferedOutputStream
    extends OutputStream {
        private final OutputStream rawOut;
        private OutputStream out;

        ResponseBufferedOutputStream(OutputStream rawOut) {
            this.rawOut = rawOut;
            this.out = new ByteArrayOutputStream();
        }

        @Override
        public void write(int b) throws IOException {
            this.out.write(b);
        }

        @Override
        public void write(byte[] b) throws IOException {
            this.out.write(b);
        }

        @Override
        public void write(byte[] b, int off, int len) throws IOException {
            this.out.write(b, off, len);
        }

        @Override
        public void flush() throws IOException {
            this.out.flush();
        }

        @Override
        public void close() throws IOException {
            this.out.close();
        }

        void stopBuffering() throws IOException {
            if (this.out != this.rawOut) {
                ((ByteArrayOutputStream)this.out).writeTo(this.rawOut);
                this.out = this.rawOut;
            }
        }
    }

    private class SideBandErrorWriter
    implements ErrorWriter {
        private SideBandErrorWriter() {
        }

        @Override
        public void writeError(String message) throws IOException {
            SideBandOutputStream err = new SideBandOutputStream(3, 1000, Objects.requireNonNull(UploadPack.this.rawOut));
            err.write(Constants.encode(message));
            err.flush();
        }
    }

    public static final class TipRequestValidator
    implements RequestValidator {
        @Override
        public void checkWants(UploadPack up, List<ObjectId> wants) throws PackProtocolException, IOException {
            if (!up.isBiDirectionalPipe()) {
                new ReachableCommitTipRequestValidator().checkWants(up, wants);
            } else if (!wants.isEmpty()) {
                Set refIds = UploadPack.refIdSet(up.getRepository().getRefDatabase().getRefs());
                for (ObjectId obj : wants) {
                    if (refIds.contains(obj)) continue;
                    throw new WantNotValidException(obj);
                }
            }
        }
    }
}

