/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.clients.consumer.internals;

import java.util.HashMap;
import java.util.Optional;
import java.util.Set;
import java.util.SortedSet;
import java.util.TreeSet;
import java.util.concurrent.CompletableFuture;
import org.apache.kafka.clients.consumer.CloseOptions;
import org.apache.kafka.clients.consumer.ConsumerRebalanceListener;
import org.apache.kafka.clients.consumer.internals.AbstractMembershipManager;
import org.apache.kafka.clients.consumer.internals.CommitRequestManager;
import org.apache.kafka.clients.consumer.internals.ConsumerMetadata;
import org.apache.kafka.clients.consumer.internals.ConsumerRebalanceListenerMethodName;
import org.apache.kafka.clients.consumer.internals.MemberState;
import org.apache.kafka.clients.consumer.internals.SubscriptionState;
import org.apache.kafka.clients.consumer.internals.events.BackgroundEventHandler;
import org.apache.kafka.clients.consumer.internals.events.ConsumerRebalanceListenerCallbackCompletedEvent;
import org.apache.kafka.clients.consumer.internals.events.ConsumerRebalanceListenerCallbackNeededEvent;
import org.apache.kafka.clients.consumer.internals.metrics.ConsumerRebalanceMetricsManager;
import org.apache.kafka.clients.consumer.internals.metrics.RebalanceMetricsManager;
import org.apache.kafka.common.KafkaException;
import org.apache.kafka.common.TopicPartition;
import org.apache.kafka.common.Uuid;
import org.apache.kafka.common.message.ConsumerGroupHeartbeatResponseData;
import org.apache.kafka.common.metrics.Metrics;
import org.apache.kafka.common.protocol.Errors;
import org.apache.kafka.common.requests.ConsumerGroupHeartbeatResponse;
import org.apache.kafka.common.utils.LogContext;
import org.apache.kafka.common.utils.Time;

public class ConsumerMembershipManager
extends AbstractMembershipManager<ConsumerGroupHeartbeatResponse> {
    protected final Optional<String> groupInstanceId;
    private final Optional<String> rackId;
    private final int rebalanceTimeoutMs;
    private final Optional<String> serverAssignor;
    private final CommitRequestManager commitRequestManager;
    private final BackgroundEventHandler backgroundEventHandler;

    public ConsumerMembershipManager(String groupId, Optional<String> groupInstanceId, Optional<String> rackId, int rebalanceTimeoutMs, Optional<String> serverAssignor, SubscriptionState subscriptions, CommitRequestManager commitRequestManager, ConsumerMetadata metadata, LogContext logContext, BackgroundEventHandler backgroundEventHandler, Time time, Metrics metrics, boolean autoCommitEnabled) {
        this(groupId, groupInstanceId, rackId, rebalanceTimeoutMs, serverAssignor, subscriptions, commitRequestManager, metadata, logContext, backgroundEventHandler, time, new ConsumerRebalanceMetricsManager(metrics), autoCommitEnabled);
    }

    ConsumerMembershipManager(String groupId, Optional<String> groupInstanceId, Optional<String> rackId, int rebalanceTimeoutMs, Optional<String> serverAssignor, SubscriptionState subscriptions, CommitRequestManager commitRequestManager, ConsumerMetadata metadata, LogContext logContext, BackgroundEventHandler backgroundEventHandler, Time time, RebalanceMetricsManager metricsManager, boolean autoCommitEnabled) {
        super(groupId, subscriptions, metadata, logContext.logger(ConsumerMembershipManager.class), time, metricsManager, autoCommitEnabled);
        this.groupInstanceId = groupInstanceId;
        this.rackId = rackId;
        this.rebalanceTimeoutMs = rebalanceTimeoutMs;
        this.serverAssignor = serverAssignor;
        this.commitRequestManager = commitRequestManager;
        this.backgroundEventHandler = backgroundEventHandler;
    }

    public Optional<String> groupInstanceId() {
        return this.groupInstanceId;
    }

    public Optional<String> rackId() {
        return this.rackId;
    }

    @Override
    public void onHeartbeatSuccess(ConsumerGroupHeartbeatResponse response) {
        ConsumerGroupHeartbeatResponseData responseData = response.data();
        if (responseData.errorCode() != Errors.NONE.code()) {
            String errorMessage = String.format("Unexpected error in Heartbeat response. Expected no error, but received: %s", new Object[]{Errors.forCode(responseData.errorCode())});
            throw new IllegalArgumentException(errorMessage);
        }
        MemberState state = this.state();
        if (state == MemberState.LEAVING) {
            this.log.debug("Ignoring heartbeat response received from broker. Member {} with epoch {} is already leaving the group.", (Object)this.memberId, (Object)this.memberEpoch);
            return;
        }
        if (state == MemberState.UNSUBSCRIBED && responseData.memberEpoch() < 0 && this.maybeCompleteLeaveInProgress()) {
            this.log.debug("Member {} with epoch {} received a successful response to the heartbeat to leave the group and completed the leave operation. ", (Object)this.memberId, (Object)this.memberEpoch);
            return;
        }
        if (this.isNotInGroup()) {
            this.log.debug("Ignoring heartbeat response received from broker. Member {} is in {} state so it's not a member of the group. ", (Object)this.memberId, (Object)state);
            return;
        }
        if (responseData.memberEpoch() < 0) {
            this.log.debug("Ignoring heartbeat response received from broker. Member {} with epoch {} is in {} state and the member epoch is invalid: {}. ", new Object[]{this.memberId, this.memberEpoch, state, responseData.memberEpoch()});
            this.maybeCompleteLeaveInProgress();
            return;
        }
        this.updateMemberEpoch(responseData.memberEpoch());
        ConsumerGroupHeartbeatResponseData.Assignment assignment = responseData.assignment();
        if (assignment != null) {
            if (!state.canHandleNewAssignment()) {
                this.log.debug("Ignoring new assignment {} received from server because member is in {} state.", (Object)assignment, (Object)state);
                return;
            }
            HashMap<Uuid, SortedSet<Integer>> newAssignment = new HashMap<Uuid, SortedSet<Integer>>();
            assignment.topicPartitions().forEach(topicPartition -> newAssignment.put(topicPartition.topicId(), new TreeSet<Integer>(topicPartition.partitions())));
            this.processAssignmentReceived(newAssignment);
        }
    }

    @Override
    protected CompletableFuture<Void> signalReconciliationStarted() {
        return this.commitRequestManager.maybeAutoCommitSyncBeforeRebalance(this.getDeadlineMsForTimeout(this.rebalanceTimeoutMs));
    }

    @Override
    protected void signalReconciliationCompleting() {
        this.commitRequestManager.resetAutoCommitTimer();
    }

    @Override
    protected CompletableFuture<Void> signalMemberLeavingGroup() {
        return this.invokeOnPartitionsRevokedOrLostToReleaseAssignment();
    }

    @Override
    protected CompletableFuture<Void> signalPartitionsLost(Set<TopicPartition> partitionsLost) {
        return this.invokeOnPartitionsLostCallback(partitionsLost);
    }

    private CompletableFuture<Void> invokeOnPartitionsRevokedOrLostToReleaseAssignment() {
        TreeSet<TopicPartition> droppedPartitions = new TreeSet<TopicPartition>(TOPIC_PARTITION_COMPARATOR);
        droppedPartitions.addAll(this.subscriptions.assignedPartitions());
        this.log.info("Member {} is triggering callbacks to release assignment {} and leave group", (Object)this.memberId, droppedPartitions);
        CompletableFuture<Object> callbackResult = droppedPartitions.isEmpty() ? CompletableFuture.completedFuture(null) : (this.memberEpoch > 0 ? this.revokePartitions(droppedPartitions) : this.invokeOnPartitionsLostCallback(droppedPartitions));
        return callbackResult;
    }

    public Optional<String> serverAssignor() {
        return this.serverAssignor;
    }

    private CompletableFuture<Void> invokeOnPartitionsRevokedCallback(Set<TopicPartition> partitionsRevoked) {
        Optional<ConsumerRebalanceListener> listener = this.subscriptions.rebalanceListener();
        if (!partitionsRevoked.isEmpty() && listener.isPresent()) {
            return this.enqueueConsumerRebalanceListenerCallback(ConsumerRebalanceListenerMethodName.ON_PARTITIONS_REVOKED, partitionsRevoked);
        }
        return CompletableFuture.completedFuture(null);
    }

    private CompletableFuture<Void> invokeOnPartitionsAssignedCallback(Set<TopicPartition> partitionsAssigned) {
        Optional<ConsumerRebalanceListener> listener = this.subscriptions.rebalanceListener();
        if (listener.isPresent()) {
            return this.enqueueConsumerRebalanceListenerCallback(ConsumerRebalanceListenerMethodName.ON_PARTITIONS_ASSIGNED, partitionsAssigned);
        }
        return CompletableFuture.completedFuture(null);
    }

    private CompletableFuture<Void> invokeOnPartitionsLostCallback(Set<TopicPartition> partitionsLost) {
        Optional<ConsumerRebalanceListener> listener = this.subscriptions.rebalanceListener();
        if (!partitionsLost.isEmpty() && listener.isPresent()) {
            return this.enqueueConsumerRebalanceListenerCallback(ConsumerRebalanceListenerMethodName.ON_PARTITIONS_LOST, partitionsLost);
        }
        return CompletableFuture.completedFuture(null);
    }

    @Override
    public CompletableFuture<Void> signalPartitionsAssigned(Set<TopicPartition> partitionsAssigned) {
        return this.invokeOnPartitionsAssignedCallback(partitionsAssigned);
    }

    @Override
    public void signalPartitionsBeingRevoked(Set<TopicPartition> partitionsToRevoke) {
        this.logPausedPartitionsBeingRevoked(partitionsToRevoke);
    }

    @Override
    public CompletableFuture<Void> signalPartitionsRevoked(Set<TopicPartition> partitionsRevoked) {
        return this.invokeOnPartitionsRevokedCallback(partitionsRevoked);
    }

    private void logPausedPartitionsBeingRevoked(Set<TopicPartition> partitionsToRevoke) {
        Set<TopicPartition> revokePausedPartitions = this.subscriptions.pausedPartitions();
        revokePausedPartitions.retainAll(partitionsToRevoke);
        if (!revokePausedPartitions.isEmpty()) {
            this.log.info("The pause flag in partitions {} will be removed due to revocation.", revokePausedPartitions);
        }
    }

    @Override
    public boolean isLeavingGroup() {
        CloseOptions.GroupMembershipOperation leaveGroupOperation = this.leaveGroupOperation();
        if (CloseOptions.GroupMembershipOperation.REMAIN_IN_GROUP == leaveGroupOperation) {
            return false;
        }
        MemberState state = this.state();
        boolean isLeavingState = state == MemberState.PREPARE_LEAVING || state == MemberState.LEAVING;
        boolean hasLeaveOperation = CloseOptions.GroupMembershipOperation.DEFAULT == leaveGroupOperation || CloseOptions.GroupMembershipOperation.LEAVE_GROUP == leaveGroupOperation || this.groupInstanceId().isPresent();
        return isLeavingState && hasLeaveOperation;
    }

    private CompletableFuture<Void> enqueueConsumerRebalanceListenerCallback(ConsumerRebalanceListenerMethodName methodName, Set<TopicPartition> partitions) {
        TreeSet<TopicPartition> sortedPartitions = new TreeSet<TopicPartition>(TOPIC_PARTITION_COMPARATOR);
        sortedPartitions.addAll(partitions);
        ConsumerRebalanceListenerCallbackNeededEvent event = new ConsumerRebalanceListenerCallbackNeededEvent(methodName, sortedPartitions);
        this.backgroundEventHandler.add(event);
        this.log.debug("The event to trigger the {} method execution was enqueued successfully", (Object)methodName.fullyQualifiedMethodName());
        return event.future();
    }

    public void consumerRebalanceListenerCallbackCompleted(ConsumerRebalanceListenerCallbackCompletedEvent event) {
        ConsumerRebalanceListenerMethodName methodName = event.methodName();
        Optional<KafkaException> error = event.error();
        CompletableFuture<Void> future = event.future();
        if (error.isPresent()) {
            Exception e = error.get();
            this.log.warn("The {} method completed with an error ({}); signaling to continue to the next phase of rebalance", (Object)methodName.fullyQualifiedMethodName(), (Object)e.getMessage());
            future.completeExceptionally(e);
        } else {
            this.log.debug("The {} method completed successfully; signaling to continue to the next phase of rebalance", (Object)methodName.fullyQualifiedMethodName());
            future.complete(null);
        }
    }

    @Override
    public int joinGroupEpoch() {
        return 0;
    }

    @Override
    public int leaveGroupEpoch() {
        boolean isStaticMember = this.groupInstanceId.isPresent();
        if (CloseOptions.GroupMembershipOperation.LEAVE_GROUP == this.leaveGroupOperation) {
            return -1;
        }
        return isStaticMember ? -2 : -1;
    }
}

