/*
 * Decompiled with CFR 0.152.
 */
package org.apache.storm.dependency;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import org.apache.storm.blobstore.AtomicOutputStream;
import org.apache.storm.blobstore.ClientBlobStore;
import org.apache.storm.dependency.DependencyBlobStoreUtils;
import org.apache.storm.dependency.FileNotAvailableException;
import org.apache.storm.generated.AccessControl;
import org.apache.storm.generated.AccessControlType;
import org.apache.storm.generated.AuthorizationException;
import org.apache.storm.generated.KeyAlreadyExistsException;
import org.apache.storm.generated.KeyNotFoundException;
import org.apache.storm.generated.SettableBlobMeta;
import org.apache.storm.shade.com.google.common.annotations.VisibleForTesting;
import org.apache.storm.shade.org.apache.commons.io.IOUtils;
import org.apache.storm.utils.ObjectReader;
import org.apache.storm.utils.Utils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DependencyUploader {
    public static final Logger LOG = LoggerFactory.getLogger(DependencyUploader.class);
    private final Map<String, Object> conf = Utils.readStormConfig();
    private ClientBlobStore blobStore;
    private final int uploadChunkSize = ObjectReader.getInt(this.conf.get("storm.blobstore.dependency.jar.upload.chunk.size.bytes"), 0x100000);

    public void init() {
    }

    public void shutdown() {
        if (this.blobStore != null) {
            this.blobStore.shutdown();
        }
    }

    private synchronized ClientBlobStore getBlobStore() {
        if (this.blobStore == null) {
            this.blobStore = Utils.getClientBlobStore(this.conf);
        }
        return this.blobStore;
    }

    @VisibleForTesting
    void setBlobStore(ClientBlobStore blobStore) {
        this.blobStore = blobStore;
    }

    public List<String> uploadFiles(List<File> dependencies, boolean cleanupIfFails) throws IOException, AuthorizationException {
        this.checkFilesExist(dependencies);
        ArrayList<String> keys = new ArrayList<String>(dependencies.size());
        try {
            for (File dependency : dependencies) {
                String fileName = dependency.getName();
                String key = DependencyBlobStoreUtils.generateDependencyBlobKey(DependencyBlobStoreUtils.applyUUIDToFileName(fileName));
                try {
                    this.uploadDependencyToBlobStore(key, dependency);
                }
                catch (KeyAlreadyExistsException e) {
                    throw new RuntimeException((Throwable)((Object)e));
                }
                keys.add(key);
            }
        }
        catch (Throwable e) {
            if (this.getBlobStore() != null && cleanupIfFails) {
                this.deleteBlobs(keys);
            }
            throw new RuntimeException(e);
        }
        return keys;
    }

    public List<String> uploadArtifacts(Map<String, File> artifacts) {
        this.checkFilesExist(artifacts.values());
        ArrayList<String> keys = new ArrayList<String>(artifacts.size());
        try {
            for (Map.Entry<String, File> artifactToFile : artifacts.entrySet()) {
                String artifact = artifactToFile.getKey();
                File dependency = artifactToFile.getValue();
                String key = DependencyBlobStoreUtils.generateDependencyBlobKey(this.convertArtifactToJarFileName(artifact));
                try {
                    this.uploadDependencyToBlobStore(key, dependency);
                }
                catch (KeyAlreadyExistsException keyAlreadyExistsException) {
                    // empty catch block
                }
                keys.add(key);
            }
        }
        catch (Throwable e) {
            throw new RuntimeException(e);
        }
        return keys;
    }

    public void deleteBlobs(List<String> keys) {
        for (String key : keys) {
            try {
                this.getBlobStore().deleteBlob(key);
            }
            catch (Throwable e) {
                LOG.warn("blob delete failed - key: {} continue...", (Object)key);
            }
        }
    }

    private String convertArtifactToJarFileName(String artifact) {
        return artifact.replace(":", "-") + ".jar";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean uploadDependencyToBlobStore(String key, File dependency) throws KeyAlreadyExistsException, AuthorizationException, IOException {
        boolean uploadNew = false;
        try {
            this.getBlobStore().getBlobMeta(key);
        }
        catch (KeyNotFoundException e) {
            ArrayList<AccessControl> acls = new ArrayList<AccessControl>();
            acls.add(new AccessControl(AccessControlType.USER, 7));
            acls.add(new AccessControl(AccessControlType.OTHER, 1));
            AtomicOutputStream blob = null;
            try {
                blob = this.getBlobStore().createBlob(key, new SettableBlobMeta(acls));
                try (InputStream in = Files.newInputStream(dependency.toPath(), new OpenOption[0]);){
                    IOUtils.copy((InputStream)in, (OutputStream)blob, (int)this.uploadChunkSize);
                }
                blob.close();
                blob = null;
                uploadNew = true;
            }
            finally {
                try {
                    if (blob != null) {
                        blob.cancel();
                    }
                }
                catch (IOException iOException) {}
            }
        }
        return uploadNew;
    }

    private void checkFilesExist(Collection<File> dependencies) {
        for (File dependency : dependencies) {
            if (dependency.isFile() && dependency.exists()) continue;
            throw new FileNotAvailableException(dependency.getAbsolutePath());
        }
    }
}

