/*
 * Decompiled with CFR 0.152.
 */
package org.apache.storm.shade.org.apache.commons.collections4.iterators;

import java.util.Collections;
import java.util.Iterator;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.stream.Stream;
import org.apache.storm.shade.org.apache.commons.collections4.IteratorUtils;
import org.apache.storm.shade.org.apache.commons.collections4.iterators.FilterIterator;
import org.apache.storm.shade.org.apache.commons.collections4.iterators.IteratorChain;
import org.apache.storm.shade.org.apache.commons.collections4.iterators.IteratorOperations;
import org.apache.storm.shade.org.apache.commons.collections4.iterators.TransformIterator;

public final class ExtendedIterator<T>
implements IteratorOperations<T> {
    private final boolean throwOnRemove;
    private final Iterator<? extends T> base;

    public static <T> ExtendedIterator<T> create(Iterator<T> it) {
        return it instanceof ExtendedIterator ? (ExtendedIterator<T>)it : new ExtendedIterator<T>(it, false);
    }

    public static <T> ExtendedIterator<T> create(Stream<T> stream) {
        return new ExtendedIterator(stream.iterator(), true);
    }

    public static <T> ExtendedIterator<T> createNoRemove(Iterator<T> it) {
        return new ExtendedIterator<T>(it, true);
    }

    public static ExtendedIterator<?> emptyIterator() {
        return new ExtendedIterator(Collections.emptyIterator(), false);
    }

    public static <T> ExtendedIterator<T> flatten(Iterator<Iterator<T>> iterators) {
        return ExtendedIterator.create(IteratorUtils.chainedIterator(iterators));
    }

    private ExtendedIterator(Iterator<? extends T> base, boolean throwOnRemove) {
        this.base = base;
        this.throwOnRemove = throwOnRemove;
    }

    public <X extends T> ExtendedIterator<T> andThen(Iterator<X> other) {
        if (this.base instanceof IteratorChain) {
            ((IteratorChain)this.base).addIterator(other);
            return this;
        }
        return new ExtendedIterator<T>(new IteratorChain<T>(this.base, other), this.throwOnRemove);
    }

    public ExtendedIterator<T> filter(Predicate<T> predicate) {
        return new ExtendedIterator<Object>(new FilterIterator<Object>(this, predicate::test), this.throwOnRemove);
    }

    @Override
    public void forEachRemaining(Consumer<? super T> action) {
        this.base.forEachRemaining(action);
    }

    @Override
    public boolean hasNext() {
        return this.base.hasNext();
    }

    public <U> ExtendedIterator<U> map(Function<T, U> function) {
        return new ExtendedIterator<T>(new TransformIterator<Object, Object>(this, function::apply), false);
    }

    @Override
    public T next() {
        return this.base.next();
    }

    @Override
    public void remove() {
        if (this.throwOnRemove) {
            throw new UnsupportedOperationException();
        }
        this.base.remove();
    }
}

