/*
 * Decompiled with CFR 0.152.
 */
package io.dropwizard.jersey.errors;

import jakarta.ws.rs.core.Response;
import jakarta.ws.rs.ext.ExceptionMapper;
import jakarta.ws.rs.ext.Provider;
import org.eclipse.jetty.io.EofException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Provider
public class EarlyEofExceptionMapper
implements ExceptionMapper<EofException> {
    private static final Logger LOGGER = LoggerFactory.getLogger(EarlyEofExceptionMapper.class);

    public Response toResponse(EofException e) {
        LOGGER.debug("EOF Exception encountered - client disconnected during stream processing.", (Throwable)e);
        return Response.status((Response.Status)Response.Status.BAD_REQUEST).build();
    }
}

