/*
 * Decompiled with CFR 0.152.
 */
package org.apache.storm.scheduler.utils;

import java.util.Map;
import java.util.concurrent.atomic.AtomicReference;
import org.apache.storm.utils.ObjectReader;
import org.apache.storm.utils.Time;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SchedulerConfigCache<T> {
    private static final Logger LOG = LoggerFactory.getLogger(SchedulerConfigCache.class);
    private final Reloadable<T> reloader;
    private AtomicReference<T> schedulerConfigAtomicReference = new AtomicReference();
    private long lastUpdateTimestamp = 0L;
    long configCacheExpirationMs;

    public SchedulerConfigCache(Map<String, Object> conf, Reloadable<T> reloader) {
        this.reloader = reloader;
        this.configCacheExpirationMs = (long)ObjectReader.getInt((Object)conf.get("scheduler.config.cache.expiration.secs"), (Integer)60).intValue() * 1000L;
    }

    public void prepare() {
        this.refresh();
    }

    public void refresh() {
        long current = Time.currentTimeMillis();
        if (this.lastUpdateTimestamp <= 0L || current > this.lastUpdateTimestamp + this.configCacheExpirationMs) {
            LOG.debug("refreshing scheduler config since cache is expired");
            T updatedConfig = this.reloader.reload();
            this.schedulerConfigAtomicReference.set(updatedConfig);
            this.lastUpdateTimestamp = current;
        } else {
            LOG.debug("skip refreshing scheduler config since cache is not yet expired;");
        }
    }

    public T get() {
        return this.schedulerConfigAtomicReference.get();
    }

    public static interface Reloadable<T> {
        public T reload();
    }
}

