/*
 * Decompiled with CFR 0.152.
 */
package org.apache.storm.scheduler.resource.normalization;

import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.atomic.AtomicInteger;

public class ResourceMapArrayBridge {
    private final ConcurrentMap<String, Integer> resourceNamesToArrayIndex = new ConcurrentHashMap<String, Integer>();
    private final AtomicInteger counter = new AtomicInteger(0);

    public double[] translateToResourceArray(Map<String, Double> normalizedResources) {
        for (String key : normalizedResources.keySet()) {
            if ("cpu.pcore.percent".equals(key) || "memory.mb".equals(key) || "offheap.memory.mb".equals(key) || "onheap.memory.mb".equals(key)) continue;
            this.resourceNamesToArrayIndex.computeIfAbsent(key, k -> this.counter.getAndIncrement());
        }
        double[] ret = new double[this.counter.get()];
        for (Map.Entry<String, Double> entry : normalizedResources.entrySet()) {
            Integer index = (Integer)this.resourceNamesToArrayIndex.get(entry.getKey());
            if (index == null) continue;
            ret[index.intValue()] = entry.getValue();
        }
        return ret;
    }

    public double[] empty() {
        return new double[this.counter.get()];
    }

    public Map<String, Double> translateFromResourceArray(double[] resources) {
        HashMap<String, Double> ret = new HashMap<String, Double>();
        int length = resources.length;
        for (Map.Entry entry : this.resourceNamesToArrayIndex.entrySet()) {
            int index = (Integer)entry.getValue();
            if (index >= length) continue;
            ret.put((String)entry.getKey(), resources[index]);
        }
        return ret;
    }

    public Map<String, Integer> getResourceNamesToArrayIndex() {
        return Collections.unmodifiableMap(this.resourceNamesToArrayIndex);
    }
}

