/*
 * Decompiled with CFR 0.152.
 */
package org.apache.storm.scheduler.resource;

import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.Map;
import java.util.Set;
import org.apache.storm.scheduler.Cluster;
import org.apache.storm.scheduler.ExecutorDetails;
import org.apache.storm.scheduler.SupervisorDetails;
import org.apache.storm.scheduler.TopologyDetails;
import org.apache.storm.scheduler.WorkerSlot;
import org.apache.storm.scheduler.resource.normalization.NormalizedResourceOffer;
import org.apache.storm.scheduler.resource.normalization.NormalizedResourceRequest;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RasNode
implements Comparable<RasNode> {
    private static final Logger LOG = LoggerFactory.getLogger(RasNode.class);
    private final String nodeId;
    private final Cluster cluster;
    private final Set<WorkerSlot> originallyFreeSlots;
    private Map<String, WorkerSlot> slots = new HashMap<String, WorkerSlot>();
    private Map<String, Map<String, Collection<ExecutorDetails>>> topIdToUsedSlots = new HashMap<String, Map<String, Collection<ExecutorDetails>>>();
    private String hostname;
    private boolean isAlive;
    private SupervisorDetails sup;
    private boolean loggedUnderageUsage = false;

    public RasNode(String nodeId, SupervisorDetails sup, Cluster cluster, Map<String, WorkerSlot> workerIdToWorker, Map<String, Map<String, Collection<ExecutorDetails>>> assignmentMap) {
        this.nodeId = nodeId;
        this.isAlive = sup == null ? false : !cluster.isBlackListed(this.nodeId);
        this.cluster = cluster;
        if (workerIdToWorker != null) {
            this.slots = workerIdToWorker;
        }
        if (assignmentMap != null) {
            this.topIdToUsedSlots = assignmentMap;
        }
        if (this.isAlive && sup != null) {
            this.hostname = sup.getHost();
            this.sup = sup;
        }
        HashSet<String> freeById = new HashSet<String>(this.slots.keySet());
        if (assignmentMap != null) {
            for (Map<String, Collection<ExecutorDetails>> assignment : assignmentMap.values()) {
                freeById.removeAll(assignment.keySet());
            }
        }
        this.originallyFreeSlots = new HashSet<WorkerSlot>();
        for (WorkerSlot slot : this.slots.values()) {
            if (!freeById.contains(slot.getId())) continue;
            this.originallyFreeSlots.add(slot);
        }
    }

    public String getId() {
        return this.nodeId;
    }

    public String getHostname() {
        return this.hostname;
    }

    private Collection<WorkerSlot> workerIdsToWorkers(Collection<String> workerIds) {
        LinkedList<WorkerSlot> ret = new LinkedList<WorkerSlot>();
        for (String workerId : workerIds) {
            ret.add(this.slots.get(workerId));
        }
        return ret;
    }

    public Collection<String> getFreeSlotsId() {
        if (!this.isAlive) {
            return new HashSet<String>();
        }
        HashSet<String> ret = new HashSet<String>(this.slots.keySet());
        ret.removeAll(this.getUsedSlotsId());
        return ret;
    }

    public Collection<WorkerSlot> getSlotsAvailableToScheduleOn() {
        return this.originallyFreeSlots;
    }

    public Collection<WorkerSlot> getFreeSlots() {
        return this.workerIdsToWorkers(this.getFreeSlotsId());
    }

    private Collection<String> getUsedSlotsId() {
        LinkedList<String> ret = new LinkedList<String>();
        for (Map<String, Collection<ExecutorDetails>> entry : this.topIdToUsedSlots.values()) {
            ret.addAll(entry.keySet());
        }
        return ret;
    }

    public Collection<WorkerSlot> getUsedSlots() {
        return this.workerIdsToWorkers(this.getUsedSlotsId());
    }

    public Collection<WorkerSlot> getUsedSlots(String topId) {
        if (this.topIdToUsedSlots.get(topId) != null) {
            return this.workerIdsToWorkers(this.topIdToUsedSlots.get(topId).keySet());
        }
        return Collections.emptySet();
    }

    public boolean isAlive() {
        return this.isAlive;
    }

    public Collection<String> getRunningTopologies() {
        return this.topIdToUsedSlots.keySet();
    }

    public boolean isTotallyFree() {
        return this.getUsedSlots().isEmpty();
    }

    public int totalSlotsFree() {
        return this.getFreeSlots().size();
    }

    public int totalSlotsUsed() {
        return this.getUsedSlots().size();
    }

    public int totalSlotsUsed(String topId) {
        return this.getUsedSlots(topId).size();
    }

    public int totalSlots() {
        return this.slots.size();
    }

    public void freeAllSlots() {
        if (!this.isAlive) {
            LOG.warn("Freeing all slots on a dead node {} ", (Object)this.nodeId);
        }
        this.cluster.freeSlots(this.slots.values());
        this.topIdToUsedSlots.clear();
    }

    public void freeSingleExecutor(ExecutorDetails exec, TopologyDetails topo) {
        Map<String, Collection<ExecutorDetails>> usedSlots = this.topIdToUsedSlots.get(topo.getId());
        if (usedSlots == null) {
            throw new IllegalArgumentException("Topology " + String.valueOf(topo) + " is not assigned");
        }
        WorkerSlot ws = null;
        HashSet<ExecutorDetails> updatedAssignment = new HashSet<ExecutorDetails>();
        for (Map.Entry<String, Collection<ExecutorDetails>> entry : usedSlots.entrySet()) {
            if (!entry.getValue().contains(exec)) continue;
            ws = this.slots.get(entry.getKey());
            updatedAssignment.addAll(entry.getValue());
            updatedAssignment.remove(exec);
            break;
        }
        if (ws == null) {
            throw new IllegalArgumentException("Executor " + String.valueOf(exec) + " is not assinged on this node to " + String.valueOf(topo));
        }
        this.free(ws);
        if (!updatedAssignment.isEmpty()) {
            this.assign(ws, topo, updatedAssignment);
        }
    }

    public void free(WorkerSlot ws) {
        LOG.debug("freeing WorkerSlot {} on node {}", (Object)ws, (Object)this.hostname);
        if (!this.slots.containsKey(ws.getId())) {
            throw new IllegalArgumentException("Tried to free a slot " + String.valueOf(ws) + " that was not part of this node " + this.nodeId);
        }
        TopologyDetails topo = this.findTopologyUsingWorker(ws);
        if (topo == null) {
            throw new IllegalArgumentException("Tried to free a slot " + String.valueOf(ws) + " that was already free!");
        }
        this.cluster.freeSlot(ws);
        this.topIdToUsedSlots.get(topo.getId()).remove(ws.getId());
    }

    private TopologyDetails findTopologyUsingWorker(WorkerSlot ws) {
        for (Map.Entry<String, Map<String, Collection<ExecutorDetails>>> entry : this.topIdToUsedSlots.entrySet()) {
            String topoId = entry.getKey();
            Set<String> workerIds = entry.getValue().keySet();
            for (String workerId : workerIds) {
                if (!ws.getId().equals(workerId)) continue;
                return this.cluster.getTopologies().getById(topoId);
            }
        }
        return null;
    }

    public void assign(WorkerSlot target, TopologyDetails td, Collection<ExecutorDetails> executors) {
        if (!this.isAlive) {
            throw new IllegalStateException("Trying to adding to a dead node " + this.nodeId);
        }
        Collection<WorkerSlot> freeSlots = this.getFreeSlots();
        if (freeSlots.isEmpty()) {
            throw new IllegalStateException("Trying to assign to a full node " + this.nodeId);
        }
        if (executors.size() == 0) {
            LOG.warn("Trying to assign nothing from " + td.getId() + " to " + this.nodeId + " (Ignored)");
        }
        if (target == null) {
            target = this.getFreeSlots().iterator().next();
        }
        if (!freeSlots.contains(target)) {
            throw new IllegalStateException("Trying to assign already used slot " + target.getPort() + " on node " + this.nodeId);
        }
        LOG.debug("target slot: {}", (Object)target);
        this.cluster.assign(target, td.getId(), executors);
        this.topIdToUsedSlots.computeIfAbsent(td.getId(), tid -> new HashMap()).computeIfAbsent(target.getId(), tid -> new LinkedList()).addAll(executors);
    }

    public void assignSingleExecutor(WorkerSlot ws, ExecutorDetails exec, TopologyDetails td) {
        if (!this.isAlive) {
            throw new IllegalStateException("Trying to adding to a dead node " + this.nodeId);
        }
        Collection<WorkerSlot> freeSlots = this.getFreeSlots();
        HashSet<ExecutorDetails> toAssign = new HashSet<ExecutorDetails>();
        toAssign.add(exec);
        if (!freeSlots.contains(ws)) {
            Map<String, Collection<ExecutorDetails>> usedSlots = this.topIdToUsedSlots.get(td.getId());
            if (usedSlots == null) {
                throw new IllegalArgumentException("Slot " + String.valueOf(ws) + " is not availble to schedue " + String.valueOf(exec) + " on");
            }
            Collection<ExecutorDetails> alreadyHere = usedSlots.get(ws.getId());
            if (alreadyHere == null) {
                throw new IllegalArgumentException("Slot " + String.valueOf(ws) + " is not availble to schedue " + String.valueOf(exec) + " on");
            }
            toAssign.addAll(alreadyHere);
            this.free(ws);
        }
        this.assign(ws, td, toAssign);
    }

    public boolean wouldFit(WorkerSlot ws, ExecutorDetails exec, TopologyDetails td) {
        if (!this.nodeId.equals(ws.getNodeId())) {
            throw new AssertionError((Object)("Slot " + String.valueOf(ws) + " is not a part of this node " + this.nodeId));
        }
        if (!this.isAlive || !this.cluster.wouldFit(ws, exec, td, this.getTotalAvailableResources(), td.getTopologyWorkerMaxHeapSize())) {
            return false;
        }
        boolean oneExecutorPerWorker = (Boolean)td.getConf().get("topology.ras.one.executor.per.worker");
        boolean oneComponentPerWorker = (Boolean)td.getConf().get("topology.ras.one.component.per.worker");
        if (oneExecutorPerWorker) {
            return !this.getUsedSlots(td.getId()).contains(ws);
        }
        if (oneComponentPerWorker) {
            Collection<ExecutorDetails> slotExecs;
            HashSet<String> components = new HashSet<String>();
            Map<String, Collection<ExecutorDetails>> topologyExecutors = this.topIdToUsedSlots.get(td.getId());
            if (topologyExecutors != null && (slotExecs = topologyExecutors.get(ws.getId())) != null) {
                for (ExecutorDetails slotExec : slotExecs) {
                    components.add(td.getComponentFromExecutor(slotExec));
                }
                components.add(td.getComponentFromExecutor(exec));
            }
            return components.size() <= 1;
        }
        return true;
    }

    public boolean couldEverFit(ExecutorDetails exec, TopologyDetails td) {
        if (!this.isAlive) {
            return false;
        }
        NormalizedResourceOffer avail = this.getTotalAvailableResources();
        NormalizedResourceRequest requestedResources = td.getTotalResources(exec);
        return avail.couldFit(this.cluster.getMinWorkerCpu(), requestedResources);
    }

    public boolean equals(Object other) {
        if (other instanceof RasNode) {
            return this.nodeId.equals(((RasNode)other).nodeId);
        }
        return false;
    }

    public int hashCode() {
        return this.nodeId.hashCode();
    }

    public String toString() {
        return "{Node: " + (this.sup == null ? "null (possibly down)" : this.sup.getHost()) + ", Avail [ Mem: " + this.getAvailableMemoryResources() + ", CPU: " + this.getAvailableCpuResources() + ", Slots: " + String.valueOf(this.getFreeSlots()) + "] Total [ Mem: " + String.valueOf(this.sup == null ? "N/A" : Double.valueOf(this.getTotalMemoryResources())) + ", CPU: " + String.valueOf(this.sup == null ? "N/A" : Double.valueOf(this.getTotalCpuResources())) + ", Slots: " + String.valueOf(this.slots.values()) + " ]}";
    }

    public double getAvailableMemoryResources() {
        return this.getTotalAvailableResources().getTotalMemoryMb();
    }

    public NormalizedResourceOffer getTotalResources() {
        if (this.sup != null) {
            return this.sup.getTotalResources();
        }
        return new NormalizedResourceOffer();
    }

    public NormalizedResourceOffer getTotalAvailableResources() {
        if (this.sup != null) {
            NormalizedResourceOffer availableResources = new NormalizedResourceOffer(this.sup.getTotalResources());
            if (availableResources.remove(this.cluster.getAllScheduledResourcesForNode(this.sup.getId()), this.cluster.getResourceMetrics()) && !this.loggedUnderageUsage) {
                LOG.error("Resources on {} became negative and was clamped to 0 {}.", (Object)this.hostname, (Object)availableResources);
                this.loggedUnderageUsage = true;
            }
            return availableResources;
        }
        return new NormalizedResourceOffer();
    }

    public double getTotalMemoryResources() {
        if (this.sup != null) {
            return this.sup.getTotalMemory();
        }
        return 0.0;
    }

    public double getAvailableCpuResources() {
        return this.getTotalAvailableResources().getTotalCpu();
    }

    public double getTotalCpuResources() {
        if (this.sup != null) {
            return this.sup.getTotalCpu();
        }
        return 0.0;
    }

    @Override
    public int compareTo(RasNode o) {
        return this.nodeId.compareTo(o.nodeId);
    }
}

