/*
 * Decompiled with CFR 0.152.
 */
package org.apache.storm.utils;

import java.io.Serializable;
import java.util.LinkedList;
import java.util.List;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.locks.Condition;
import java.util.concurrent.locks.ReentrantLock;
import org.apache.storm.multilang.BoltMsg;

public class ShellBoltMessageQueue
implements Serializable {
    private final LinkedList<List<Integer>> taskIdsQueue = new LinkedList();
    private final LinkedBlockingQueue<BoltMsg> boltMsgQueue;
    private final ReentrantLock takeLock = new ReentrantLock();
    private final Condition notEmpty = this.takeLock.newCondition();

    public ShellBoltMessageQueue(int boltMsgCapacity) {
        if (boltMsgCapacity <= 0) {
            throw new IllegalArgumentException();
        }
        this.boltMsgQueue = new LinkedBlockingQueue(boltMsgCapacity);
    }

    public ShellBoltMessageQueue() {
        this(Integer.MAX_VALUE);
    }

    public void putTaskIds(List<Integer> taskIds) {
        this.takeLock.lock();
        try {
            this.taskIdsQueue.add(taskIds);
            this.notEmpty.signal();
        }
        finally {
            this.takeLock.unlock();
        }
    }

    public void putBoltMsg(BoltMsg boltMsg) throws InterruptedException {
        this.boltMsgQueue.put(boltMsg);
        this.takeLock.lock();
        try {
            this.notEmpty.signal();
        }
        finally {
            this.takeLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object poll(long timeout, TimeUnit unit) throws InterruptedException {
        this.takeLock.lockInterruptibly();
        long nanos = unit.toNanos(timeout);
        try {
            while (this.taskIdsQueue.peek() == null && this.boltMsgQueue.peek() == null) {
                if (nanos <= 0L) {
                    Object var6_4 = null;
                    return var6_4;
                }
                nanos = this.notEmpty.awaitNanos(nanos);
            }
            List<Integer> taskIds = this.taskIdsQueue.peek();
            if (taskIds != null) {
                List<Integer> list = taskIds = this.taskIdsQueue.poll();
                return list;
            }
            BoltMsg boltMsg = this.boltMsgQueue.poll();
            return boltMsg;
        }
        finally {
            this.takeLock.unlock();
        }
    }
}

