/*
 * Decompiled with CFR 0.152.
 */
package org.apache.storm.trident.windowing;

import java.util.List;
import org.apache.storm.coordination.BatchOutputCollector;
import org.apache.storm.trident.operation.Aggregator;
import org.apache.storm.trident.spout.IBatchID;
import org.apache.storm.trident.tuple.TridentTuple;
import org.apache.storm.trident.windowing.AbstractTridentWindowManager;
import org.apache.storm.trident.windowing.WindowsStore;
import org.apache.storm.trident.windowing.config.WindowConfig;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class InMemoryTridentWindowManager
extends AbstractTridentWindowManager<TridentTuple> {
    private static final Logger LOG = LoggerFactory.getLogger(InMemoryTridentWindowManager.class);

    public InMemoryTridentWindowManager(WindowConfig windowConfig, String windowTaskId, WindowsStore windowStore, Aggregator aggregator, BatchOutputCollector delegateCollector) {
        super(windowConfig, windowTaskId, windowStore, aggregator, delegateCollector);
    }

    @Override
    protected void initialize() {
        LOG.debug("noop in initialize");
    }

    @Override
    public List<TridentTuple> getTridentTuples(List<TridentTuple> tridentBatchTuples) {
        return tridentBatchTuples;
    }

    @Override
    public void onTuplesExpired(List<TridentTuple> expiredTuples) {
        LOG.debug("InMemoryTridentWindowManager.onTuplesExpired");
    }

    @Override
    public void addTuplesBatch(Object batchId, List<TridentTuple> tuples) {
        LOG.debug("Adding tuples to window-manager for batch: [{}]", batchId);
        for (TridentTuple tridentTuple : tuples) {
            this.windowManager.add(tridentTuple);
        }
    }

    public String getBatchTxnId(Object batchId) {
        if (!(batchId instanceof IBatchID)) {
            throw new IllegalArgumentException("argument should be an IBatchId instance");
        }
        return ((IBatchID)batchId).getId().toString();
    }
}

