/*
 * Decompiled with CFR 0.152.
 */
package org.apache.storm.streams.processors;

import java.util.HashMap;
import java.util.Map;
import org.apache.storm.streams.Pair;
import org.apache.storm.streams.operations.Reducer;
import org.apache.storm.streams.processors.BaseProcessor;
import org.apache.storm.streams.processors.BatchProcessor;

public class ReduceByKeyProcessor<K, V>
extends BaseProcessor<Pair<K, V>>
implements BatchProcessor {
    private final Reducer<V> reducer;
    private final Map<K, V> state = new HashMap();

    public ReduceByKeyProcessor(Reducer<V> reducer) {
        this.reducer = reducer;
    }

    @Override
    public void execute(Pair<K, V> input) {
        Object key = input.getFirst();
        Object val = input.getSecond();
        V agg = this.state.get(key);
        Object res = agg == null ? val : this.reducer.apply(agg, val);
        this.state.put(key, res);
        this.mayBeForwardAggUpdate(() -> Pair.of(key, res));
    }

    @Override
    public void finish() {
        for (Map.Entry<K, V> entry : this.state.entrySet()) {
            this.context.forward(Pair.of(entry.getKey(), entry.getValue()));
        }
        this.state.clear();
    }
}

