/*
 * Decompiled with CFR 0.152.
 */
package org.apache.storm.blobstore;

import java.io.IOException;
import java.util.Iterator;
import java.util.Map;
import org.apache.storm.blobstore.AtomicOutputStream;
import org.apache.storm.blobstore.BlobStoreAclHandler;
import org.apache.storm.blobstore.InputStreamWithMeta;
import org.apache.storm.daemon.Shutdownable;
import org.apache.storm.generated.AuthorizationException;
import org.apache.storm.generated.KeyAlreadyExistsException;
import org.apache.storm.generated.KeyNotFoundException;
import org.apache.storm.generated.ReadableBlobMeta;
import org.apache.storm.generated.SettableBlobMeta;
import org.apache.storm.utils.ConfigUtils;
import org.apache.storm.utils.NimbusClient;
import org.apache.storm.utils.Utils;

public abstract class ClientBlobStore
implements Shutdownable,
AutoCloseable {
    public static void withConfiguredClient(WithBlobstore withBlobstore) throws Exception {
        Map<String, Object> conf = ConfigUtils.readStormConfig();
        try (ClientBlobStore blobStore = Utils.getClientBlobStore(conf);){
            withBlobstore.run(blobStore);
        }
    }

    public abstract void prepare(Map<String, Object> var1);

    protected abstract AtomicOutputStream createBlobToExtend(String var1, SettableBlobMeta var2) throws AuthorizationException, KeyAlreadyExistsException;

    public abstract AtomicOutputStream updateBlob(String var1) throws AuthorizationException, KeyNotFoundException;

    public abstract ReadableBlobMeta getBlobMeta(String var1) throws AuthorizationException, KeyNotFoundException;

    public abstract boolean isRemoteBlobExists(String var1) throws AuthorizationException;

    protected abstract void setBlobMetaToExtend(String var1, SettableBlobMeta var2) throws AuthorizationException, KeyNotFoundException;

    public abstract void deleteBlob(String var1) throws AuthorizationException, KeyNotFoundException;

    public abstract InputStreamWithMeta getBlob(String var1) throws AuthorizationException, KeyNotFoundException;

    public abstract Iterator<String> listKeys();

    public abstract int getBlobReplication(String var1) throws AuthorizationException, KeyNotFoundException;

    public abstract int updateBlobReplication(String var1, int var2) throws AuthorizationException, KeyNotFoundException;

    public abstract boolean setClient(Map<String, Object> var1, NimbusClient var2);

    public abstract void createStateInZookeeper(String var1);

    @Override
    public abstract void close();

    public final AtomicOutputStream createBlob(String key, SettableBlobMeta meta) throws AuthorizationException, KeyAlreadyExistsException {
        if (meta != null && meta.is_set_acl()) {
            BlobStoreAclHandler.validateSettableACLs(key, meta.get_acl());
        }
        return this.createBlobToExtend(key, meta);
    }

    public final void setBlobMeta(String key, SettableBlobMeta meta) throws AuthorizationException, KeyNotFoundException {
        if (meta != null && meta.is_set_acl()) {
            BlobStoreAclHandler.validateSettableACLs(key, meta.get_acl());
        }
        this.setBlobMetaToExtend(key, meta);
    }

    public abstract long getRemoteBlobstoreUpdateTime() throws IOException;

    public static interface WithBlobstore {
        public void run(ClientBlobStore var1) throws Exception;
    }
}

