/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.shaded.common.requests;

import java.nio.ByteBuffer;
import java.util.Collections;
import org.apache.kafka.shaded.common.protocol.ApiKeys;
import org.apache.kafka.shaded.common.protocol.Errors;
import org.apache.kafka.shaded.common.protocol.ProtoUtils;
import org.apache.kafka.shaded.common.protocol.types.Schema;
import org.apache.kafka.shaded.common.protocol.types.Struct;
import org.apache.kafka.shaded.common.requests.AbstractRequest;
import org.apache.kafka.shaded.common.requests.AbstractRequestResponse;
import org.apache.kafka.shaded.common.requests.ApiVersionsResponse;

public class ApiVersionsRequest
extends AbstractRequest {
    private static final Schema CURRENT_SCHEMA = ProtoUtils.currentRequestSchema(ApiKeys.API_VERSIONS.id);

    public ApiVersionsRequest() {
        super(new Struct(CURRENT_SCHEMA));
    }

    public ApiVersionsRequest(Struct struct) {
        super(struct);
    }

    @Override
    public AbstractRequestResponse getErrorResponse(int versionId, Throwable e) {
        switch (versionId) {
            case 0: {
                short errorCode = Errors.forException(e).code();
                return new ApiVersionsResponse(errorCode, Collections.emptyList());
            }
        }
        throw new IllegalArgumentException(String.format("Version %d is not valid. Valid versions for %s are 0 to %d", versionId, this.getClass().getSimpleName(), ProtoUtils.latestVersion(ApiKeys.API_VERSIONS.id)));
    }

    public static ApiVersionsRequest parse(ByteBuffer buffer, int versionId) {
        return new ApiVersionsRequest(ProtoUtils.parseRequest(ApiKeys.API_VERSIONS.id, versionId, buffer));
    }

    public static ApiVersionsRequest parse(ByteBuffer buffer) {
        return new ApiVersionsRequest(CURRENT_SCHEMA.read(buffer));
    }
}

