/*
 * Decompiled with CFR 0.152.
 */
package kafka.shaded.tools;

import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.regex.Pattern;
import java.util.regex.PatternSyntaxException;
import joptsimple.ArgumentAcceptingOptionSpec;
import joptsimple.OptionParser;
import joptsimple.OptionSet;
import joptsimple.OptionSpec;
import kafka.shaded.api.PartitionMetadata;
import kafka.shaded.api.TopicMetadata;
import kafka.shaded.api.TopicMetadataResponse;
import kafka.shaded.client.ClientUtils$;
import kafka.shaded.cluster.Broker;
import kafka.shaded.common.TopicAndPartition;
import kafka.shaded.consumer.ConsumerConfig$;
import kafka.shaded.consumer.Whitelist;
import kafka.shaded.tools.ReplicaBuffer;
import kafka.shaded.tools.ReplicaFetcher;
import kafka.shaded.tools.ReplicaVerificationTool$$anonfun$3$;
import kafka.shaded.tools.TopicPartitionReplica;
import kafka.shaded.utils.CommandLineUtils$;
import kafka.shaded.utils.Log4jController$;
import kafka.shaded.utils.Logging;
import kafka.shaded.utils.Logging$class;
import kafka.shaded.utils.SystemTime$;
import kafka.shaded.utils.ToolsUtils$;
import org.apache.log4j.Logger;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.Predef$;
import scala.Predef$ArrowAssoc$;
import scala.Serializable;
import scala.Tuple2;
import scala.collection.Iterable;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.Set;
import scala.collection.TraversableLike;
import scala.collection.TraversableOnce;
import scala.collection.immutable.Iterable$;
import scala.collection.immutable.Map;
import scala.collection.immutable.Map$;
import scala.collection.immutable.Nil$;
import scala.collection.mutable.StringBuilder;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;

/*
 * Duplicate member names - consider using --renamedupmembers true
 */
public final class ReplicaVerificationTool$
implements Logging {
    public static final ReplicaVerificationTool$ MODULE$;
    private final String clientId;
    private final String dateFormatString;
    private final SimpleDateFormat dateFormat;
    private final String loggerName;
    private final Logger logger;
    private String logIdent;
    private final Log4jController$ kafka$utils$Logging$$log4jController;
    private volatile boolean bitmap$0;

    static {
        new ReplicaVerificationTool$();
    }

    @Override
    public String loggerName() {
        return this.loggerName;
    }

    private Logger logger$lzycompute() {
        ReplicaVerificationTool$ replicaVerificationTool$ = this;
        synchronized (replicaVerificationTool$) {
            if (!this.bitmap$0) {
                this.logger = Logging$class.logger(this);
                this.bitmap$0 = true;
            }
            return this.logger;
        }
    }

    @Override
    public Logger logger() {
        return this.bitmap$0 ? this.logger : this.logger$lzycompute();
    }

    @Override
    public String logIdent() {
        return this.logIdent;
    }

    @Override
    public void logIdent_$eq(String x$1) {
        this.logIdent = x$1;
    }

    @Override
    public Log4jController$ kafka$utils$Logging$$log4jController() {
        return this.kafka$utils$Logging$$log4jController;
    }

    @Override
    public void kafka$utils$Logging$_setter_$loggerName_$eq(String x$1) {
        this.loggerName = x$1;
    }

    @Override
    public void kafka$utils$Logging$_setter_$kafka$utils$Logging$$log4jController_$eq(Log4jController$ x$1) {
        this.kafka$utils$Logging$$log4jController = x$1;
    }

    @Override
    public void trace(Function0<String> msg) {
        Logging$class.trace(this, msg);
    }

    @Override
    public Object trace(Function0<Throwable> e) {
        return Logging$class.trace(this, e);
    }

    @Override
    public void trace(Function0<String> msg, Function0<Throwable> e) {
        Logging$class.trace(this, msg, e);
    }

    @Override
    public void swallowTrace(Function0<BoxedUnit> action) {
        Logging$class.swallowTrace(this, action);
    }

    @Override
    public void debug(Function0<String> msg) {
        Logging$class.debug(this, msg);
    }

    @Override
    public Object debug(Function0<Throwable> e) {
        return Logging$class.debug(this, e);
    }

    @Override
    public void debug(Function0<String> msg, Function0<Throwable> e) {
        Logging$class.debug(this, msg, e);
    }

    @Override
    public void swallowDebug(Function0<BoxedUnit> action) {
        Logging$class.swallowDebug(this, action);
    }

    @Override
    public void info(Function0<String> msg) {
        Logging$class.info(this, msg);
    }

    @Override
    public Object info(Function0<Throwable> e) {
        return Logging$class.info(this, e);
    }

    @Override
    public void info(Function0<String> msg, Function0<Throwable> e) {
        Logging$class.info(this, msg, e);
    }

    @Override
    public void swallowInfo(Function0<BoxedUnit> action) {
        Logging$class.swallowInfo(this, action);
    }

    @Override
    public void warn(Function0<String> msg) {
        Logging$class.warn(this, msg);
    }

    @Override
    public Object warn(Function0<Throwable> e) {
        return Logging$class.warn(this, e);
    }

    @Override
    public void warn(Function0<String> msg, Function0<Throwable> e) {
        Logging$class.warn(this, msg, e);
    }

    @Override
    public void swallowWarn(Function0<BoxedUnit> action) {
        Logging$class.swallowWarn(this, action);
    }

    @Override
    public void swallow(Function0<BoxedUnit> action) {
        Logging$class.swallow(this, action);
    }

    @Override
    public void error(Function0<String> msg) {
        Logging$class.error(this, msg);
    }

    @Override
    public Object error(Function0<Throwable> e) {
        return Logging$class.error(this, e);
    }

    @Override
    public void error(Function0<String> msg, Function0<Throwable> e) {
        Logging$class.error(this, msg, e);
    }

    @Override
    public void swallowError(Function0<BoxedUnit> action) {
        Logging$class.swallowError(this, action);
    }

    @Override
    public void fatal(Function0<String> msg) {
        Logging$class.fatal(this, msg);
    }

    @Override
    public Object fatal(Function0<Throwable> e) {
        return Logging$class.fatal(this, e);
    }

    @Override
    public void fatal(Function0<String> msg, Function0<Throwable> e) {
        Logging$class.fatal(this, msg, e);
    }

    public String clientId() {
        return this.clientId;
    }

    public String dateFormatString() {
        return this.dateFormatString;
    }

    public SimpleDateFormat dateFormat() {
        return this.dateFormat;
    }

    public String getCurrentTimeString() {
        return this.dateFormat().format(new Date(SystemTime$.MODULE$.milliseconds()));
    }

    /*
     * WARNING - void declaration
     */
    public void main(String[] args) {
        OptionParser parser = new OptionParser();
        ArgumentAcceptingOptionSpec<String> brokerListOpt = parser.accepts("broker-list", "REQUIRED: The list of hostname and port of the server to connect to.").withRequiredArg().describedAs("hostname:port,...,hostname:port").ofType(String.class);
        ArgumentAcceptingOptionSpec<Integer> fetchSizeOpt = parser.accepts("fetch-size", "The fetch size of each request.").withRequiredArg().describedAs("bytes").ofType(Integer.class).defaultsTo(Predef$.MODULE$.int2Integer(ConsumerConfig$.MODULE$.FetchSize()), (Integer[])((Object[])new Integer[0]));
        ArgumentAcceptingOptionSpec<Integer> maxWaitMsOpt = parser.accepts("max-wait-ms", "The max amount of time each fetch request waits.").withRequiredArg().describedAs("ms").ofType(Integer.class).defaultsTo(Predef$.MODULE$.int2Integer(1000), (Integer[])((Object[])new Integer[0]));
        ArgumentAcceptingOptionSpec<String> topicWhiteListOpt = parser.accepts("topic-white-list", "White list of topics to verify replica consistency. Defaults to all topics.").withRequiredArg().describedAs("Java regex (String)").ofType(String.class).defaultsTo(".*", (String[])((Object[])new String[0]));
        ArgumentAcceptingOptionSpec<Long> initialOffsetTimeOpt = parser.accepts("time", "Timestamp for getting the initial offsets.").withRequiredArg().describedAs("timestamp/-1(latest)/-2(earliest)").ofType(Long.class).defaultsTo(Predef$.MODULE$.long2Long(-1L), (Long[])((Object[])new Long[0]));
        ArgumentAcceptingOptionSpec<Long> reportIntervalOpt = parser.accepts("report-interval-ms", "The reporting interval.").withRequiredArg().describedAs("ms").ofType(Long.class).defaultsTo(Predef$.MODULE$.long2Long(30000L), (Long[])((Object[])new Long[0]));
        if (args.length == 0) {
            CommandLineUtils$.MODULE$.printUsageAndDie(parser, "Validate that all replicas for a set of topics have the same data.");
        }
        OptionSet options = parser.parse(args);
        CommandLineUtils$.MODULE$.checkRequiredArgs(parser, options, Predef$.MODULE$.wrapRefArray((Object[])new OptionSpec[]{brokerListOpt}));
        String regex = options.valueOf(topicWhiteListOpt);
        Whitelist topicWhiteListFiler = new Whitelist(regex);
        try {
            Pattern.compile(regex);
        }
        catch (PatternSyntaxException patternSyntaxException) {
            void var10_10;
            throw new RuntimeException(new StringBuilder().append(var10_10).append((Object)" is an invalid regex.").toString());
        }
        int fetchSize = options.valueOf(fetchSizeOpt);
        int maxWaitMs = options.valueOf(maxWaitMsOpt);
        long initialOffsetTime = options.valueOf(initialOffsetTimeOpt);
        long reportInterval = options.valueOf(reportIntervalOpt);
        this.info((Function0<String>)((Object)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final String apply() {
                return "Getting topic metatdata...";
            }
        }));
        String brokerList = options.valueOf(brokerListOpt);
        ToolsUtils$.MODULE$.validatePortOrDie(parser, brokerList);
        Seq<Broker> metadataTargetBrokers = ClientUtils$.MODULE$.parseBrokerList(brokerList);
        TopicMetadataResponse topicsMetadataResponse = ClientUtils$.MODULE$.fetchTopicMetadata((Set)Predef$.MODULE$.Set().apply(Nil$.MODULE$), metadataTargetBrokers, this.clientId(), maxWaitMs, ClientUtils$.MODULE$.fetchTopicMetadata$default$5());
        Map<Object, Broker> brokerMap = ((TraversableOnce)topicsMetadataResponse.brokers().map(new Serializable(){
            public static final long serialVersionUID = 0L;

            public final Tuple2<Object, Broker> apply(Broker b) {
                return new Tuple2<Object, Broker>(BoxesRunTime.boxToInteger(b.id()), b);
            }
        }, Seq$.MODULE$.canBuildFrom())).toMap(Predef$.MODULE$.conforms());
        Seq filteredTopicMetadata = (Seq)topicsMetadataResponse.topicsMetadata().filter((Function1<TopicMetadata, Object>)((Object)new Serializable(topicWhiteListFiler){
            public static final long serialVersionUID = 0L;
            private final Whitelist topicWhiteListFiler$1;

            public final boolean apply(TopicMetadata topicMetadata) {
                return this.topicWhiteListFiler$1.isTopicAllowed(topicMetadata.topic(), false);
            }
            {
                this.topicWhiteListFiler$1 = topicWhiteListFiler$1;
            }
        }));
        Seq<TopicPartitionReplica> topicPartitionReplicaList = filteredTopicMetadata.flatMap(new Serializable(){
            public static final long serialVersionUID = 0L;

            public final Seq<TopicPartitionReplica> apply(TopicMetadata topicMetadataResponse) {
                return topicMetadataResponse.partitionsMetadata().flatMap(new Serializable(this, topicMetadataResponse){
                    public static final long serialVersionUID = 0L;
                    public final TopicMetadata topicMetadataResponse$1;

                    public final Seq<TopicPartitionReplica> apply(PartitionMetadata partitionMetadata) {
                        return partitionMetadata.replicas().map(new Serializable(this, partitionMetadata){
                            public static final long serialVersionUID = 0L;
                            private final /* synthetic */ anonfun$3$$anonfun$apply$1 $outer;
                            private final PartitionMetadata partitionMetadata$1;

                            public final TopicPartitionReplica apply(Broker broker) {
                                return new TopicPartitionReplica(this.$outer.topicMetadataResponse$1.topic(), this.partitionMetadata$1.partitionId(), broker.id());
                            }
                            {
                                if ($outer == null) {
                                    throw new NullPointerException();
                                }
                                this.$outer = $outer;
                                this.partitionMetadata$1 = partitionMetadata$1;
                            }
                        }, Seq$.MODULE$.canBuildFrom());
                    }
                    {
                        this.topicMetadataResponse$1 = topicMetadataResponse$1;
                    }
                }, Seq$.MODULE$.canBuildFrom());
            }
        }, Seq$.MODULE$.canBuildFrom());
        this.debug((Function0<String>)((Object)new Serializable(topicPartitionReplicaList){
            public static final long serialVersionUID = 0L;
            private final Seq topicPartitionReplicaList$1;

            public final String apply() {
                return new StringBuilder().append((Object)"Selected topic partitions: ").append(this.topicPartitionReplicaList$1).toString();
            }
            {
                this.topicPartitionReplicaList$1 = topicPartitionReplicaList$1;
            }
        }));
        Map<Tuple2<Object, Seq<TopicAndPartition>>, ReplicaFetcher> topicAndPartitionsPerBroker = topicPartitionReplicaList.groupBy(new Serializable(){
            public static final long serialVersionUID = 0L;

            public final int apply(TopicPartitionReplica x$1) {
                return x$1.replicaId();
            }
        }).map((Function1<Object, Map<?, ?>>)((Object)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final Tuple2<Object, Seq<TopicAndPartition>> apply(Tuple2<Object, Seq<TopicPartitionReplica>> x0$1) {
                Tuple2<Object, Seq<TopicPartitionReplica>> tuple2 = x0$1;
                if (tuple2 != null) {
                    int brokerId = tuple2._1$mcI$sp();
                    Seq<TopicPartitionReplica> partitions = tuple2._2();
                    Tuple2<Object, Seq<TopicAndPartition>> tuple22 = Predef$ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.any2ArrowAssoc(BoxesRunTime.boxToInteger(brokerId)), partitions.map(new Serializable(this){
                        public static final long serialVersionUID = 0L;

                        public final TopicAndPartition apply(TopicPartitionReplica x0$2) {
                            TopicPartitionReplica topicPartitionReplica = x0$2;
                            TopicAndPartition topicAndPartition = new TopicAndPartition(topicPartitionReplica.topic(), topicPartitionReplica.partitionId());
                            return topicAndPartition;
                        }
                    }, Seq$.MODULE$.canBuildFrom()));
                    return tuple22;
                }
                throw new MatchError(tuple2);
            }
        }), Map$.MODULE$.canBuildFrom());
        this.debug((Function0<String>)((Object)new Serializable(topicAndPartitionsPerBroker){
            public static final long serialVersionUID = 0L;
            private final Map topicAndPartitionsPerBroker$1;

            public final String apply() {
                return new StringBuilder().append((Object)"Topic partitions per broker: ").append(this.topicAndPartitionsPerBroker$1).toString();
            }
            {
                this.topicAndPartitionsPerBroker$1 = topicAndPartitionsPerBroker$1;
            }
        }));
        Map<TopicAndPartition, Object> expectedReplicasPerTopicAndPartition = topicPartitionReplicaList.groupBy(new Serializable(){
            public static final long serialVersionUID = 0L;

            public final TopicAndPartition apply(TopicPartitionReplica replica) {
                return new TopicAndPartition(replica.topic(), replica.partitionId());
            }
        }).map((Function1<TopicAndPartition, Map<?, ?>>)((Object)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final Tuple2<TopicAndPartition, Object> apply(Tuple2<TopicAndPartition, Seq<TopicPartitionReplica>> x0$3) {
                Tuple2<TopicAndPartition, Seq<TopicPartitionReplica>> tuple2 = x0$3;
                if (tuple2 != null) {
                    TopicAndPartition topicAndPartition = tuple2._1();
                    Seq<TopicPartitionReplica> replicaSet = tuple2._2();
                    Tuple2<TopicAndPartition, Object> tuple22 = Predef$ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.any2ArrowAssoc(topicAndPartition), BoxesRunTime.boxToInteger(replicaSet.size()));
                    return tuple22;
                }
                throw new MatchError(tuple2);
            }
        }), Map$.MODULE$.canBuildFrom());
        this.debug((Function0<String>)((Object)new Serializable(expectedReplicasPerTopicAndPartition){
            public static final long serialVersionUID = 0L;
            private final Map expectedReplicasPerTopicAndPartition$1;

            public final String apply() {
                return new StringBuilder().append((Object)"Expected replicas per topic partition: ").append(this.expectedReplicasPerTopicAndPartition$1).toString();
            }
            {
                this.expectedReplicasPerTopicAndPartition$1 = expectedReplicasPerTopicAndPartition$1;
            }
        }));
        Map<Object, Seq<TopicAndPartition>> leadersPerBroker = ((TraversableLike)filteredTopicMetadata.flatMap(new Serializable(){
            public static final long serialVersionUID = 0L;

            public final Seq<Tuple2<TopicAndPartition, Object>> apply(TopicMetadata topicMetadataResponse) {
                return topicMetadataResponse.partitionsMetadata().map(new Serializable(this, topicMetadataResponse){
                    public static final long serialVersionUID = 0L;
                    private final TopicMetadata topicMetadataResponse$2;

                    public final Tuple2<TopicAndPartition, Object> apply(PartitionMetadata partitionMetadata) {
                        return new Tuple2<TopicAndPartition, Object>(new TopicAndPartition(this.topicMetadataResponse$2.topic(), partitionMetadata.partitionId()), BoxesRunTime.boxToInteger(partitionMetadata.leader().get().id()));
                    }
                    {
                        this.topicMetadataResponse$2 = topicMetadataResponse$2;
                    }
                }, Seq$.MODULE$.canBuildFrom());
            }
        }, Seq$.MODULE$.canBuildFrom())).groupBy(new Serializable(){
            public static final long serialVersionUID = 0L;

            public final int apply(Tuple2<TopicAndPartition, Object> x$2) {
                return x$2._2$mcI$sp();
            }
        }).mapValues(new Serializable(){
            public static final long serialVersionUID = 0L;

            public final Seq<TopicAndPartition> apply(Seq<Tuple2<TopicAndPartition, Object>> topicAndPartitionAndLeaderIds) {
                return topicAndPartitionAndLeaderIds.map(new Serializable(this){
                    public static final long serialVersionUID = 0L;

                    public final TopicAndPartition apply(Tuple2<TopicAndPartition, Object> x0$4) {
                        Tuple2<TopicAndPartition, Object> tuple2 = x0$4;
                        if (tuple2 != null) {
                            TopicAndPartition topicAndPartition;
                            TopicAndPartition topicAndPartition2 = topicAndPartition = tuple2._1();
                            return topicAndPartition2;
                        }
                        throw new MatchError(tuple2);
                    }
                }, Seq$.MODULE$.canBuildFrom());
            }
        });
        this.debug((Function0<String>)((Object)new Serializable(leadersPerBroker){
            public static final long serialVersionUID = 0L;
            private final Map leadersPerBroker$1;

            public final String apply() {
                return new StringBuilder().append((Object)"Leaders per broker: ").append(this.leadersPerBroker$1).toString();
            }
            {
                this.leadersPerBroker$1 = leadersPerBroker$1;
            }
        }));
        ReplicaBuffer replicaBuffer = new ReplicaBuffer(expectedReplicasPerTopicAndPartition, leadersPerBroker, topicAndPartitionsPerBroker.size(), brokerMap, initialOffsetTime, reportInterval);
        int verificationBrokerId = ((Tuple2)topicAndPartitionsPerBroker.head())._1$mcI$sp();
        Iterable fetcherThreads = topicAndPartitionsPerBroker.map((Function1<Tuple2<Object, Seq<TopicAndPartition>>, ReplicaFetcher>)((Object)new Serializable(fetchSize, maxWaitMs, brokerMap, replicaBuffer, verificationBrokerId){
            public static final long serialVersionUID = 0L;
            private final int fetchSize$1;
            private final int maxWaitMs$1;
            private final Map brokerMap$1;
            private final ReplicaBuffer replicaBuffer$1;
            private final int verificationBrokerId$1;

            public final ReplicaFetcher apply(Tuple2<Object, Seq<TopicAndPartition>> x0$5) {
                Tuple2<Object, Seq<TopicAndPartition>> tuple2 = x0$5;
                if (tuple2 != null) {
                    int brokerId = tuple2._1$mcI$sp();
                    Seq<TopicAndPartition> topicAndPartitions = tuple2._2();
                    ReplicaFetcher replicaFetcher = new ReplicaFetcher(new StringBuilder().append((Object)"ReplicaFetcher-").append(BoxesRunTime.boxToInteger(brokerId)).toString(), (Broker)this.brokerMap$1.apply(BoxesRunTime.boxToInteger(brokerId)), topicAndPartitions, this.replicaBuffer$1, 30000, 256000, this.fetchSize$1, this.maxWaitMs$1, 1, brokerId == this.verificationBrokerId$1);
                    return replicaFetcher;
                }
                throw new MatchError(tuple2);
            }
            {
                this.fetchSize$1 = fetchSize$1;
                this.maxWaitMs$1 = maxWaitMs$1;
                this.brokerMap$1 = brokerMap$1;
                this.replicaBuffer$1 = replicaBuffer$1;
                this.verificationBrokerId$1 = verificationBrokerId$1;
            }
        }), Iterable$.MODULE$.canBuildFrom());
        Runtime.getRuntime().addShutdownHook(new Thread(fetcherThreads){
            private final Iterable fetcherThreads$1;

            public void run() {
                ReplicaVerificationTool$.MODULE$.info((Function0<String>)((Object)new Serializable(this){
                    public static final long serialVersionUID = 0L;

                    public final String apply() {
                        return "Stopping all fetchers";
                    }
                }));
                this.fetcherThreads$1.foreach(new Serializable(this){
                    public static final long serialVersionUID = 0L;

                    public final void apply(ReplicaFetcher x$3) {
                        x$3.shutdown();
                    }
                });
            }
            {
                this.fetcherThreads$1 = fetcherThreads$1;
            }
        });
        fetcherThreads.foreach(new Serializable(){
            public static final long serialVersionUID = 0L;

            public final void apply(ReplicaFetcher x$4) {
                x$4.start();
            }
        });
        Predef$.MODULE$.println(new StringBuilder().append((Object)this.getCurrentTimeString()).append((Object)": verification process is started.").toString());
    }

    private ReplicaVerificationTool$() {
        MODULE$ = this;
        Logging$class.$init$(this);
        this.clientId = "replicaVerificationTool";
        this.dateFormatString = "yyyy-MM-dd HH:mm:ss,SSS";
        this.dateFormat = new SimpleDateFormat(this.dateFormatString());
    }
}

