/*
 * Decompiled with CFR 0.152.
 */
package org.apache.storm.sql.runtime.serde.csv;

import com.google.common.base.Preconditions;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.csv.CSVFormat;
import org.apache.commons.csv.CSVParser;
import org.apache.commons.csv.CSVRecord;
import org.apache.storm.spout.Scheme;
import org.apache.storm.tuple.Fields;
import org.apache.storm.utils.Utils;

public class CsvScheme
implements Scheme {
    private final List<String> fieldNames;

    public CsvScheme(List<String> fieldNames) {
        this.fieldNames = fieldNames;
    }

    public List<Object> deserialize(ByteBuffer ser) {
        try {
            String data = new String(Utils.toByteArray((ByteBuffer)ser), StandardCharsets.UTF_8);
            CSVParser parser = CSVParser.parse((String)data, (CSVFormat)CSVFormat.RFC4180);
            CSVRecord record = (CSVRecord)parser.getRecords().get(0);
            Preconditions.checkArgument((record.size() == this.fieldNames.size() ? 1 : 0) != 0, (Object)"Invalid schema");
            ArrayList<Object> list = new ArrayList<Object>(this.fieldNames.size());
            for (int i = 0; i < record.size(); ++i) {
                list.add(record.get(i));
            }
            return list;
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public Fields getOutputFields() {
        return new Fields(this.fieldNames);
    }
}

