/*
 * Decompiled with CFR 0.152.
 */
package org.apache.storm.sql.runtime.datasource.socket;

import java.net.URI;
import java.util.List;
import java.util.Properties;
import org.apache.storm.spout.Scheme;
import org.apache.storm.sql.runtime.DataSource;
import org.apache.storm.sql.runtime.DataSourcesProvider;
import org.apache.storm.sql.runtime.FieldInfo;
import org.apache.storm.sql.runtime.IOutputSerializer;
import org.apache.storm.sql.runtime.ISqlTridentDataSource;
import org.apache.storm.sql.runtime.SimpleSqlTridentConsumer;
import org.apache.storm.sql.runtime.datasource.socket.trident.SocketState;
import org.apache.storm.sql.runtime.datasource.socket.trident.SocketStateUpdater;
import org.apache.storm.sql.runtime.datasource.socket.trident.TridentSocketSpout;
import org.apache.storm.sql.runtime.utils.FieldInfoUtils;
import org.apache.storm.sql.runtime.utils.SerdeUtils;
import org.apache.storm.trident.spout.ITridentDataSource;
import org.apache.storm.trident.state.StateUpdater;

public class SocketDataSourcesProvider
implements DataSourcesProvider {
    @Override
    public String scheme() {
        return "socket";
    }

    @Override
    public DataSource construct(URI uri, String inputFormatClass, String outputFormatClass, List<FieldInfo> fields) {
        throw new UnsupportedOperationException();
    }

    @Override
    public ISqlTridentDataSource constructTrident(URI uri, String inputFormatClass, String outputFormatClass, Properties properties, List<FieldInfo> fields) {
        String host = uri.getHost();
        int port = uri.getPort();
        if (port == -1) {
            throw new RuntimeException("Port information is not available. URI: " + uri);
        }
        List<String> fieldNames = FieldInfoUtils.getFieldNames(fields);
        Scheme scheme = SerdeUtils.getScheme(inputFormatClass, properties, fieldNames);
        IOutputSerializer serializer = SerdeUtils.getSerializer(outputFormatClass, properties, fieldNames);
        return new SocketTridentDataSource(scheme, serializer, host, port);
    }

    private static class SocketTridentDataSource
    implements ISqlTridentDataSource {
        private final String host;
        private final int port;
        private final Scheme scheme;
        private final IOutputSerializer serializer;

        SocketTridentDataSource(Scheme scheme, IOutputSerializer serializer, String host, int port) {
            this.scheme = scheme;
            this.serializer = serializer;
            this.host = host;
            this.port = port;
        }

        @Override
        public ITridentDataSource getProducer() {
            return new TridentSocketSpout(this.scheme, this.host, this.port);
        }

        @Override
        public ISqlTridentDataSource.SqlTridentConsumer getConsumer() {
            SocketState.Factory stateFactory = new SocketState.Factory(this.host, this.port);
            SocketStateUpdater stateUpdater = new SocketStateUpdater(this.serializer);
            return new SimpleSqlTridentConsumer(stateFactory, (StateUpdater)stateUpdater);
        }
    }
}

