/*
 * Decompiled with CFR 0.152.
 */
package kafka.shaded.network;

import java.nio.ByteBuffer;
import java.nio.channels.ReadableByteChannel;
import kafka.shaded.network.InvalidRequestException;
import kafka.shaded.network.Receive;
import kafka.shaded.network.Receive$class;
import kafka.shaded.network.Transmission$class;
import kafka.shaded.utils.Log4jController$;
import kafka.shaded.utils.Logging$class;
import kafka.shaded.utils.Utils$;
import org.apache.log4j.Logger;
import scala.Function0;
import scala.Predef$;
import scala.Serializable;
import scala.collection.immutable.StringOps;
import scala.collection.mutable.StringBuilder;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;

/*
 * Duplicate member names - consider using --renamedupmembers true
 */
@ScalaSignature(bytes="\u0006\u0001\t4Q!\u0001\u0002\u0001\t\u0019\u0011\u0001DQ8v]\u0012,GMQ=uK\n+hMZ3s%\u0016\u001cW-\u001b<f\u0015\t\u0019A!A\u0004oKR<xN]6\u000b\u0003\u0015\tQa[1gW\u0006\u001cB\u0001A\u0004\u000e#A\u0011\u0001bC\u0007\u0002\u0013)\t!\"A\u0003tG\u0006d\u0017-\u0003\u0002\r\u0013\t1\u0011I\\=SK\u001a\u0004\"AD\b\u000e\u0003\tI!\u0001\u0005\u0002\u0003\u000fI+7-Z5wKB\u0011!#F\u0007\u0002')\u0011A\u0003B\u0001\u0006kRLGn]\u0005\u0003-M\u0011q\u0001T8hO&tw\r\u0003\u0005\u0019\u0001\t\u0015\r\u0011\"\u0001\u001b\u0003\u001di\u0017\r_*ju\u0016\u001c\u0001!F\u0001\u001c!\tAA$\u0003\u0002\u001e\u0013\t\u0019\u0011J\u001c;\t\u0011}\u0001!\u0011!Q\u0001\nm\t\u0001\"\\1y'&TX\r\t\u0005\u0006C\u0001!\tAI\u0001\u0007y%t\u0017\u000e\u001e \u0015\u0005\r\"\u0003C\u0001\b\u0001\u0011\u0015A\u0002\u00051\u0001\u001c\u0011\u001d1\u0003A1A\u0005\n\u001d\n!b]5{K\n+hMZ3s+\u0005A\u0003CA\u0015/\u001b\u0005Q#BA\u0016-\u0003\rq\u0017n\u001c\u0006\u0002[\u0005!!.\u0019<b\u0013\ty#F\u0001\u0006CsR,')\u001e4gKJDa!\r\u0001!\u0002\u0013A\u0013aC:ju\u0016\u0014UO\u001a4fe\u0002Bqa\r\u0001A\u0002\u0013%q%A\u0007d_:$XM\u001c;Ck\u001a4WM\u001d\u0005\bk\u0001\u0001\r\u0011\"\u00037\u0003E\u0019wN\u001c;f]R\u0014UO\u001a4fe~#S-\u001d\u000b\u0003oi\u0002\"\u0001\u0003\u001d\n\u0005eJ!\u0001B+oSRDqa\u000f\u001b\u0002\u0002\u0003\u0007\u0001&A\u0002yIEBa!\u0010\u0001!B\u0013A\u0013AD2p]R,g\u000e\u001e\"vM\u001a,'\u000f\t\u0005\u0006C\u0001!\ta\u0010\u000b\u0002G!9\u0011\t\u0001a\u0001\n\u0003\u0011\u0015\u0001C2p[BdW\r^3\u0016\u0003\r\u0003\"\u0001\u0003#\n\u0005\u0015K!a\u0002\"p_2,\u0017M\u001c\u0005\b\u000f\u0002\u0001\r\u0011\"\u0001I\u00031\u0019w.\u001c9mKR,w\fJ3r)\t9\u0014\nC\u0004<\r\u0006\u0005\t\u0019A\"\t\r-\u0003\u0001\u0015)\u0003D\u0003%\u0019w.\u001c9mKR,\u0007\u0005C\u0003N\u0001\u0011\u0005q%\u0001\u0004ck\u001a4WM\u001d\u0005\u0006\u001f\u0002!\t\u0001U\u0001\te\u0016\fGM\u0012:p[R\u00111$\u0015\u0005\u0006%:\u0003\raU\u0001\bG\"\fgN\\3m!\t!v+D\u0001V\u0015\t1&&\u0001\u0005dQ\u0006tg.\u001a7t\u0013\tAVKA\nSK\u0006$\u0017M\u00197f\u0005f$Xm\u00115b]:,G\u000eC\u0003[\u0001\u0011%1,\u0001\ncsR,')\u001e4gKJ\fE\u000e\\8dCR,GC\u0001\u0015]\u0011\u0015i\u0016\f1\u0001\u001c\u0003\u0011\u0019\u0018N_3)\u0005\u0001y\u0006C\u0001\na\u0013\t\t7CA\u0007o_:$\bN]3bIN\fg-\u001a")
public class BoundedByteBufferReceive
implements Receive {
    private final int maxSize;
    private final ByteBuffer sizeBuffer;
    private ByteBuffer contentBuffer;
    private boolean complete;
    private final String loggerName;
    private final Logger logger;
    private String logIdent;
    private final Log4jController$ kafka$utils$Logging$$log4jController;
    private volatile boolean bitmap$0;

    @Override
    public int readCompletely(ReadableByteChannel channel) {
        return Receive$class.readCompletely(this, channel);
    }

    @Override
    public void expectIncomplete() {
        Transmission$class.expectIncomplete(this);
    }

    @Override
    public void expectComplete() {
        Transmission$class.expectComplete(this);
    }

    @Override
    public String loggerName() {
        return this.loggerName;
    }

    private Logger logger$lzycompute() {
        BoundedByteBufferReceive boundedByteBufferReceive = this;
        synchronized (boundedByteBufferReceive) {
            if (!this.bitmap$0) {
                this.logger = Logging$class.logger(this);
                this.bitmap$0 = true;
            }
            return this.logger;
        }
    }

    @Override
    public Logger logger() {
        return this.bitmap$0 ? this.logger : this.logger$lzycompute();
    }

    @Override
    public String logIdent() {
        return this.logIdent;
    }

    @Override
    public void logIdent_$eq(String x$1) {
        this.logIdent = x$1;
    }

    @Override
    public Log4jController$ kafka$utils$Logging$$log4jController() {
        return this.kafka$utils$Logging$$log4jController;
    }

    @Override
    public void kafka$utils$Logging$_setter_$loggerName_$eq(String x$1) {
        this.loggerName = x$1;
    }

    @Override
    public void kafka$utils$Logging$_setter_$kafka$utils$Logging$$log4jController_$eq(Log4jController$ x$1) {
        this.kafka$utils$Logging$$log4jController = x$1;
    }

    @Override
    public void trace(Function0<String> msg) {
        Logging$class.trace(this, msg);
    }

    @Override
    public Object trace(Function0<Throwable> e) {
        return Logging$class.trace(this, e);
    }

    @Override
    public void trace(Function0<String> msg, Function0<Throwable> e) {
        Logging$class.trace(this, msg, e);
    }

    @Override
    public void swallowTrace(Function0<BoxedUnit> action) {
        Logging$class.swallowTrace(this, action);
    }

    @Override
    public void debug(Function0<String> msg) {
        Logging$class.debug(this, msg);
    }

    @Override
    public Object debug(Function0<Throwable> e) {
        return Logging$class.debug(this, e);
    }

    @Override
    public void debug(Function0<String> msg, Function0<Throwable> e) {
        Logging$class.debug(this, msg, e);
    }

    @Override
    public void swallowDebug(Function0<BoxedUnit> action) {
        Logging$class.swallowDebug(this, action);
    }

    @Override
    public void info(Function0<String> msg) {
        Logging$class.info(this, msg);
    }

    @Override
    public Object info(Function0<Throwable> e) {
        return Logging$class.info(this, e);
    }

    @Override
    public void info(Function0<String> msg, Function0<Throwable> e) {
        Logging$class.info(this, msg, e);
    }

    @Override
    public void swallowInfo(Function0<BoxedUnit> action) {
        Logging$class.swallowInfo(this, action);
    }

    @Override
    public void warn(Function0<String> msg) {
        Logging$class.warn(this, msg);
    }

    @Override
    public Object warn(Function0<Throwable> e) {
        return Logging$class.warn(this, e);
    }

    @Override
    public void warn(Function0<String> msg, Function0<Throwable> e) {
        Logging$class.warn(this, msg, e);
    }

    @Override
    public void swallowWarn(Function0<BoxedUnit> action) {
        Logging$class.swallowWarn(this, action);
    }

    @Override
    public void swallow(Function0<BoxedUnit> action) {
        Logging$class.swallow(this, action);
    }

    @Override
    public void error(Function0<String> msg) {
        Logging$class.error(this, msg);
    }

    @Override
    public Object error(Function0<Throwable> e) {
        return Logging$class.error(this, e);
    }

    @Override
    public void error(Function0<String> msg, Function0<Throwable> e) {
        Logging$class.error(this, msg, e);
    }

    @Override
    public void swallowError(Function0<BoxedUnit> action) {
        Logging$class.swallowError(this, action);
    }

    @Override
    public void fatal(Function0<String> msg) {
        Logging$class.fatal(this, msg);
    }

    @Override
    public Object fatal(Function0<Throwable> e) {
        return Logging$class.fatal(this, e);
    }

    @Override
    public void fatal(Function0<String> msg, Function0<Throwable> e) {
        Logging$class.fatal(this, msg, e);
    }

    public int maxSize() {
        return this.maxSize;
    }

    private ByteBuffer sizeBuffer() {
        return this.sizeBuffer;
    }

    private ByteBuffer contentBuffer() {
        return this.contentBuffer;
    }

    private void contentBuffer_$eq(ByteBuffer x$1) {
        this.contentBuffer = x$1;
    }

    @Override
    public boolean complete() {
        return this.complete;
    }

    public void complete_$eq(boolean x$1) {
        this.complete = x$1;
    }

    @Override
    public ByteBuffer buffer() {
        this.expectComplete();
        return this.contentBuffer();
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public int readFrom(ReadableByteChannel channel) {
        void var2_2;
        this.expectIncomplete();
        int read2 = 0;
        if (this.sizeBuffer().remaining() > 0) {
            read2 += Utils$.MODULE$.read(channel, this.sizeBuffer());
        }
        if (this.contentBuffer() == null && !this.sizeBuffer().hasRemaining()) {
            this.sizeBuffer().rewind();
            int size2 = this.sizeBuffer().getInt();
            if (size2 <= 0) {
                throw new InvalidRequestException(new StringOps(Predef$.MODULE$.augmentString("%d is not a valid request size.")).format(Predef$.MODULE$.genericWrapArray(new Object[]{BoxesRunTime.boxToInteger(size2)})));
            }
            if (size2 > this.maxSize()) {
                throw new InvalidRequestException(new StringOps(Predef$.MODULE$.augmentString("Request of length %d is not valid, it is larger than the maximum size of %d bytes.")).format(Predef$.MODULE$.genericWrapArray(new Object[]{BoxesRunTime.boxToInteger(size2), BoxesRunTime.boxToInteger(this.maxSize())})));
            }
            this.contentBuffer_$eq(this.byteBufferAllocate(size2));
        }
        if (this.contentBuffer() != null) {
            read2 = Utils$.MODULE$.read(channel, this.contentBuffer());
            if (!this.contentBuffer().hasRemaining()) {
                this.contentBuffer().rewind();
                this.complete_$eq(true);
            }
        }
        return (int)var2_2;
    }

    /*
     * WARNING - void declaration
     */
    private ByteBuffer byteBufferAllocate(int size2) {
        ByteBuffer buffer = null;
        try {
            void var2_2;
            buffer = ByteBuffer.allocate(size2);
            return var2_2;
        }
        catch (Throwable throwable) {
            throw throwable;
        }
        catch (OutOfMemoryError outOfMemoryError) {
            this.error((Function0<String>)((Object)new Serializable(this, size2){
                public static final long serialVersionUID = 0L;
                private final int size$1;

                public final String apply() {
                    return new StringBuilder().append((Object)"OOME with size ").append(BoxesRunTime.boxToInteger(this.size$1)).toString();
                }
                {
                    this.size$1 = size$1;
                }
            }), (Function0<Throwable>)((Object)new Serializable(this, outOfMemoryError){
                public static final long serialVersionUID = 0L;
                private final OutOfMemoryError e$1;

                public final OutOfMemoryError apply() {
                    return this.e$1;
                }
                {
                    this.e$1 = e$1;
                }
            }));
            throw outOfMemoryError;
        }
    }

    public BoundedByteBufferReceive(int maxSize) {
        this.maxSize = maxSize;
        Logging$class.$init$(this);
        Transmission$class.$init$(this);
        Receive$class.$init$(this);
        this.sizeBuffer = ByteBuffer.allocate(4);
        this.contentBuffer = null;
        this.complete = false;
    }

    public BoundedByteBufferReceive() {
        this(Integer.MAX_VALUE);
    }
}

