/*
 * Decompiled with CFR 0.152.
 */
package groovy.test;

import groovy.lang.Closure;
import groovy.lang.GroovyRuntimeException;
import org.codehaus.groovy.runtime.ScriptBytecodeAdapter;
import org.junit.Assert;

public class GroovyAssert {
    private static final int MAX_NESTED_EXCEPTIONS = 10;

    public static Throwable shouldFail(Closure code) {
        boolean failed = false;
        Throwable th = null;
        try {
            code.call();
        }
        catch (GroovyRuntimeException gre) {
            failed = true;
            th = ScriptBytecodeAdapter.unwrap(gre);
        }
        catch (Throwable e) {
            failed = true;
            th = e;
        }
        Assert.assertTrue((String)("Closure " + code + " should have failed"), (boolean)failed);
        return th;
    }

    public static Throwable shouldFail(Class clazz, Closure code) {
        Throwable th = null;
        try {
            code.call();
        }
        catch (GroovyRuntimeException gre) {
            th = ScriptBytecodeAdapter.unwrap(gre);
        }
        catch (Throwable e) {
            th = e;
        }
        if (th == null) {
            Assert.fail((String)("Closure " + code + " should have failed with an exception of type " + clazz.getName()));
        } else if (!clazz.isInstance(th)) {
            Assert.fail((String)("Closure " + code + " should have failed with an exception of type " + clazz.getName() + ", instead got Exception " + th));
        }
        return th;
    }

    public static Throwable shouldFailWithCause(Class expectedCause, Closure code) {
        if (expectedCause == null) {
            Assert.fail((String)"The expectedCause class cannot be null");
        }
        Throwable cause = null;
        Throwable orig = null;
        int level = 0;
        try {
            code.call();
        }
        catch (GroovyRuntimeException gre) {
            orig = ScriptBytecodeAdapter.unwrap(gre);
            cause = orig.getCause();
        }
        catch (Throwable e) {
            orig = e;
            cause = orig.getCause();
        }
        if (orig != null && cause == null) {
            Assert.fail((String)("Closure " + code + " was expected to fail due to a nested cause of type " + expectedCause.getName() + " but instead got a direct exception of type " + orig.getClass().getName() + " with no nested cause(s). Code under test has a bug or perhaps you meant shouldFail?"));
        }
        while (cause != null && !expectedCause.isInstance(cause) && cause != cause.getCause() && level < 10) {
            cause = cause.getCause();
            ++level;
        }
        if (orig == null) {
            Assert.fail((String)("Closure " + code + " should have failed with an exception having a nested cause of type " + expectedCause.getName()));
        } else if (cause == null || !expectedCause.isInstance(cause)) {
            Assert.fail((String)("Closure " + code + " should have failed with an exception having a nested cause of type " + expectedCause.getName() + ", instead found these Exceptions:\n" + GroovyAssert.buildExceptionList(orig)));
        }
        return cause;
    }

    private static String buildExceptionList(Throwable th) {
        StringBuilder sb = new StringBuilder();
        int level = 0;
        while (th != null) {
            if (level > 1) {
                for (int i = 0; i < level - 1; ++i) {
                    sb.append("   ");
                }
            }
            if (level > 0) {
                sb.append("-> ");
            }
            if (level > 10) {
                sb.append("...");
                break;
            }
            sb.append(th.getClass().getName()).append(": ").append(th.getMessage()).append("\n");
            if (th == th.getCause()) break;
            th = th.getCause();
            ++level;
        }
        return sb.toString();
    }
}

