// DO NOT EDIT.
// swift-format-ignore-file
// swiftlint:disable all
//
// Generated by the Swift generator plugin for the protocol buffer compiler.
// Source: spark/connect/pipelines.proto
//
// For information on using the generated types, please see the documentation:
//   https://github.com/apple/swift-protobuf/

//
// Licensed to the Apache Software Foundation (ASF) under one or more
// contributor license agreements.  See the NOTICE file distributed with
// this work for additional information regarding copyright ownership.
// The ASF licenses this file to You under the Apache License, Version 2.0
// (the "License"); you may not use this file except in compliance with
// the License.  You may obtain a copy of the License at
//
//    http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

import SwiftProtobuf

// If the compiler emits an error on this type, it is because this file
// was generated by a version of the `protoc` Swift plug-in that is
// incompatible with the version of SwiftProtobuf to which you are linking.
// Please ensure that you are building against the same version of the API
// that was used to generate this file.
fileprivate struct _GeneratedWithProtocGenSwiftVersion: SwiftProtobuf.ProtobufAPIVersionCheck {
  struct _2: SwiftProtobuf.ProtobufAPIVersion_2 {}
  typealias Version = _2
}

/// The type of dataset.
enum Spark_Connect_DatasetType: SwiftProtobuf.Enum, Swift.CaseIterable {
  typealias RawValue = Int

  /// Safe default value. Should not be used.
  case unspecified // = 0

  /// A materialized view dataset which is published to the catalog
  case materializedView // = 1

  /// A table which is published to the catalog
  case table // = 2

  /// A view which is not published to the catalog
  case temporaryView // = 3
  case UNRECOGNIZED(Int)

  init() {
    self = .unspecified
  }

  init?(rawValue: Int) {
    switch rawValue {
    case 0: self = .unspecified
    case 1: self = .materializedView
    case 2: self = .table
    case 3: self = .temporaryView
    default: self = .UNRECOGNIZED(rawValue)
    }
  }

  var rawValue: Int {
    switch self {
    case .unspecified: return 0
    case .materializedView: return 1
    case .table: return 2
    case .temporaryView: return 3
    case .UNRECOGNIZED(let i): return i
    }
  }

  // The compiler won't synthesize support with the UNRECOGNIZED case.
  static let allCases: [Spark_Connect_DatasetType] = [
    .unspecified,
    .materializedView,
    .table,
    .temporaryView,
  ]

}

/// Dispatch object for pipelines commands. See each individual command for documentation.
struct Spark_Connect_PipelineCommand: Sendable {
  // SwiftProtobuf.Message conformance is added in an extension below. See the
  // `Message` and `Message+*Additions` files in the SwiftProtobuf library for
  // methods supported on all messages.

  var commandType: Spark_Connect_PipelineCommand.OneOf_CommandType? = nil

  var createDataflowGraph: Spark_Connect_PipelineCommand.CreateDataflowGraph {
    get {
      if case .createDataflowGraph(let v)? = commandType {return v}
      return Spark_Connect_PipelineCommand.CreateDataflowGraph()
    }
    set {commandType = .createDataflowGraph(newValue)}
  }

  var defineDataset: Spark_Connect_PipelineCommand.DefineDataset {
    get {
      if case .defineDataset(let v)? = commandType {return v}
      return Spark_Connect_PipelineCommand.DefineDataset()
    }
    set {commandType = .defineDataset(newValue)}
  }

  var defineFlow: Spark_Connect_PipelineCommand.DefineFlow {
    get {
      if case .defineFlow(let v)? = commandType {return v}
      return Spark_Connect_PipelineCommand.DefineFlow()
    }
    set {commandType = .defineFlow(newValue)}
  }

  var dropDataflowGraph: Spark_Connect_PipelineCommand.DropDataflowGraph {
    get {
      if case .dropDataflowGraph(let v)? = commandType {return v}
      return Spark_Connect_PipelineCommand.DropDataflowGraph()
    }
    set {commandType = .dropDataflowGraph(newValue)}
  }

  var startRun: Spark_Connect_PipelineCommand.StartRun {
    get {
      if case .startRun(let v)? = commandType {return v}
      return Spark_Connect_PipelineCommand.StartRun()
    }
    set {commandType = .startRun(newValue)}
  }

  var defineSqlGraphElements: Spark_Connect_PipelineCommand.DefineSqlGraphElements {
    get {
      if case .defineSqlGraphElements(let v)? = commandType {return v}
      return Spark_Connect_PipelineCommand.DefineSqlGraphElements()
    }
    set {commandType = .defineSqlGraphElements(newValue)}
  }

  var unknownFields = SwiftProtobuf.UnknownStorage()

  enum OneOf_CommandType: Equatable, Sendable {
    case createDataflowGraph(Spark_Connect_PipelineCommand.CreateDataflowGraph)
    case defineDataset(Spark_Connect_PipelineCommand.DefineDataset)
    case defineFlow(Spark_Connect_PipelineCommand.DefineFlow)
    case dropDataflowGraph(Spark_Connect_PipelineCommand.DropDataflowGraph)
    case startRun(Spark_Connect_PipelineCommand.StartRun)
    case defineSqlGraphElements(Spark_Connect_PipelineCommand.DefineSqlGraphElements)

  }

  /// Request to create a new dataflow graph.
  struct CreateDataflowGraph: Sendable {
    // SwiftProtobuf.Message conformance is added in an extension below. See the
    // `Message` and `Message+*Additions` files in the SwiftProtobuf library for
    // methods supported on all messages.

    /// The default catalog.
    var defaultCatalog: String {
      get {return _defaultCatalog ?? String()}
      set {_defaultCatalog = newValue}
    }
    /// Returns true if `defaultCatalog` has been explicitly set.
    var hasDefaultCatalog: Bool {return self._defaultCatalog != nil}
    /// Clears the value of `defaultCatalog`. Subsequent reads from it will return its default value.
    mutating func clearDefaultCatalog() {self._defaultCatalog = nil}

    /// The default database.
    var defaultDatabase: String {
      get {return _defaultDatabase ?? String()}
      set {_defaultDatabase = newValue}
    }
    /// Returns true if `defaultDatabase` has been explicitly set.
    var hasDefaultDatabase: Bool {return self._defaultDatabase != nil}
    /// Clears the value of `defaultDatabase`. Subsequent reads from it will return its default value.
    mutating func clearDefaultDatabase() {self._defaultDatabase = nil}

    /// SQL configurations for all flows in this graph.
    var sqlConf: Dictionary<String,String> = [:]

    var unknownFields = SwiftProtobuf.UnknownStorage()

    struct Response: Sendable {
      // SwiftProtobuf.Message conformance is added in an extension below. See the
      // `Message` and `Message+*Additions` files in the SwiftProtobuf library for
      // methods supported on all messages.

      /// The ID of the created graph.
      var dataflowGraphID: String {
        get {return _dataflowGraphID ?? String()}
        set {_dataflowGraphID = newValue}
      }
      /// Returns true if `dataflowGraphID` has been explicitly set.
      var hasDataflowGraphID: Bool {return self._dataflowGraphID != nil}
      /// Clears the value of `dataflowGraphID`. Subsequent reads from it will return its default value.
      mutating func clearDataflowGraphID() {self._dataflowGraphID = nil}

      var unknownFields = SwiftProtobuf.UnknownStorage()

      init() {}

      fileprivate var _dataflowGraphID: String? = nil
    }

    init() {}

    fileprivate var _defaultCatalog: String? = nil
    fileprivate var _defaultDatabase: String? = nil
  }

  /// Drops the graph and stops any running attached flows.
  struct DropDataflowGraph: Sendable {
    // SwiftProtobuf.Message conformance is added in an extension below. See the
    // `Message` and `Message+*Additions` files in the SwiftProtobuf library for
    // methods supported on all messages.

    /// The graph to drop.
    var dataflowGraphID: String {
      get {return _dataflowGraphID ?? String()}
      set {_dataflowGraphID = newValue}
    }
    /// Returns true if `dataflowGraphID` has been explicitly set.
    var hasDataflowGraphID: Bool {return self._dataflowGraphID != nil}
    /// Clears the value of `dataflowGraphID`. Subsequent reads from it will return its default value.
    mutating func clearDataflowGraphID() {self._dataflowGraphID = nil}

    var unknownFields = SwiftProtobuf.UnknownStorage()

    init() {}

    fileprivate var _dataflowGraphID: String? = nil
  }

  /// Request to define a dataset: a table, a materialized view, or a temporary view.
  struct DefineDataset: Sendable {
    // SwiftProtobuf.Message conformance is added in an extension below. See the
    // `Message` and `Message+*Additions` files in the SwiftProtobuf library for
    // methods supported on all messages.

    /// The graph to attach this dataset to.
    var dataflowGraphID: String {
      get {return _dataflowGraphID ?? String()}
      set {_dataflowGraphID = newValue}
    }
    /// Returns true if `dataflowGraphID` has been explicitly set.
    var hasDataflowGraphID: Bool {return self._dataflowGraphID != nil}
    /// Clears the value of `dataflowGraphID`. Subsequent reads from it will return its default value.
    mutating func clearDataflowGraphID() {self._dataflowGraphID = nil}

    /// Name of the dataset. Can be partially or fully qualified.
    var datasetName: String {
      get {return _datasetName ?? String()}
      set {_datasetName = newValue}
    }
    /// Returns true if `datasetName` has been explicitly set.
    var hasDatasetName: Bool {return self._datasetName != nil}
    /// Clears the value of `datasetName`. Subsequent reads from it will return its default value.
    mutating func clearDatasetName() {self._datasetName = nil}

    /// The type of the dataset.
    var datasetType: Spark_Connect_DatasetType {
      get {return _datasetType ?? .unspecified}
      set {_datasetType = newValue}
    }
    /// Returns true if `datasetType` has been explicitly set.
    var hasDatasetType: Bool {return self._datasetType != nil}
    /// Clears the value of `datasetType`. Subsequent reads from it will return its default value.
    mutating func clearDatasetType() {self._datasetType = nil}

    /// Optional comment for the dataset.
    var comment: String {
      get {return _comment ?? String()}
      set {_comment = newValue}
    }
    /// Returns true if `comment` has been explicitly set.
    var hasComment: Bool {return self._comment != nil}
    /// Clears the value of `comment`. Subsequent reads from it will return its default value.
    mutating func clearComment() {self._comment = nil}

    /// Optional table properties. Only applies to dataset_type == TABLE and dataset_type == MATERIALIZED_VIEW.
    var tableProperties: Dictionary<String,String> = [:]

    /// Optional partition columns for the dataset. Only applies to dataset_type == TABLE and
    /// dataset_type == MATERIALIZED_VIEW.
    var partitionCols: [String] = []

    /// Schema for the dataset. If unset, this will be inferred from incoming flows.
    var schema: Spark_Connect_DataType {
      get {return _schema ?? Spark_Connect_DataType()}
      set {_schema = newValue}
    }
    /// Returns true if `schema` has been explicitly set.
    var hasSchema: Bool {return self._schema != nil}
    /// Clears the value of `schema`. Subsequent reads from it will return its default value.
    mutating func clearSchema() {self._schema = nil}

    /// The output table format of the dataset. Only applies to dataset_type == TABLE and
    /// dataset_type == MATERIALIZED_VIEW.
    var format: String {
      get {return _format ?? String()}
      set {_format = newValue}
    }
    /// Returns true if `format` has been explicitly set.
    var hasFormat: Bool {return self._format != nil}
    /// Clears the value of `format`. Subsequent reads from it will return its default value.
    mutating func clearFormat() {self._format = nil}

    var unknownFields = SwiftProtobuf.UnknownStorage()

    init() {}

    fileprivate var _dataflowGraphID: String? = nil
    fileprivate var _datasetName: String? = nil
    fileprivate var _datasetType: Spark_Connect_DatasetType? = nil
    fileprivate var _comment: String? = nil
    fileprivate var _schema: Spark_Connect_DataType? = nil
    fileprivate var _format: String? = nil
  }

  /// Request to define a flow targeting a dataset.
  struct DefineFlow: Sendable {
    // SwiftProtobuf.Message conformance is added in an extension below. See the
    // `Message` and `Message+*Additions` files in the SwiftProtobuf library for
    // methods supported on all messages.

    /// The graph to attach this flow to.
    var dataflowGraphID: String {
      get {return _dataflowGraphID ?? String()}
      set {_dataflowGraphID = newValue}
    }
    /// Returns true if `dataflowGraphID` has been explicitly set.
    var hasDataflowGraphID: Bool {return self._dataflowGraphID != nil}
    /// Clears the value of `dataflowGraphID`. Subsequent reads from it will return its default value.
    mutating func clearDataflowGraphID() {self._dataflowGraphID = nil}

    /// Name of the flow. For standalone flows, this must be a single-part name.
    var flowName: String {
      get {return _flowName ?? String()}
      set {_flowName = newValue}
    }
    /// Returns true if `flowName` has been explicitly set.
    var hasFlowName: Bool {return self._flowName != nil}
    /// Clears the value of `flowName`. Subsequent reads from it will return its default value.
    mutating func clearFlowName() {self._flowName = nil}

    /// Name of the dataset this flow writes to. Can be partially or fully qualified.
    var targetDatasetName: String {
      get {return _targetDatasetName ?? String()}
      set {_targetDatasetName = newValue}
    }
    /// Returns true if `targetDatasetName` has been explicitly set.
    var hasTargetDatasetName: Bool {return self._targetDatasetName != nil}
    /// Clears the value of `targetDatasetName`. Subsequent reads from it will return its default value.
    mutating func clearTargetDatasetName() {self._targetDatasetName = nil}

    /// An unresolved relation that defines the dataset's flow.
    var plan: Spark_Connect_Relation {
      get {return _plan ?? Spark_Connect_Relation()}
      set {_plan = newValue}
    }
    /// Returns true if `plan` has been explicitly set.
    var hasPlan: Bool {return self._plan != nil}
    /// Clears the value of `plan`. Subsequent reads from it will return its default value.
    mutating func clearPlan() {self._plan = nil}

    /// SQL configurations set when running this flow.
    var sqlConf: Dictionary<String,String> = [:]

    /// If true, this flow will only be run once per full refresh.
    var once: Bool {
      get {return _once ?? false}
      set {_once = newValue}
    }
    /// Returns true if `once` has been explicitly set.
    var hasOnce: Bool {return self._once != nil}
    /// Clears the value of `once`. Subsequent reads from it will return its default value.
    mutating func clearOnce() {self._once = nil}

    var unknownFields = SwiftProtobuf.UnknownStorage()

    init() {}

    fileprivate var _dataflowGraphID: String? = nil
    fileprivate var _flowName: String? = nil
    fileprivate var _targetDatasetName: String? = nil
    fileprivate var _plan: Spark_Connect_Relation? = nil
    fileprivate var _once: Bool? = nil
  }

  /// Resolves all datasets and flows and start a pipeline update. Should be called after all
  /// graph elements are registered.
  struct StartRun: Sendable {
    // SwiftProtobuf.Message conformance is added in an extension below. See the
    // `Message` and `Message+*Additions` files in the SwiftProtobuf library for
    // methods supported on all messages.

    /// The graph to start.
    var dataflowGraphID: String {
      get {return _dataflowGraphID ?? String()}
      set {_dataflowGraphID = newValue}
    }
    /// Returns true if `dataflowGraphID` has been explicitly set.
    var hasDataflowGraphID: Bool {return self._dataflowGraphID != nil}
    /// Clears the value of `dataflowGraphID`. Subsequent reads from it will return its default value.
    mutating func clearDataflowGraphID() {self._dataflowGraphID = nil}

    var unknownFields = SwiftProtobuf.UnknownStorage()

    init() {}

    fileprivate var _dataflowGraphID: String? = nil
  }

  /// Parses the SQL file and registers all datasets and flows.
  struct DefineSqlGraphElements: Sendable {
    // SwiftProtobuf.Message conformance is added in an extension below. See the
    // `Message` and `Message+*Additions` files in the SwiftProtobuf library for
    // methods supported on all messages.

    /// The graph to attach this dataset to.
    var dataflowGraphID: String {
      get {return _dataflowGraphID ?? String()}
      set {_dataflowGraphID = newValue}
    }
    /// Returns true if `dataflowGraphID` has been explicitly set.
    var hasDataflowGraphID: Bool {return self._dataflowGraphID != nil}
    /// Clears the value of `dataflowGraphID`. Subsequent reads from it will return its default value.
    mutating func clearDataflowGraphID() {self._dataflowGraphID = nil}

    /// The full path to the SQL file. Can be relative or absolute.
    var sqlFilePath: String {
      get {return _sqlFilePath ?? String()}
      set {_sqlFilePath = newValue}
    }
    /// Returns true if `sqlFilePath` has been explicitly set.
    var hasSqlFilePath: Bool {return self._sqlFilePath != nil}
    /// Clears the value of `sqlFilePath`. Subsequent reads from it will return its default value.
    mutating func clearSqlFilePath() {self._sqlFilePath = nil}

    /// The contents of the SQL file.
    var sqlText: String {
      get {return _sqlText ?? String()}
      set {_sqlText = newValue}
    }
    /// Returns true if `sqlText` has been explicitly set.
    var hasSqlText: Bool {return self._sqlText != nil}
    /// Clears the value of `sqlText`. Subsequent reads from it will return its default value.
    mutating func clearSqlText() {self._sqlText = nil}

    var unknownFields = SwiftProtobuf.UnknownStorage()

    init() {}

    fileprivate var _dataflowGraphID: String? = nil
    fileprivate var _sqlFilePath: String? = nil
    fileprivate var _sqlText: String? = nil
  }

  init() {}
}

/// Dispatch object for pipelines command results.
struct Spark_Connect_PipelineCommandResult: Sendable {
  // SwiftProtobuf.Message conformance is added in an extension below. See the
  // `Message` and `Message+*Additions` files in the SwiftProtobuf library for
  // methods supported on all messages.

  var resultType: Spark_Connect_PipelineCommandResult.OneOf_ResultType? = nil

  var createDataflowGraphResult: Spark_Connect_PipelineCommandResult.CreateDataflowGraphResult {
    get {
      if case .createDataflowGraphResult(let v)? = resultType {return v}
      return Spark_Connect_PipelineCommandResult.CreateDataflowGraphResult()
    }
    set {resultType = .createDataflowGraphResult(newValue)}
  }

  var unknownFields = SwiftProtobuf.UnknownStorage()

  enum OneOf_ResultType: Equatable, Sendable {
    case createDataflowGraphResult(Spark_Connect_PipelineCommandResult.CreateDataflowGraphResult)

  }

  struct CreateDataflowGraphResult: Sendable {
    // SwiftProtobuf.Message conformance is added in an extension below. See the
    // `Message` and `Message+*Additions` files in the SwiftProtobuf library for
    // methods supported on all messages.

    /// The ID of the created graph.
    var dataflowGraphID: String {
      get {return _dataflowGraphID ?? String()}
      set {_dataflowGraphID = newValue}
    }
    /// Returns true if `dataflowGraphID` has been explicitly set.
    var hasDataflowGraphID: Bool {return self._dataflowGraphID != nil}
    /// Clears the value of `dataflowGraphID`. Subsequent reads from it will return its default value.
    mutating func clearDataflowGraphID() {self._dataflowGraphID = nil}

    var unknownFields = SwiftProtobuf.UnknownStorage()

    init() {}

    fileprivate var _dataflowGraphID: String? = nil
  }

  init() {}
}

/// A response containing an event emitted during the run of a pipeline.
struct Spark_Connect_PipelineEventResult: Sendable {
  // SwiftProtobuf.Message conformance is added in an extension below. See the
  // `Message` and `Message+*Additions` files in the SwiftProtobuf library for
  // methods supported on all messages.

  var event: Spark_Connect_PipelineEvent {
    get {return _event ?? Spark_Connect_PipelineEvent()}
    set {_event = newValue}
  }
  /// Returns true if `event` has been explicitly set.
  var hasEvent: Bool {return self._event != nil}
  /// Clears the value of `event`. Subsequent reads from it will return its default value.
  mutating func clearEvent() {self._event = nil}

  var unknownFields = SwiftProtobuf.UnknownStorage()

  init() {}

  fileprivate var _event: Spark_Connect_PipelineEvent? = nil
}

struct Spark_Connect_PipelineEvent: Sendable {
  // SwiftProtobuf.Message conformance is added in an extension below. See the
  // `Message` and `Message+*Additions` files in the SwiftProtobuf library for
  // methods supported on all messages.

  /// The timestamp corresponding to when the event occurred.
  var timestamp: SwiftProtobuf.Google_Protobuf_Timestamp {
    get {return _timestamp ?? SwiftProtobuf.Google_Protobuf_Timestamp()}
    set {_timestamp = newValue}
  }
  /// Returns true if `timestamp` has been explicitly set.
  var hasTimestamp: Bool {return self._timestamp != nil}
  /// Clears the value of `timestamp`. Subsequent reads from it will return its default value.
  mutating func clearTimestamp() {self._timestamp = nil}

  /// The message that should be displayed to users.
  var message: String {
    get {return _message ?? String()}
    set {_message = newValue}
  }
  /// Returns true if `message` has been explicitly set.
  var hasMessage: Bool {return self._message != nil}
  /// Clears the value of `message`. Subsequent reads from it will return its default value.
  mutating func clearMessage() {self._message = nil}

  var unknownFields = SwiftProtobuf.UnknownStorage()

  init() {}

  fileprivate var _timestamp: SwiftProtobuf.Google_Protobuf_Timestamp? = nil
  fileprivate var _message: String? = nil
}

// MARK: - Code below here is support for the SwiftProtobuf runtime.

fileprivate let _protobuf_package = "spark.connect"

extension Spark_Connect_DatasetType: SwiftProtobuf._ProtoNameProviding {
  static let _protobuf_nameMap: SwiftProtobuf._NameMap = [
    0: .same(proto: "DATASET_TYPE_UNSPECIFIED"),
    1: .same(proto: "MATERIALIZED_VIEW"),
    2: .same(proto: "TABLE"),
    3: .same(proto: "TEMPORARY_VIEW"),
  ]
}

extension Spark_Connect_PipelineCommand: SwiftProtobuf.Message, SwiftProtobuf._MessageImplementationBase, SwiftProtobuf._ProtoNameProviding {
  static let protoMessageName: String = _protobuf_package + ".PipelineCommand"
  static let _protobuf_nameMap: SwiftProtobuf._NameMap = [
    1: .standard(proto: "create_dataflow_graph"),
    2: .standard(proto: "define_dataset"),
    3: .standard(proto: "define_flow"),
    4: .standard(proto: "drop_dataflow_graph"),
    5: .standard(proto: "start_run"),
    6: .standard(proto: "define_sql_graph_elements"),
  ]

  mutating func decodeMessage<D: SwiftProtobuf.Decoder>(decoder: inout D) throws {
    while let fieldNumber = try decoder.nextFieldNumber() {
      // The use of inline closures is to circumvent an issue where the compiler
      // allocates stack space for every case branch when no optimizations are
      // enabled. https://github.com/apple/swift-protobuf/issues/1034
      switch fieldNumber {
      case 1: try {
        var v: Spark_Connect_PipelineCommand.CreateDataflowGraph?
        var hadOneofValue = false
        if let current = self.commandType {
          hadOneofValue = true
          if case .createDataflowGraph(let m) = current {v = m}
        }
        try decoder.decodeSingularMessageField(value: &v)
        if let v = v {
          if hadOneofValue {try decoder.handleConflictingOneOf()}
          self.commandType = .createDataflowGraph(v)
        }
      }()
      case 2: try {
        var v: Spark_Connect_PipelineCommand.DefineDataset?
        var hadOneofValue = false
        if let current = self.commandType {
          hadOneofValue = true
          if case .defineDataset(let m) = current {v = m}
        }
        try decoder.decodeSingularMessageField(value: &v)
        if let v = v {
          if hadOneofValue {try decoder.handleConflictingOneOf()}
          self.commandType = .defineDataset(v)
        }
      }()
      case 3: try {
        var v: Spark_Connect_PipelineCommand.DefineFlow?
        var hadOneofValue = false
        if let current = self.commandType {
          hadOneofValue = true
          if case .defineFlow(let m) = current {v = m}
        }
        try decoder.decodeSingularMessageField(value: &v)
        if let v = v {
          if hadOneofValue {try decoder.handleConflictingOneOf()}
          self.commandType = .defineFlow(v)
        }
      }()
      case 4: try {
        var v: Spark_Connect_PipelineCommand.DropDataflowGraph?
        var hadOneofValue = false
        if let current = self.commandType {
          hadOneofValue = true
          if case .dropDataflowGraph(let m) = current {v = m}
        }
        try decoder.decodeSingularMessageField(value: &v)
        if let v = v {
          if hadOneofValue {try decoder.handleConflictingOneOf()}
          self.commandType = .dropDataflowGraph(v)
        }
      }()
      case 5: try {
        var v: Spark_Connect_PipelineCommand.StartRun?
        var hadOneofValue = false
        if let current = self.commandType {
          hadOneofValue = true
          if case .startRun(let m) = current {v = m}
        }
        try decoder.decodeSingularMessageField(value: &v)
        if let v = v {
          if hadOneofValue {try decoder.handleConflictingOneOf()}
          self.commandType = .startRun(v)
        }
      }()
      case 6: try {
        var v: Spark_Connect_PipelineCommand.DefineSqlGraphElements?
        var hadOneofValue = false
        if let current = self.commandType {
          hadOneofValue = true
          if case .defineSqlGraphElements(let m) = current {v = m}
        }
        try decoder.decodeSingularMessageField(value: &v)
        if let v = v {
          if hadOneofValue {try decoder.handleConflictingOneOf()}
          self.commandType = .defineSqlGraphElements(v)
        }
      }()
      default: break
      }
    }
  }

  func traverse<V: SwiftProtobuf.Visitor>(visitor: inout V) throws {
    // The use of inline closures is to circumvent an issue where the compiler
    // allocates stack space for every if/case branch local when no optimizations
    // are enabled. https://github.com/apple/swift-protobuf/issues/1034 and
    // https://github.com/apple/swift-protobuf/issues/1182
    switch self.commandType {
    case .createDataflowGraph?: try {
      guard case .createDataflowGraph(let v)? = self.commandType else { preconditionFailure() }
      try visitor.visitSingularMessageField(value: v, fieldNumber: 1)
    }()
    case .defineDataset?: try {
      guard case .defineDataset(let v)? = self.commandType else { preconditionFailure() }
      try visitor.visitSingularMessageField(value: v, fieldNumber: 2)
    }()
    case .defineFlow?: try {
      guard case .defineFlow(let v)? = self.commandType else { preconditionFailure() }
      try visitor.visitSingularMessageField(value: v, fieldNumber: 3)
    }()
    case .dropDataflowGraph?: try {
      guard case .dropDataflowGraph(let v)? = self.commandType else { preconditionFailure() }
      try visitor.visitSingularMessageField(value: v, fieldNumber: 4)
    }()
    case .startRun?: try {
      guard case .startRun(let v)? = self.commandType else { preconditionFailure() }
      try visitor.visitSingularMessageField(value: v, fieldNumber: 5)
    }()
    case .defineSqlGraphElements?: try {
      guard case .defineSqlGraphElements(let v)? = self.commandType else { preconditionFailure() }
      try visitor.visitSingularMessageField(value: v, fieldNumber: 6)
    }()
    case nil: break
    }
    try unknownFields.traverse(visitor: &visitor)
  }

  static func ==(lhs: Spark_Connect_PipelineCommand, rhs: Spark_Connect_PipelineCommand) -> Bool {
    if lhs.commandType != rhs.commandType {return false}
    if lhs.unknownFields != rhs.unknownFields {return false}
    return true
  }
}

extension Spark_Connect_PipelineCommand.CreateDataflowGraph: SwiftProtobuf.Message, SwiftProtobuf._MessageImplementationBase, SwiftProtobuf._ProtoNameProviding {
  static let protoMessageName: String = Spark_Connect_PipelineCommand.protoMessageName + ".CreateDataflowGraph"
  static let _protobuf_nameMap: SwiftProtobuf._NameMap = [
    1: .standard(proto: "default_catalog"),
    2: .standard(proto: "default_database"),
    5: .standard(proto: "sql_conf"),
  ]

  mutating func decodeMessage<D: SwiftProtobuf.Decoder>(decoder: inout D) throws {
    while let fieldNumber = try decoder.nextFieldNumber() {
      // The use of inline closures is to circumvent an issue where the compiler
      // allocates stack space for every case branch when no optimizations are
      // enabled. https://github.com/apple/swift-protobuf/issues/1034
      switch fieldNumber {
      case 1: try { try decoder.decodeSingularStringField(value: &self._defaultCatalog) }()
      case 2: try { try decoder.decodeSingularStringField(value: &self._defaultDatabase) }()
      case 5: try { try decoder.decodeMapField(fieldType: SwiftProtobuf._ProtobufMap<SwiftProtobuf.ProtobufString,SwiftProtobuf.ProtobufString>.self, value: &self.sqlConf) }()
      default: break
      }
    }
  }

  func traverse<V: SwiftProtobuf.Visitor>(visitor: inout V) throws {
    // The use of inline closures is to circumvent an issue where the compiler
    // allocates stack space for every if/case branch local when no optimizations
    // are enabled. https://github.com/apple/swift-protobuf/issues/1034 and
    // https://github.com/apple/swift-protobuf/issues/1182
    try { if let v = self._defaultCatalog {
      try visitor.visitSingularStringField(value: v, fieldNumber: 1)
    } }()
    try { if let v = self._defaultDatabase {
      try visitor.visitSingularStringField(value: v, fieldNumber: 2)
    } }()
    if !self.sqlConf.isEmpty {
      try visitor.visitMapField(fieldType: SwiftProtobuf._ProtobufMap<SwiftProtobuf.ProtobufString,SwiftProtobuf.ProtobufString>.self, value: self.sqlConf, fieldNumber: 5)
    }
    try unknownFields.traverse(visitor: &visitor)
  }

  static func ==(lhs: Spark_Connect_PipelineCommand.CreateDataflowGraph, rhs: Spark_Connect_PipelineCommand.CreateDataflowGraph) -> Bool {
    if lhs._defaultCatalog != rhs._defaultCatalog {return false}
    if lhs._defaultDatabase != rhs._defaultDatabase {return false}
    if lhs.sqlConf != rhs.sqlConf {return false}
    if lhs.unknownFields != rhs.unknownFields {return false}
    return true
  }
}

extension Spark_Connect_PipelineCommand.CreateDataflowGraph.Response: SwiftProtobuf.Message, SwiftProtobuf._MessageImplementationBase, SwiftProtobuf._ProtoNameProviding {
  static let protoMessageName: String = Spark_Connect_PipelineCommand.CreateDataflowGraph.protoMessageName + ".Response"
  static let _protobuf_nameMap: SwiftProtobuf._NameMap = [
    1: .standard(proto: "dataflow_graph_id"),
  ]

  mutating func decodeMessage<D: SwiftProtobuf.Decoder>(decoder: inout D) throws {
    while let fieldNumber = try decoder.nextFieldNumber() {
      // The use of inline closures is to circumvent an issue where the compiler
      // allocates stack space for every case branch when no optimizations are
      // enabled. https://github.com/apple/swift-protobuf/issues/1034
      switch fieldNumber {
      case 1: try { try decoder.decodeSingularStringField(value: &self._dataflowGraphID) }()
      default: break
      }
    }
  }

  func traverse<V: SwiftProtobuf.Visitor>(visitor: inout V) throws {
    // The use of inline closures is to circumvent an issue where the compiler
    // allocates stack space for every if/case branch local when no optimizations
    // are enabled. https://github.com/apple/swift-protobuf/issues/1034 and
    // https://github.com/apple/swift-protobuf/issues/1182
    try { if let v = self._dataflowGraphID {
      try visitor.visitSingularStringField(value: v, fieldNumber: 1)
    } }()
    try unknownFields.traverse(visitor: &visitor)
  }

  static func ==(lhs: Spark_Connect_PipelineCommand.CreateDataflowGraph.Response, rhs: Spark_Connect_PipelineCommand.CreateDataflowGraph.Response) -> Bool {
    if lhs._dataflowGraphID != rhs._dataflowGraphID {return false}
    if lhs.unknownFields != rhs.unknownFields {return false}
    return true
  }
}

extension Spark_Connect_PipelineCommand.DropDataflowGraph: SwiftProtobuf.Message, SwiftProtobuf._MessageImplementationBase, SwiftProtobuf._ProtoNameProviding {
  static let protoMessageName: String = Spark_Connect_PipelineCommand.protoMessageName + ".DropDataflowGraph"
  static let _protobuf_nameMap: SwiftProtobuf._NameMap = [
    1: .standard(proto: "dataflow_graph_id"),
  ]

  mutating func decodeMessage<D: SwiftProtobuf.Decoder>(decoder: inout D) throws {
    while let fieldNumber = try decoder.nextFieldNumber() {
      // The use of inline closures is to circumvent an issue where the compiler
      // allocates stack space for every case branch when no optimizations are
      // enabled. https://github.com/apple/swift-protobuf/issues/1034
      switch fieldNumber {
      case 1: try { try decoder.decodeSingularStringField(value: &self._dataflowGraphID) }()
      default: break
      }
    }
  }

  func traverse<V: SwiftProtobuf.Visitor>(visitor: inout V) throws {
    // The use of inline closures is to circumvent an issue where the compiler
    // allocates stack space for every if/case branch local when no optimizations
    // are enabled. https://github.com/apple/swift-protobuf/issues/1034 and
    // https://github.com/apple/swift-protobuf/issues/1182
    try { if let v = self._dataflowGraphID {
      try visitor.visitSingularStringField(value: v, fieldNumber: 1)
    } }()
    try unknownFields.traverse(visitor: &visitor)
  }

  static func ==(lhs: Spark_Connect_PipelineCommand.DropDataflowGraph, rhs: Spark_Connect_PipelineCommand.DropDataflowGraph) -> Bool {
    if lhs._dataflowGraphID != rhs._dataflowGraphID {return false}
    if lhs.unknownFields != rhs.unknownFields {return false}
    return true
  }
}

extension Spark_Connect_PipelineCommand.DefineDataset: SwiftProtobuf.Message, SwiftProtobuf._MessageImplementationBase, SwiftProtobuf._ProtoNameProviding {
  static let protoMessageName: String = Spark_Connect_PipelineCommand.protoMessageName + ".DefineDataset"
  static let _protobuf_nameMap: SwiftProtobuf._NameMap = [
    1: .standard(proto: "dataflow_graph_id"),
    2: .standard(proto: "dataset_name"),
    3: .standard(proto: "dataset_type"),
    4: .same(proto: "comment"),
    5: .standard(proto: "table_properties"),
    6: .standard(proto: "partition_cols"),
    7: .same(proto: "schema"),
    8: .same(proto: "format"),
  ]

  mutating func decodeMessage<D: SwiftProtobuf.Decoder>(decoder: inout D) throws {
    while let fieldNumber = try decoder.nextFieldNumber() {
      // The use of inline closures is to circumvent an issue where the compiler
      // allocates stack space for every case branch when no optimizations are
      // enabled. https://github.com/apple/swift-protobuf/issues/1034
      switch fieldNumber {
      case 1: try { try decoder.decodeSingularStringField(value: &self._dataflowGraphID) }()
      case 2: try { try decoder.decodeSingularStringField(value: &self._datasetName) }()
      case 3: try { try decoder.decodeSingularEnumField(value: &self._datasetType) }()
      case 4: try { try decoder.decodeSingularStringField(value: &self._comment) }()
      case 5: try { try decoder.decodeMapField(fieldType: SwiftProtobuf._ProtobufMap<SwiftProtobuf.ProtobufString,SwiftProtobuf.ProtobufString>.self, value: &self.tableProperties) }()
      case 6: try { try decoder.decodeRepeatedStringField(value: &self.partitionCols) }()
      case 7: try { try decoder.decodeSingularMessageField(value: &self._schema) }()
      case 8: try { try decoder.decodeSingularStringField(value: &self._format) }()
      default: break
      }
    }
  }

  func traverse<V: SwiftProtobuf.Visitor>(visitor: inout V) throws {
    // The use of inline closures is to circumvent an issue where the compiler
    // allocates stack space for every if/case branch local when no optimizations
    // are enabled. https://github.com/apple/swift-protobuf/issues/1034 and
    // https://github.com/apple/swift-protobuf/issues/1182
    try { if let v = self._dataflowGraphID {
      try visitor.visitSingularStringField(value: v, fieldNumber: 1)
    } }()
    try { if let v = self._datasetName {
      try visitor.visitSingularStringField(value: v, fieldNumber: 2)
    } }()
    try { if let v = self._datasetType {
      try visitor.visitSingularEnumField(value: v, fieldNumber: 3)
    } }()
    try { if let v = self._comment {
      try visitor.visitSingularStringField(value: v, fieldNumber: 4)
    } }()
    if !self.tableProperties.isEmpty {
      try visitor.visitMapField(fieldType: SwiftProtobuf._ProtobufMap<SwiftProtobuf.ProtobufString,SwiftProtobuf.ProtobufString>.self, value: self.tableProperties, fieldNumber: 5)
    }
    if !self.partitionCols.isEmpty {
      try visitor.visitRepeatedStringField(value: self.partitionCols, fieldNumber: 6)
    }
    try { if let v = self._schema {
      try visitor.visitSingularMessageField(value: v, fieldNumber: 7)
    } }()
    try { if let v = self._format {
      try visitor.visitSingularStringField(value: v, fieldNumber: 8)
    } }()
    try unknownFields.traverse(visitor: &visitor)
  }

  static func ==(lhs: Spark_Connect_PipelineCommand.DefineDataset, rhs: Spark_Connect_PipelineCommand.DefineDataset) -> Bool {
    if lhs._dataflowGraphID != rhs._dataflowGraphID {return false}
    if lhs._datasetName != rhs._datasetName {return false}
    if lhs._datasetType != rhs._datasetType {return false}
    if lhs._comment != rhs._comment {return false}
    if lhs.tableProperties != rhs.tableProperties {return false}
    if lhs.partitionCols != rhs.partitionCols {return false}
    if lhs._schema != rhs._schema {return false}
    if lhs._format != rhs._format {return false}
    if lhs.unknownFields != rhs.unknownFields {return false}
    return true
  }
}

extension Spark_Connect_PipelineCommand.DefineFlow: SwiftProtobuf.Message, SwiftProtobuf._MessageImplementationBase, SwiftProtobuf._ProtoNameProviding {
  static let protoMessageName: String = Spark_Connect_PipelineCommand.protoMessageName + ".DefineFlow"
  static let _protobuf_nameMap: SwiftProtobuf._NameMap = [
    1: .standard(proto: "dataflow_graph_id"),
    2: .standard(proto: "flow_name"),
    3: .standard(proto: "target_dataset_name"),
    4: .same(proto: "plan"),
    5: .standard(proto: "sql_conf"),
    6: .same(proto: "once"),
  ]

  mutating func decodeMessage<D: SwiftProtobuf.Decoder>(decoder: inout D) throws {
    while let fieldNumber = try decoder.nextFieldNumber() {
      // The use of inline closures is to circumvent an issue where the compiler
      // allocates stack space for every case branch when no optimizations are
      // enabled. https://github.com/apple/swift-protobuf/issues/1034
      switch fieldNumber {
      case 1: try { try decoder.decodeSingularStringField(value: &self._dataflowGraphID) }()
      case 2: try { try decoder.decodeSingularStringField(value: &self._flowName) }()
      case 3: try { try decoder.decodeSingularStringField(value: &self._targetDatasetName) }()
      case 4: try { try decoder.decodeSingularMessageField(value: &self._plan) }()
      case 5: try { try decoder.decodeMapField(fieldType: SwiftProtobuf._ProtobufMap<SwiftProtobuf.ProtobufString,SwiftProtobuf.ProtobufString>.self, value: &self.sqlConf) }()
      case 6: try { try decoder.decodeSingularBoolField(value: &self._once) }()
      default: break
      }
    }
  }

  func traverse<V: SwiftProtobuf.Visitor>(visitor: inout V) throws {
    // The use of inline closures is to circumvent an issue where the compiler
    // allocates stack space for every if/case branch local when no optimizations
    // are enabled. https://github.com/apple/swift-protobuf/issues/1034 and
    // https://github.com/apple/swift-protobuf/issues/1182
    try { if let v = self._dataflowGraphID {
      try visitor.visitSingularStringField(value: v, fieldNumber: 1)
    } }()
    try { if let v = self._flowName {
      try visitor.visitSingularStringField(value: v, fieldNumber: 2)
    } }()
    try { if let v = self._targetDatasetName {
      try visitor.visitSingularStringField(value: v, fieldNumber: 3)
    } }()
    try { if let v = self._plan {
      try visitor.visitSingularMessageField(value: v, fieldNumber: 4)
    } }()
    if !self.sqlConf.isEmpty {
      try visitor.visitMapField(fieldType: SwiftProtobuf._ProtobufMap<SwiftProtobuf.ProtobufString,SwiftProtobuf.ProtobufString>.self, value: self.sqlConf, fieldNumber: 5)
    }
    try { if let v = self._once {
      try visitor.visitSingularBoolField(value: v, fieldNumber: 6)
    } }()
    try unknownFields.traverse(visitor: &visitor)
  }

  static func ==(lhs: Spark_Connect_PipelineCommand.DefineFlow, rhs: Spark_Connect_PipelineCommand.DefineFlow) -> Bool {
    if lhs._dataflowGraphID != rhs._dataflowGraphID {return false}
    if lhs._flowName != rhs._flowName {return false}
    if lhs._targetDatasetName != rhs._targetDatasetName {return false}
    if lhs._plan != rhs._plan {return false}
    if lhs.sqlConf != rhs.sqlConf {return false}
    if lhs._once != rhs._once {return false}
    if lhs.unknownFields != rhs.unknownFields {return false}
    return true
  }
}

extension Spark_Connect_PipelineCommand.StartRun: SwiftProtobuf.Message, SwiftProtobuf._MessageImplementationBase, SwiftProtobuf._ProtoNameProviding {
  static let protoMessageName: String = Spark_Connect_PipelineCommand.protoMessageName + ".StartRun"
  static let _protobuf_nameMap: SwiftProtobuf._NameMap = [
    1: .standard(proto: "dataflow_graph_id"),
  ]

  mutating func decodeMessage<D: SwiftProtobuf.Decoder>(decoder: inout D) throws {
    while let fieldNumber = try decoder.nextFieldNumber() {
      // The use of inline closures is to circumvent an issue where the compiler
      // allocates stack space for every case branch when no optimizations are
      // enabled. https://github.com/apple/swift-protobuf/issues/1034
      switch fieldNumber {
      case 1: try { try decoder.decodeSingularStringField(value: &self._dataflowGraphID) }()
      default: break
      }
    }
  }

  func traverse<V: SwiftProtobuf.Visitor>(visitor: inout V) throws {
    // The use of inline closures is to circumvent an issue where the compiler
    // allocates stack space for every if/case branch local when no optimizations
    // are enabled. https://github.com/apple/swift-protobuf/issues/1034 and
    // https://github.com/apple/swift-protobuf/issues/1182
    try { if let v = self._dataflowGraphID {
      try visitor.visitSingularStringField(value: v, fieldNumber: 1)
    } }()
    try unknownFields.traverse(visitor: &visitor)
  }

  static func ==(lhs: Spark_Connect_PipelineCommand.StartRun, rhs: Spark_Connect_PipelineCommand.StartRun) -> Bool {
    if lhs._dataflowGraphID != rhs._dataflowGraphID {return false}
    if lhs.unknownFields != rhs.unknownFields {return false}
    return true
  }
}

extension Spark_Connect_PipelineCommand.DefineSqlGraphElements: SwiftProtobuf.Message, SwiftProtobuf._MessageImplementationBase, SwiftProtobuf._ProtoNameProviding {
  static let protoMessageName: String = Spark_Connect_PipelineCommand.protoMessageName + ".DefineSqlGraphElements"
  static let _protobuf_nameMap: SwiftProtobuf._NameMap = [
    1: .standard(proto: "dataflow_graph_id"),
    2: .standard(proto: "sql_file_path"),
    3: .standard(proto: "sql_text"),
  ]

  mutating func decodeMessage<D: SwiftProtobuf.Decoder>(decoder: inout D) throws {
    while let fieldNumber = try decoder.nextFieldNumber() {
      // The use of inline closures is to circumvent an issue where the compiler
      // allocates stack space for every case branch when no optimizations are
      // enabled. https://github.com/apple/swift-protobuf/issues/1034
      switch fieldNumber {
      case 1: try { try decoder.decodeSingularStringField(value: &self._dataflowGraphID) }()
      case 2: try { try decoder.decodeSingularStringField(value: &self._sqlFilePath) }()
      case 3: try { try decoder.decodeSingularStringField(value: &self._sqlText) }()
      default: break
      }
    }
  }

  func traverse<V: SwiftProtobuf.Visitor>(visitor: inout V) throws {
    // The use of inline closures is to circumvent an issue where the compiler
    // allocates stack space for every if/case branch local when no optimizations
    // are enabled. https://github.com/apple/swift-protobuf/issues/1034 and
    // https://github.com/apple/swift-protobuf/issues/1182
    try { if let v = self._dataflowGraphID {
      try visitor.visitSingularStringField(value: v, fieldNumber: 1)
    } }()
    try { if let v = self._sqlFilePath {
      try visitor.visitSingularStringField(value: v, fieldNumber: 2)
    } }()
    try { if let v = self._sqlText {
      try visitor.visitSingularStringField(value: v, fieldNumber: 3)
    } }()
    try unknownFields.traverse(visitor: &visitor)
  }

  static func ==(lhs: Spark_Connect_PipelineCommand.DefineSqlGraphElements, rhs: Spark_Connect_PipelineCommand.DefineSqlGraphElements) -> Bool {
    if lhs._dataflowGraphID != rhs._dataflowGraphID {return false}
    if lhs._sqlFilePath != rhs._sqlFilePath {return false}
    if lhs._sqlText != rhs._sqlText {return false}
    if lhs.unknownFields != rhs.unknownFields {return false}
    return true
  }
}

extension Spark_Connect_PipelineCommandResult: SwiftProtobuf.Message, SwiftProtobuf._MessageImplementationBase, SwiftProtobuf._ProtoNameProviding {
  static let protoMessageName: String = _protobuf_package + ".PipelineCommandResult"
  static let _protobuf_nameMap: SwiftProtobuf._NameMap = [
    1: .standard(proto: "create_dataflow_graph_result"),
  ]

  mutating func decodeMessage<D: SwiftProtobuf.Decoder>(decoder: inout D) throws {
    while let fieldNumber = try decoder.nextFieldNumber() {
      // The use of inline closures is to circumvent an issue where the compiler
      // allocates stack space for every case branch when no optimizations are
      // enabled. https://github.com/apple/swift-protobuf/issues/1034
      switch fieldNumber {
      case 1: try {
        var v: Spark_Connect_PipelineCommandResult.CreateDataflowGraphResult?
        var hadOneofValue = false
        if let current = self.resultType {
          hadOneofValue = true
          if case .createDataflowGraphResult(let m) = current {v = m}
        }
        try decoder.decodeSingularMessageField(value: &v)
        if let v = v {
          if hadOneofValue {try decoder.handleConflictingOneOf()}
          self.resultType = .createDataflowGraphResult(v)
        }
      }()
      default: break
      }
    }
  }

  func traverse<V: SwiftProtobuf.Visitor>(visitor: inout V) throws {
    // The use of inline closures is to circumvent an issue where the compiler
    // allocates stack space for every if/case branch local when no optimizations
    // are enabled. https://github.com/apple/swift-protobuf/issues/1034 and
    // https://github.com/apple/swift-protobuf/issues/1182
    try { if case .createDataflowGraphResult(let v)? = self.resultType {
      try visitor.visitSingularMessageField(value: v, fieldNumber: 1)
    } }()
    try unknownFields.traverse(visitor: &visitor)
  }

  static func ==(lhs: Spark_Connect_PipelineCommandResult, rhs: Spark_Connect_PipelineCommandResult) -> Bool {
    if lhs.resultType != rhs.resultType {return false}
    if lhs.unknownFields != rhs.unknownFields {return false}
    return true
  }
}

extension Spark_Connect_PipelineCommandResult.CreateDataflowGraphResult: SwiftProtobuf.Message, SwiftProtobuf._MessageImplementationBase, SwiftProtobuf._ProtoNameProviding {
  static let protoMessageName: String = Spark_Connect_PipelineCommandResult.protoMessageName + ".CreateDataflowGraphResult"
  static let _protobuf_nameMap: SwiftProtobuf._NameMap = [
    1: .standard(proto: "dataflow_graph_id"),
  ]

  mutating func decodeMessage<D: SwiftProtobuf.Decoder>(decoder: inout D) throws {
    while let fieldNumber = try decoder.nextFieldNumber() {
      // The use of inline closures is to circumvent an issue where the compiler
      // allocates stack space for every case branch when no optimizations are
      // enabled. https://github.com/apple/swift-protobuf/issues/1034
      switch fieldNumber {
      case 1: try { try decoder.decodeSingularStringField(value: &self._dataflowGraphID) }()
      default: break
      }
    }
  }

  func traverse<V: SwiftProtobuf.Visitor>(visitor: inout V) throws {
    // The use of inline closures is to circumvent an issue where the compiler
    // allocates stack space for every if/case branch local when no optimizations
    // are enabled. https://github.com/apple/swift-protobuf/issues/1034 and
    // https://github.com/apple/swift-protobuf/issues/1182
    try { if let v = self._dataflowGraphID {
      try visitor.visitSingularStringField(value: v, fieldNumber: 1)
    } }()
    try unknownFields.traverse(visitor: &visitor)
  }

  static func ==(lhs: Spark_Connect_PipelineCommandResult.CreateDataflowGraphResult, rhs: Spark_Connect_PipelineCommandResult.CreateDataflowGraphResult) -> Bool {
    if lhs._dataflowGraphID != rhs._dataflowGraphID {return false}
    if lhs.unknownFields != rhs.unknownFields {return false}
    return true
  }
}

extension Spark_Connect_PipelineEventResult: SwiftProtobuf.Message, SwiftProtobuf._MessageImplementationBase, SwiftProtobuf._ProtoNameProviding {
  static let protoMessageName: String = _protobuf_package + ".PipelineEventResult"
  static let _protobuf_nameMap: SwiftProtobuf._NameMap = [
    1: .same(proto: "event"),
  ]

  mutating func decodeMessage<D: SwiftProtobuf.Decoder>(decoder: inout D) throws {
    while let fieldNumber = try decoder.nextFieldNumber() {
      // The use of inline closures is to circumvent an issue where the compiler
      // allocates stack space for every case branch when no optimizations are
      // enabled. https://github.com/apple/swift-protobuf/issues/1034
      switch fieldNumber {
      case 1: try { try decoder.decodeSingularMessageField(value: &self._event) }()
      default: break
      }
    }
  }

  func traverse<V: SwiftProtobuf.Visitor>(visitor: inout V) throws {
    // The use of inline closures is to circumvent an issue where the compiler
    // allocates stack space for every if/case branch local when no optimizations
    // are enabled. https://github.com/apple/swift-protobuf/issues/1034 and
    // https://github.com/apple/swift-protobuf/issues/1182
    try { if let v = self._event {
      try visitor.visitSingularMessageField(value: v, fieldNumber: 1)
    } }()
    try unknownFields.traverse(visitor: &visitor)
  }

  static func ==(lhs: Spark_Connect_PipelineEventResult, rhs: Spark_Connect_PipelineEventResult) -> Bool {
    if lhs._event != rhs._event {return false}
    if lhs.unknownFields != rhs.unknownFields {return false}
    return true
  }
}

extension Spark_Connect_PipelineEvent: SwiftProtobuf.Message, SwiftProtobuf._MessageImplementationBase, SwiftProtobuf._ProtoNameProviding {
  static let protoMessageName: String = _protobuf_package + ".PipelineEvent"
  static let _protobuf_nameMap: SwiftProtobuf._NameMap = [
    1: .same(proto: "timestamp"),
    2: .same(proto: "message"),
  ]

  mutating func decodeMessage<D: SwiftProtobuf.Decoder>(decoder: inout D) throws {
    while let fieldNumber = try decoder.nextFieldNumber() {
      // The use of inline closures is to circumvent an issue where the compiler
      // allocates stack space for every case branch when no optimizations are
      // enabled. https://github.com/apple/swift-protobuf/issues/1034
      switch fieldNumber {
      case 1: try { try decoder.decodeSingularMessageField(value: &self._timestamp) }()
      case 2: try { try decoder.decodeSingularStringField(value: &self._message) }()
      default: break
      }
    }
  }

  func traverse<V: SwiftProtobuf.Visitor>(visitor: inout V) throws {
    // The use of inline closures is to circumvent an issue where the compiler
    // allocates stack space for every if/case branch local when no optimizations
    // are enabled. https://github.com/apple/swift-protobuf/issues/1034 and
    // https://github.com/apple/swift-protobuf/issues/1182
    try { if let v = self._timestamp {
      try visitor.visitSingularMessageField(value: v, fieldNumber: 1)
    } }()
    try { if let v = self._message {
      try visitor.visitSingularStringField(value: v, fieldNumber: 2)
    } }()
    try unknownFields.traverse(visitor: &visitor)
  }

  static func ==(lhs: Spark_Connect_PipelineEvent, rhs: Spark_Connect_PipelineEvent) -> Bool {
    if lhs._timestamp != rhs._timestamp {return false}
    if lhs._message != rhs._message {return false}
    if lhs.unknownFields != rhs.unknownFields {return false}
    return true
  }
}
